/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityParticleBunch
extends Entity {
    private static final int ACCELERATION_SOUND_UPDATE_TICKS = 10;
    private static final double[] PARTICLE_BUNCH_ENERGY_TO_X = new double[]{0.1, 1.0, 10.0, 100.0};
    private static final double[] PARTICLE_BUNCH_ENERGY_TO_SOUND_Y = new double[]{0.0, 1.0, 2.0, 3.0};
    private static final String[] PARTICLE_BUNCH_SOUNDS = new String[]{"warpdrive:accelerating_low", "warpdrive:accelerating_medium", "warpdrive:accelerating_high"};
    private static final int DATA_WATCHER_ENERGY = 2;
    public Vector3 vectorNextPosition = new Vector3(0.0, 0.0, 0.0);
    public Vector3 vectorTurningPoint = null;
    private int lastUpdateTicks = 0;
    private static final int UPDATE_TICKS_TIMEOUT = 20;
    private int soundTicks;

    public EntityParticleBunch(World world) {
        super(world);
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info((Object)((Object)this) + " created in dimension " + this.field_70170_p.field_73011_w.func_80007_l());
        }
    }

    public EntityParticleBunch(World world, double x, double y, double z) {
        super(world);
        this.field_70165_t = x + 0.5;
        this.field_70163_u = y + 0.5;
        this.field_70161_v = z + 0.5;
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info((Object)((Object)this) + " created");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int p_70056_9_) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public boolean func_85032_ar() {
        return true;
    }

    public void onRefreshFromSimulation(double newEnergy, Vector3 vectorNewPosition, Vector3 vectorNewTurningPoint) {
        this.func_70107_b(this.vectorNextPosition.x, this.vectorNextPosition.y, this.vectorNextPosition.z);
        this.setEnergy((float)newEnergy);
        this.vectorNextPosition = vectorNewPosition;
        this.vectorTurningPoint = vectorNewTurningPoint;
        this.lastUpdateTicks = 0;
    }

    public float getEnergy() {
        return this.field_70180_af.func_111145_d(2);
    }

    public void setEnergy(float energy) {
        this.field_70180_af.func_75692_b(2, (Object)Float.valueOf(energy));
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ++this.lastUpdateTicks;
        if (this.lastUpdateTicks > 20) {
            this.func_70106_y();
        }
        --this.soundTicks;
        if (this.soundTicks < 0) {
            double factor = Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_X, PARTICLE_BUNCH_ENERGY_TO_SOUND_Y, this.getEnergy());
            int indexSound = (int)Math.floor(factor);
            String sound = PARTICLE_BUNCH_SOUNDS[Commons.clamp(0, PARTICLE_BUNCH_SOUNDS.length - 1, indexSound)];
            float pitch = 0.6f + 0.4f * (float)(factor - (double)indexSound);
            this.soundTicks = (int)Math.floor(10.0f * pitch);
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, 1.0f, pitch);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(2, (Object)Float.valueOf(0.0f));
        this.func_70105_a(2.0f, 2.0f);
        this.field_70129_M = 2.0f;
        this.field_70145_X = true;
        this.soundTicks = 0;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info((Object)((Object)this) + " dead");
        }
    }

    public void func_110123_P() {
        super.func_110123_P();
        this.func_70106_y();
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
        this.vectorNextPosition = Vector3.createFromNBT(tagCompound.func_74775_l("nextPosition"));
        if (tagCompound.func_74764_b("turningPoint")) {
            this.vectorTurningPoint = Vector3.createFromNBT(tagCompound.func_74775_l("turningPoint"));
        }
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74782_a("nextPosition", (NBTBase)this.vectorNextPosition.writeToNBT(new NBTTagCompound()));
        if (this.vectorTurningPoint != null) {
            tagCompound.func_74782_a("turningPoint", (NBTBase)this.vectorTurningPoint.writeToNBT(new NBTTagCompound()));
        }
    }

    public void func_70109_d(NBTTagCompound tagCompound) {
        super.func_70109_d(tagCompound);
    }

    public boolean func_98035_c(NBTTagCompound tagCompound) {
        return false;
    }

    public boolean func_70039_c(NBTTagCompound tagCompound) {
        return false;
    }

    public String toString() {
        return String.format("%s/%d @ '%s' %.2f %.2f %.2f", ((Object)((Object)this)).getClass().getSimpleName(), this.func_145782_y(), this.field_70170_p == null ? "~NULL~" : this.field_70170_p.field_73011_w.func_80007_l(), this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }
}

