/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ExceptionChunkNotLoaded;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.ChunkData;
import cr0s.warpdrive.data.StateAir;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkHandler {
    private static final long CHUNK_HANDLER_UNLOADED_CHUNK_MAX_AGE_MS = 30000L;
    private static final Map<Integer, Map<Long, ChunkData>> registryClient = new HashMap<Integer, Map<Long, ChunkData>>(32);
    private static final Map<Integer, Map<Long, ChunkData>> registryServer = new HashMap<Integer, Map<Long, ChunkData>>(32);
    public static long delayLogging = 0L;

    @SubscribeEvent
    public void onLoadWorld(WorldEvent.Load event) {
        if ((event.world.field_72995_K || event.world.field_73011_w.field_76574_g == 0) && WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s load.", event.world.field_72995_K ? "Client" : "Server", event.world.field_73011_w.func_80007_l()));
        }
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            String filename = String.format("%s/%s.dat", event.world.func_72860_G().func_75765_b().getPath(), "WarpDrive");
            NBTTagCompound tagCompound = Commons.readNBTFromFile(filename);
            WarpDrive.starMap.readFromNBT(tagCompound);
        }
    }

    public static void onGenerated(World world, int chunkX, int chunkZ) {
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s chunk [%d, %d] generating", world.field_72995_K ? "Client" : "Server", world.field_73011_w.func_80007_l(), chunkX, chunkZ));
        }
        ChunkData chunkData = ChunkHandler.getChunkData(world.field_72995_K, world.field_73011_w.field_76574_g, chunkX, chunkZ, true);
        assert (chunkData != null);
        if (!chunkData.isLoaded()) {
            chunkData.load(new NBTTagCompound());
        }
    }

    @SubscribeEvent
    public void onLoadChunkData(ChunkDataEvent.Load event) {
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s chunk %s loading data (1)", event.world.field_72995_K ? "Client" : "Server", event.world.field_73011_w.func_80007_l(), event.getChunk().func_76632_l()));
        }
        ChunkData chunkData = ChunkHandler.getChunkData(event.world.field_72995_K, event.world.field_73011_w.field_76574_g, event.getChunk().field_76635_g, event.getChunk().field_76647_h, true);
        assert (chunkData != null);
        chunkData.load(event.getData());
    }

    @SubscribeEvent
    public void onLoadChunk(ChunkEvent.Load event) {
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s chunk %s loaded (2)", event.world.field_72995_K ? "Client" : "Server", event.world.field_73011_w.func_80007_l(), event.getChunk().func_76632_l()));
        }
        ChunkData chunkData = ChunkHandler.getChunkData(event.world.field_72995_K, event.world.field_73011_w.field_76574_g, event.getChunk().field_76635_g, event.getChunk().field_76647_h, true);
        assert (chunkData != null);
        if (!chunkData.isLoaded()) {
            chunkData.load(new NBTTagCompound());
        }
    }

    @SubscribeEvent
    public void onSaveChunkData(ChunkDataEvent.Save event) {
        ChunkData chunkData;
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s chunk %s save data", event.world.field_72995_K ? "Client" : "Server", event.world.field_73011_w.func_80007_l(), event.getChunk().func_76632_l()));
        }
        if ((chunkData = ChunkHandler.getChunkData(event.world.field_72995_K, event.world.field_73011_w.field_76574_g, event.getChunk().field_76635_g, event.getChunk().field_76647_h, false)) != null) {
            chunkData.save(event.getData());
        } else if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.error(String.format("%s world %s chunk %s is saving data without loading it first!", event.world.field_72995_K ? "Client" : "Server", event.world.field_73011_w.func_80007_l(), event.getChunk().func_76632_l()));
        }
    }

    @SubscribeEvent
    public void onSaveWorld(WorldEvent.Save event) {
        if (event.world.field_73011_w.field_76574_g != 0) {
            return;
        }
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s saved.", event.world.field_72995_K ? "Client" : "Server", event.world.field_73011_w.func_80007_l()));
        }
        if (event.world.field_72995_K) {
            return;
        }
        String filename = String.format("%s/%s.dat", event.world.func_72860_G().func_75765_b().getPath(), "WarpDrive");
        NBTTagCompound tagCompound = new NBTTagCompound();
        WarpDrive.starMap.writeToNBT(tagCompound);
        Commons.writeNBTToFile(filename, tagCompound);
    }

    @SubscribeEvent
    public void onUnloadWorld(WorldEvent.Unload event) {
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s unload", event.world.field_72995_K ? "Client" : "Server", event.world.field_73011_w.func_80007_l()));
        }
        LocalProfiler.updateCallStat("onUnloadWorld");
        Map<Integer, Map<Long, ChunkData>> registry = event.world.field_72995_K ? registryClient : registryServer;
        Map<Long, ChunkData> mapRegistryItems = registry.get(event.world.field_73011_w.field_76574_g);
        if (mapRegistryItems != null) {
            for (ChunkData chunkData : mapRegistryItems.values()) {
                if (!chunkData.isLoaded()) continue;
                chunkData.unload();
            }
        }
    }

    @SubscribeEvent
    public void onUnloadChunk(ChunkEvent.Unload event) {
        ChunkData chunkData;
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s chunk %s unload", event.world.field_72995_K ? "Client" : "Server", event.world.field_73011_w.func_80007_l(), event.getChunk().func_76632_l()));
        }
        if ((chunkData = ChunkHandler.getChunkData(event.world.field_72995_K, event.world.field_73011_w.field_76574_g, event.getChunk().field_76635_g, event.getChunk().field_76647_h, false)) != null) {
            chunkData.unload();
        } else if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.error(String.format("%s world %s chunk %s is unloading without loading it first!", event.world.field_72995_K ? "Client" : "Server", event.world.field_73011_w.func_80007_l(), event.getChunk().func_76632_l()));
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        ChunkHandler.updateTick(event.world);
    }

    public static void onBlockUpdated(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            ChunkData chunkData = ChunkHandler.getChunkData(world, x, y, z);
            if (chunkData != null) {
                chunkData.onBlockUpdated(x, y, z);
            } else if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                WarpDrive.logger.error(String.format("%s world %s block updating at (%d %d %d), while chunk isn't loaded!", world.field_72995_K ? "Client" : "Server", world.field_73011_w.func_80007_l(), x, y, z));
                Commons.dumpAllThreads();
            }
        }
    }

    public static ChunkData getChunkData(World world, int x, int y, int z) {
        ChunkData chunkData = ChunkHandler.getChunkData(world.field_72995_K, world.field_73011_w.field_76574_g, x, y, z);
        if (chunkData == null) {
            WarpDrive.logger.error(String.format("Trying to get data from an non-loaded chunk in %s world %s @ (%d %d %d)", world.field_72995_K ? "Client" : "Server", world.field_73011_w.func_80007_l(), x, y, z));
            LocalProfiler.printCallStats();
            Commons.dumpAllThreads();
            assert (false);
        }
        return chunkData;
    }

    private static ChunkData getChunkData(boolean isRemote, int dimensionId, int x, int y, int z) {
        assert (y >= -1 && y <= 256);
        return ChunkHandler.getChunkData(isRemote, dimensionId, x >> 4, z >> 4, false);
    }

    private static ChunkData getChunkData(boolean isRemote, int dimensionId, int xChunk, int zChunk, boolean doCreate) {
        long index;
        ChunkData chunkData;
        LocalProfiler.updateCallStat("getChunkData");
        Map<Integer, Map<Long, ChunkData>> registry = isRemote ? registryClient : registryServer;
        Map<Long, ChunkData> mapRegistryItems = registry.get(dimensionId);
        if (mapRegistryItems == null) {
            if (!doCreate) {
                return null;
            }
            mapRegistryItems = new LinkedHashMap<Long, ChunkData>(2048);
            registry.put(dimensionId, mapRegistryItems);
        }
        if ((chunkData = mapRegistryItems.get(index = ChunkCoordIntPair.func_77272_a((int)xChunk, (int)zChunk))) == null) {
            if (!doCreate) {
                if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
                    WarpDrive.logger.info(String.format("getChunkData(%s, %d, %d, %d, false) returning null", isRemote, dimensionId, xChunk, zChunk));
                }
                return null;
            }
            chunkData = new ChunkData(xChunk, zChunk);
            if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
                WarpDrive.logger.info(String.format("%s world DIM%d chunk %s is being added to the registry", isRemote ? "Client" : "Server", dimensionId, chunkData.getChunkCoords()));
            }
            if (Commons.isSafeThread()) {
                mapRegistryItems.put(index, chunkData);
            } else {
                WarpDrive.logger.error(String.format("%s world DIM%d chunk %s is being added to the registry outside main thread!", isRemote ? "Client" : "Server", dimensionId, chunkData.getChunkCoords()));
                Commons.dumpAllThreads();
                mapRegistryItems.put(index, chunkData);
            }
        }
        return chunkData;
    }

    private static boolean isLoaded(Map<Long, ChunkData> mapRegistryItems, int xChunk, int zChunk) {
        long index = ChunkCoordIntPair.func_77272_a((int)xChunk, (int)zChunk);
        ChunkData chunkData = mapRegistryItems.get(index);
        return chunkData != null && chunkData.isLoaded();
    }

    public static boolean isLoaded(World world, int x, int y, int z) {
        ChunkData chunkData = ChunkHandler.getChunkData(world.field_72995_K, world.field_73011_w.field_76574_g, x, y, z);
        return chunkData != null && chunkData.isLoaded();
    }

    public static StateAir getStateAir(World world, int x, int y, int z) {
        ChunkData chunkData = ChunkHandler.getChunkData(world, x, y, z);
        if (chunkData == null) {
            return null;
        }
        try {
            return chunkData.getStateAir(world, x, y, z);
        }
        catch (ExceptionChunkNotLoaded exceptionChunkNotLoaded) {
            WarpDrive.logger.warn(String.format("Aborting air evaluation: chunk isn't loaded @ %s (%d %d %d)", world.field_73011_w.func_80007_l(), x, y, z));
            return null;
        }
    }

    private static void updateTick(World world) {
        LocalProfiler.updateCallStat("updateTick");
        Map<Integer, Map<Long, ChunkData>> registry = world.field_72995_K ? registryClient : registryServer;
        Map<Long, ChunkData> mapRegistryItems = registry.get(world.field_73011_w.field_76574_g);
        if (mapRegistryItems == null) {
            return;
        }
        int countLoaded = 0;
        long timeForRemoval = System.currentTimeMillis() - 30000L;
        long timeForThrottle = System.currentTimeMillis() + 200L;
        long sizeBefore = mapRegistryItems.size();
        try {
            Iterator<Map.Entry<Long, ChunkData>> entryIterator = mapRegistryItems.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry<Long, ChunkData> entryChunkData = entryIterator.next();
                ChunkData chunkData = entryChunkData.getValue();
                if (chunkData.isLoaded()) {
                    ++countLoaded;
                    if (System.currentTimeMillis() >= timeForThrottle) continue;
                    ChunkHandler.updateTickLoopStep(world, mapRegistryItems, entryChunkData.getValue());
                    continue;
                }
                if (chunkData.timeUnloaded >= timeForRemoval) continue;
                if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
                    WarpDrive.logger.info(String.format("%s world %s chunk %s is being removed from updateTick (size is %d)", world.field_72995_K ? "Client" : "Server", world.field_73011_w.func_80007_l(), chunkData.getChunkCoords(), mapRegistryItems.size()));
                }
                entryIterator.remove();
            }
        }
        catch (ConcurrentModificationException exception) {
            WarpDrive.logger.error(String.format("%s world %s had some chunks changed outside main thread? (size %d -> %d)", world.field_72995_K ? "Client" : "Server", world.field_73011_w.func_80007_l(), sizeBefore, mapRegistryItems.size()));
            exception.printStackTrace();
            LocalProfiler.printCallStats();
        }
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            if (world.field_73011_w.field_76574_g == 0) {
                delayLogging = (delayLogging + 1L) % 4096L;
            }
            if (delayLogging == 1L) {
                WarpDrive.logger.info(String.format("Dimension %d has %d / %d chunks loaded", world.field_73011_w.field_76574_g, countLoaded, mapRegistryItems.size()));
            }
        }
    }

    private static void updateTickLoopStep(World world, Map<Long, ChunkData> mapRegistryItems, ChunkData chunkData) {
        ChunkCoordIntPair chunkCoordIntPair = chunkData.getChunkCoords();
        if (chunkData.isNotEmpty() && ChunkHandler.isLoaded(mapRegistryItems, chunkCoordIntPair.field_77276_a + 1, chunkCoordIntPair.field_77275_b) && ChunkHandler.isLoaded(mapRegistryItems, chunkCoordIntPair.field_77276_a - 1, chunkCoordIntPair.field_77275_b) && ChunkHandler.isLoaded(mapRegistryItems, chunkCoordIntPair.field_77276_a, chunkCoordIntPair.field_77275_b + 1) && ChunkHandler.isLoaded(mapRegistryItems, chunkCoordIntPair.field_77276_a, chunkCoordIntPair.field_77275_b - 1)) {
            chunkData.updateTick(world);
        }
    }
}

