/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ClientHandler {
    private boolean isSneaking;
    private boolean isCreativeMode;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTooltipEvent(ItemTooltipEvent event) {
        int[] idOres;
        int fuelValue;
        if (event.entityPlayer == null) {
            return;
        }
        if (Dictionary.ITEMS_BREATHING_HELMET.contains(event.itemStack.func_77973_b())) {
            Commons.addTooltip(event.toolTip, StatCollector.func_74837_a((String)"warpdrive.tooltip.item_tag.breathing_helmet", (Object[])new Object[0]));
        }
        if (Dictionary.ITEMS_FLYINSPACE.contains(event.itemStack.func_77973_b())) {
            Commons.addTooltip(event.toolTip, StatCollector.func_74837_a((String)"warpdrive.tooltip.item_tag.fly_in_space", (Object[])new Object[0]));
        }
        if (Dictionary.ITEMS_NOFALLDAMAGE.contains(event.itemStack.func_77973_b())) {
            Commons.addTooltip(event.toolTip, StatCollector.func_74837_a((String)"warpdrive.tooltip.item_tag.no_fall_damage", (Object[])new Object[0]));
        }
        this.isSneaking = event.entityPlayer.func_70093_af();
        this.isCreativeMode = event.entityPlayer.field_71075_bZ.field_75098_d;
        Block block = Block.func_149634_a((Item)event.itemStack.func_77973_b());
        if (block != Blocks.field_150350_a) {
            this.addBlockDetails(event, block);
        } else {
            this.addItemDetails(event, event.itemStack.func_77973_b());
        }
        if (WarpDriveConfig.CLIENT_TOOLTIP_BURN_TIME.isEnabled(this.isSneaking, this.isCreativeMode) && (fuelValue = GameRegistry.getFuelValue((ItemStack)event.itemStack)) > 0) {
            Commons.addTooltip(event.toolTip, String.format("Burn time is %d (%.1f ores)", fuelValue, Float.valueOf((float)fuelValue / 200.0f)));
        }
        if (WarpDriveConfig.CLIENT_TOOLTIP_ORE_DICTIONARY_NAME.isEnabled(this.isSneaking, this.isCreativeMode) && (idOres = OreDictionary.getOreIDs((ItemStack)event.itemStack)).length != 0) {
            Commons.addTooltip(event.toolTip, "Ore dictionary names:");
            for (int idOre : idOres) {
                String nameOre = OreDictionary.getOreName((int)idOre);
                Commons.addTooltip(event.toolTip, "- " + nameOre);
            }
        }
    }

    public void addBlockDetails(ItemTooltipEvent event, Block block) {
        if (WarpDriveConfig.CLIENT_TOOLTIP_REGISTRY_NAME.isEnabled(this.isSneaking, this.isCreativeMode)) {
            try {
                String uniqueName = Block.field_149771_c.func_148750_c((Object)block);
                if (uniqueName != null) {
                    Commons.addTooltip(event.toolTip, uniqueName);
                }
            }
            catch (Exception uniqueName) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.CLIENT_TOOLTIP_HARVESTING.isEnabled(this.isSneaking, this.isCreativeMode)) {
            try {
                String harvestTool = block.getHarvestTool(event.itemStack.func_77960_j());
                if (harvestTool != null) {
                    Commons.addTooltip(event.toolTip, String.format("Harvest with %s (%d)", harvestTool, block.getHarvestLevel(event.itemStack.func_77960_j())));
                }
            }
            catch (Exception harvestTool) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.CLIENT_TOOLTIP_OPACITY.isEnabled(this.isSneaking, this.isCreativeMode)) {
            Commons.addTooltip(event.toolTip, String.format("Light opacity is %d", block.func_149717_k()));
        }
        if (WarpDriveConfig.CLIENT_TOOLTIP_HARDNESS.isEnabled(this.isSneaking, this.isCreativeMode)) {
            try {
                Commons.addTooltip(event.toolTip, String.format("Hardness is %.1f", Float.valueOf(((Float)WarpDrive.fieldBlockHardness.get(block)).floatValue())));
            }
            catch (Exception harvestTool) {
                // empty catch block
            }
            Commons.addTooltip(event.toolTip, String.format("Explosion resistance is %.1f", Float.valueOf(block.func_149638_a(null))));
        }
        if (WarpDriveConfig.CLIENT_TOOLTIP_FLAMMABILITY.isEnabled(this.isSneaking, this.isCreativeMode)) {
            try {
                int flammability = Blocks.field_150480_ab.getFlammability(block);
                int fireSpread = Blocks.field_150480_ab.getEncouragement(block);
                if (flammability > 0) {
                    Commons.addTooltip(event.toolTip, String.format("Flammable: %d, spread %d", flammability, fireSpread));
                }
            }
            catch (Exception flammability) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.CLIENT_TOOLTIP_FLUID.isEnabled(this.isSneaking, this.isCreativeMode)) {
            try {
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
                if (fluid != null) {
                    if (fluid.isGaseous()) {
                        Commons.addTooltip(event.toolTip, String.format("Gaz viscosity is %d", fluid.getViscosity()));
                        Commons.addTooltip(event.toolTip, String.format("Gaz density is %d", fluid.getDensity()));
                    } else {
                        Commons.addTooltip(event.toolTip, String.format("Liquid viscosity is %d", fluid.getViscosity()));
                        Commons.addTooltip(event.toolTip, String.format("Liquid density is %d", fluid.getDensity()));
                    }
                    Commons.addTooltip(event.toolTip, String.format("Temperature is %d K", fluid.getTemperature()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addItemDetails(ItemTooltipEvent event, Item item) {
        if (WarpDriveConfig.CLIENT_TOOLTIP_REGISTRY_NAME.isEnabled(this.isSneaking, this.isCreativeMode)) {
            try {
                String uniqueName = Item.field_150901_e.func_148750_c((Object)item);
                if (uniqueName != null) {
                    Commons.addTooltip(event.toolTip, uniqueName);
                }
            }
            catch (Exception uniqueName) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.CLIENT_TOOLTIP_DURABILITY.isEnabled(this.isSneaking, this.isCreativeMode)) {
            try {
                if (event.itemStack.func_77984_f()) {
                    Commons.addTooltip(event.toolTip, String.format("Durability: %d / %d", event.itemStack.func_77958_k() - event.itemStack.func_77960_j(), event.itemStack.func_77958_k()));
                }
            }
            catch (Exception uniqueName) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.CLIENT_TOOLTIP_ARMOR.isEnabled(this.isSneaking, this.isCreativeMode)) {
            try {
                if (item instanceof ItemArmor) {
                    Item itemRepair;
                    Commons.addTooltip(event.toolTip, String.format("Armor points: %d", ((ItemArmor)item).field_77879_b));
                    ItemArmor.ArmorMaterial armorMaterial = ((ItemArmor)item).func_82812_d();
                    Commons.addTooltip(event.toolTip, String.format("Enchantability: %d", armorMaterial.func_78045_a()));
                    if (WarpDriveConfig.CLIENT_TOOLTIP_REPAIR_WITH.isEnabled(this.isSneaking, this.isCreativeMode) && (itemRepair = armorMaterial.func_151685_b()) != null) {
                        Commons.addTooltip(event.toolTip, String.format("Repair with %s", armorMaterial.func_151685_b().func_77658_a()));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

