/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ISequencerCallbacks;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.data.EnumShipMovementType;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.event.JumpSequencer;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class DeploySequencer
extends JumpSequencer {
    private String playerName;
    private ISequencerCallbacks callback;

    public DeploySequencer(JumpShip jumpShip, World world, boolean isInstantiated, int destX, int destY, int destZ, byte rotationSteps) {
        super(jumpShip, world, isInstantiated ? EnumShipMovementType.INSTANTIATE : EnumShipMovementType.RESTORE, destX, destY, destZ, rotationSteps);
    }

    public void setCaptain(String playerName) {
        this.playerName = playerName;
        this.ship.setCaptain(playerName);
    }

    public void setCallback(ISequencerCallbacks object) {
        this.callback = object;
    }

    @Override
    public void disable(boolean isSuccessful, String reason) {
        super.disable(isSuccessful, reason);
        this.callback.sequencer_finished();
    }

    @Override
    protected void state_chunkReleasing() {
        EntityPlayerMP entityPlayerMP;
        super.state_chunkReleasing();
        if (this.playerName != null && (entityPlayerMP = Commons.getOnlinePlayerByName(this.playerName)) != null) {
            Commons.addChatMessage((ICommandSender)entityPlayerMP, "Ship deployed. Teleporting captain to the main deck...");
        }
    }

    @Override
    protected void state_finishing() {
        EntityPlayerMP entityPlayerMP;
        if (this.playerName != null && !this.playerName.isEmpty() && (entityPlayerMP = Commons.getOnlinePlayerByName(this.playerName)) != null) {
            TileEntity tileEntity = this.targetWorld.func_147438_o(this.destX, this.destY, this.destZ);
            if (tileEntity instanceof TileEntityShipCore) {
                boolean isSuccess = ((TileEntityShipCore)tileEntity).summonOwnerOnDeploy(entityPlayerMP);
                if (isSuccess) {
                    Commons.addChatMessage((ICommandSender)entityPlayerMP, "\u00c2\u00a76Welcome aboard captain. Use the computer to get moving...");
                } else {
                    WarpDrive.logger.warn(String.format("Failed to assign new captain %s", this.playerName));
                }
            } else {
                WarpDrive.logger.warn(String.format("Unable to detect ship core after deployment, found %s", tileEntity));
            }
        }
        super.state_finishing();
    }
}

