/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cpw.mods.fml.common.eventhandler.Event;
import cr0s.warpdrive.CommonProxy;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.EventWarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.block.movement.TileEntityShipController;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumJumpSequencerState;
import cr0s.warpdrive.data.EnumShipMovementType;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.Transformation;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.event.AbstractSequencer;
import cr0s.warpdrive.network.PacketHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;

public class JumpSequencer
extends AbstractSequencer {
    protected Transformation transformation;
    private final EnumShipMovementType shipMovementType;
    private int moveX;
    private int moveY;
    private int moveZ;
    private final byte rotationSteps;
    private final String nameTarget;
    protected final int destX;
    protected final int destY;
    protected final int destZ;
    private Vector3 v3Source;
    private int blocksPerTick = WarpDriveConfig.G_BLOCKS_PER_TICK;
    private static final boolean enforceEntitiesPosition = false;
    protected final World sourceWorld;
    protected World targetWorld;
    private ForgeChunkManager.Ticket sourceWorldTicket;
    private ForgeChunkManager.Ticket targetWorldTicket;
    private boolean collisionDetected = false;
    private ArrayList<Vector3> collisionAtSource;
    private ArrayList<Vector3> collisionAtTarget;
    private float collisionStrength = 0.0f;
    protected boolean isEnabled = false;
    private EnumJumpSequencerState enumJumpSequencerState = EnumJumpSequencerState.IDLE;
    private int actualIndexInShip = 0;
    protected final JumpShip ship;
    private boolean betweenWorlds;
    private boolean isPluginCheckDone = false;
    private String firstAdjustmentReason = "";
    private long msCounter = 0L;
    private int ticks = 0;

    public JumpSequencer(TileEntityShipCore shipCore, EnumShipMovementType shipMovementType, String nameTarget, int moveX, int moveY, int moveZ, byte rotationSteps, int destX, int destY, int destZ) {
        this.sourceWorld = shipCore.func_145831_w();
        this.ship = new JumpShip();
        this.ship.worldObj = this.sourceWorld;
        this.ship.coreX = shipCore.field_145851_c;
        this.ship.coreY = shipCore.field_145848_d;
        this.ship.coreZ = shipCore.field_145849_e;
        this.ship.dx = shipCore.facing.offsetX;
        this.ship.dz = shipCore.facing.offsetZ;
        this.ship.minX = shipCore.minX;
        this.ship.maxX = shipCore.maxX;
        this.ship.minY = shipCore.minY;
        this.ship.maxY = shipCore.maxY;
        this.ship.minZ = shipCore.minZ;
        this.ship.maxZ = shipCore.maxZ;
        this.ship.shipCore = shipCore;
        this.shipMovementType = shipMovementType;
        this.moveX = moveX;
        this.moveY = moveY;
        this.moveZ = moveZ;
        this.rotationSteps = rotationSteps;
        this.nameTarget = nameTarget;
        this.destX = destX;
        this.destY = destY;
        this.destZ = destZ;
        this.v3Source = null;
        this.targetWorld = null;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s Sequencer created for shipCore %s with shipMovementType %s", this, shipCore, shipMovementType));
        }
    }

    public JumpSequencer(JumpShip jumpShip, World world, EnumShipMovementType enumShipMovementType, int destX, int destY, int destZ, byte rotationSteps) {
        this.sourceWorld = null;
        this.ship = jumpShip;
        this.shipMovementType = enumShipMovementType;
        this.rotationSteps = rotationSteps;
        this.nameTarget = null;
        this.destX = destX;
        this.destY = destY;
        this.destZ = destZ;
        this.targetWorld = world;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s Sequencer created for ship %s with shipMovementType %s", this, this.ship, this.shipMovementType));
        }
    }

    public void setBlocksPerTick(int blocksPerTick) {
        this.blocksPerTick = Math.min(WarpDriveConfig.G_BLOCKS_PER_TICK, blocksPerTick);
    }

    public void setEffectSource(Vector3 v3Source) {
        this.v3Source = v3Source;
    }

    public void enable() {
        this.isEnabled = true;
        this.register();
    }

    public void disable(boolean isSuccessful, String reason) {
        EventWarpDrive.Ship.JumpResult jumpResult;
        if (!this.isEnabled) {
            return;
        }
        this.isEnabled = false;
        if (WarpDriveConfig.LOGGING_JUMP) {
            if (reason == null || reason.isEmpty()) {
                WarpDrive.logger.info(this + " Killing jump sequencer...");
            } else {
                WarpDrive.logger.info(this + " Killing jump sequencer... (" + reason + ")");
            }
        }
        if (!isSuccessful) {
            jumpResult = new EventWarpDrive.Ship.JumpResult(this.sourceWorld, this.ship.coreX, this.ship.coreY, this.ship.coreZ, this.ship.shipCore.getShipController(), this.shipMovementType.getName(), false, reason);
        } else {
            ChunkCoordinates coordTargetCore = this.transformation.apply(this.ship.coreX, this.ship.coreY, this.ship.coreZ);
            TileEntity tileEntity = this.targetWorld.func_147438_o(coordTargetCore.field_71574_a, coordTargetCore.field_71572_b, coordTargetCore.field_71573_c);
            TileEntityShipController shipController = tileEntity instanceof TileEntityShipCore ? ((TileEntityShipCore)tileEntity).getShipController() : null;
            jumpResult = new EventWarpDrive.Ship.JumpResult(this.targetWorld, coordTargetCore.field_71574_a, coordTargetCore.field_71572_b, coordTargetCore.field_71573_c, shipController, this.shipMovementType.getName(), true, reason);
        }
        MinecraftForge.EVENT_BUS.post((Event)jumpResult);
        this.releaseChunks();
        this.unregister();
    }

    @Override
    public boolean onUpdate() {
        if (this.sourceWorld != null && this.sourceWorld.field_72995_K || this.targetWorld != null && this.targetWorld.field_72995_K) {
            return false;
        }
        if (!this.isEnabled) {
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(this + " Removing from onUpdate...");
            }
            return false;
        }
        if (this.ship.minY < 0 || this.ship.maxY > 255) {
            String msg = "Invalid Y coordinate(s), check ship dimensions...";
            this.ship.messageToAllPlayersOnShip("Invalid Y coordinate(s), check ship dimensions...");
            this.disable(false, "Invalid Y coordinate(s), check ship dimensions...");
            return true;
        }
        ++this.ticks;
        switch (this.enumJumpSequencerState) {
            case IDLE: {
                this.msCounter = System.currentTimeMillis();
                if (!this.isEnabled) break;
                if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
                    this.enumJumpSequencerState = EnumJumpSequencerState.LOAD_SOURCE_CHUNKS;
                    break;
                }
                this.enumJumpSequencerState = EnumJumpSequencerState.GET_INITIAL_VECTOR;
                break;
            }
            case LOAD_SOURCE_CHUNKS: {
                this.state_chunkLoadingSource();
                if (!this.isEnabled) break;
                this.actualIndexInShip = 0;
                this.enumJumpSequencerState = EnumJumpSequencerState.SAVE_TO_MEMORY;
                break;
            }
            case SAVE_TO_MEMORY: {
                this.state_saveToMemory();
                if (!this.isEnabled) break;
                this.actualIndexInShip = 0;
                this.enumJumpSequencerState = EnumJumpSequencerState.CHECK_BORDERS;
                break;
            }
            case CHECK_BORDERS: {
                this.state_checkBorders();
                if (!this.isEnabled) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.SAVE_TO_DISK;
                break;
            }
            case SAVE_TO_DISK: {
                this.state_saveToDisk();
                if (!this.isEnabled) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.GET_INITIAL_VECTOR;
                break;
            }
            case GET_INITIAL_VECTOR: {
                this.state_getInitialVector();
                if (!this.isEnabled) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.ADJUST_JUMP_VECTOR;
                break;
            }
            case ADJUST_JUMP_VECTOR: {
                this.state_adjustJumpVector();
                if (!this.isEnabled) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.LOAD_TARGET_CHUNKS;
                break;
            }
            case LOAD_TARGET_CHUNKS: {
                this.state_loadTargetChunks();
                if (!this.isEnabled) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.SAVE_ENTITIES;
                break;
            }
            case SAVE_ENTITIES: {
                this.state_saveEntitiesAndInformPlayers();
                if (!this.isEnabled) break;
                this.actualIndexInShip = 0;
                this.enumJumpSequencerState = EnumJumpSequencerState.MOVE_BLOCKS;
                break;
            }
            case MOVE_BLOCKS: {
                this.state_moveBlocks();
                if (this.actualIndexInShip < this.ship.jumpBlocks.length - 1) break;
                this.actualIndexInShip = 0;
                this.enumJumpSequencerState = EnumJumpSequencerState.MOVE_EXTERNALS;
                break;
            }
            case MOVE_EXTERNALS: {
                this.state_moveExternals();
                if (this.actualIndexInShip < this.ship.jumpBlocks.length - 1) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.MOVE_ENTITIES;
                break;
            }
            case MOVE_ENTITIES: {
                this.state_moveEntities();
                this.actualIndexInShip = 0;
                this.enumJumpSequencerState = EnumJumpSequencerState.REMOVING;
                break;
            }
            case REMOVING: {
                this.state_removeBlocks();
                if (this.actualIndexInShip < this.ship.jumpBlocks.length - 1) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.CHUNK_UNLOADING;
                break;
            }
            case CHUNK_UNLOADING: {
                this.state_chunkReleasing();
                this.enumJumpSequencerState = EnumJumpSequencerState.FINISHING;
                break;
            }
            case FINISHING: {
                this.state_finishing();
                this.enumJumpSequencerState = EnumJumpSequencerState.IDLE;
                break;
            }
            default: {
                String msg = "Invalid state, aborting jump...";
                this.ship.messageToAllPlayersOnShip("Invalid state, aborting jump...");
                this.disable(false, "Invalid state, aborting jump...");
                return true;
            }
        }
        return true;
    }

    private boolean forceSourceChunks(StringBuilder reason) {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Forcing source chunks in " + this.sourceWorld.field_73011_w.func_80007_l());
        }
        this.sourceWorldTicket = ForgeChunkManager.requestTicket((Object)WarpDrive.instance, (World)this.sourceWorld, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.sourceWorldTicket == null) {
            reason.append(String.format("Chunkloading rejected in source world %s. Aborting.", this.sourceWorld.field_73011_w.func_80007_l()));
            return false;
        }
        int minX = this.ship.minX >> 4;
        int maxX = this.ship.maxX >> 4;
        int minZ = this.ship.minZ >> 4;
        int maxZ = this.ship.maxZ >> 4;
        int chunkCount = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (++chunkCount > this.sourceWorldTicket.getMaxChunkListDepth()) {
                    reason.append(String.format("Ship is extending over %d chunks in source world. Max is currently set to %d in config/forgeChunkLoading.cfg. Aborting.", (maxX - minX + 1) * (maxZ - minZ + 1), this.sourceWorldTicket.getMaxChunkListDepth()));
                    return false;
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.sourceWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
            }
        }
        return true;
    }

    private boolean forceTargetChunks(StringBuilder reason) {
        LocalProfiler.start("Jump.forceTargetChunks");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Forcing target chunks in " + this.targetWorld.field_73011_w.func_80007_l());
        }
        this.targetWorldTicket = ForgeChunkManager.requestTicket((Object)WarpDrive.instance, (World)this.targetWorld, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.targetWorldTicket == null) {
            reason.append(String.format("Chunkloading rejected in target world %s. Aborting.", this.targetWorld.field_73011_w.func_80007_l()));
            return false;
        }
        ChunkCoordinates targetMin = this.transformation.apply(this.ship.minX, this.ship.minY, this.ship.minZ);
        ChunkCoordinates targetMax = this.transformation.apply(this.ship.maxX, this.ship.maxY, this.ship.maxZ);
        int minX = Math.min(targetMin.field_71574_a, targetMax.field_71574_a) >> 4;
        int maxX = Math.max(targetMin.field_71574_a, targetMax.field_71574_a) >> 4;
        int minZ = Math.min(targetMin.field_71573_c, targetMax.field_71573_c) >> 4;
        int maxZ = Math.max(targetMin.field_71573_c, targetMax.field_71573_c) >> 4;
        int chunkCount = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (++chunkCount > this.targetWorldTicket.getMaxChunkListDepth()) {
                    reason.append(String.format("Ship is extending over %d chunks in target world. Max is currently set to %d in config/forgeChunkLoading.cfg. Aborting.", (maxX - minX + 1) * (maxZ - minZ + 1), this.targetWorldTicket.getMaxChunkListDepth()));
                    return false;
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.targetWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
            }
        }
        LocalProfiler.stop();
        return true;
    }

    private void releaseChunks() {
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        if (this.sourceWorldTicket == null && this.targetWorldTicket == null) {
            return;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Releasing chunks");
        }
        if (this.sourceWorldTicket != null) {
            minX = this.ship.minX >> 4;
            maxX = this.ship.maxX >> 4;
            minZ = this.ship.minZ >> 4;
            maxZ = this.ship.maxZ >> 4;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.sourceWorld.func_72964_e(x, z).func_76603_b();
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.sourceWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.sourceWorldTicket);
            this.sourceWorldTicket = null;
        }
        if (this.targetWorldTicket != null) {
            ChunkCoordinates targetMin = this.transformation.apply(this.ship.minX, this.ship.minY, this.ship.minZ);
            ChunkCoordinates targetMax = this.transformation.apply(this.ship.maxX, this.ship.maxY, this.ship.maxZ);
            minX = Math.min(targetMin.field_71574_a, targetMax.field_71574_a) >> 4;
            maxX = Math.max(targetMin.field_71574_a, targetMax.field_71574_a) >> 4;
            minZ = Math.min(targetMin.field_71573_c, targetMax.field_71573_c) >> 4;
            maxZ = Math.max(targetMin.field_71573_c, targetMax.field_71573_c) >> 4;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.targetWorld.func_72964_e(x, z).func_76603_b();
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.targetWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.targetWorldTicket);
            this.targetWorldTicket = null;
        }
    }

    protected void state_chunkLoadingSource() {
        LocalProfiler.start("Jump.chunkLoadingSource");
        StringBuilder reason = new StringBuilder();
        if (!this.forceSourceChunks(reason)) {
            String msg = reason.toString();
            this.disable(false, msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    protected void state_saveToMemory() {
        StringBuilder reason;
        LocalProfiler.start("Jump.saveToMemory");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Saving ship...");
        }
        if (!this.ship.save(reason = new StringBuilder())) {
            String msg = reason.toString();
            this.disable(false, msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    protected void state_checkBorders() {
        StringBuilder reason;
        LocalProfiler.start("Jump.checkBorders");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Checking ship borders...");
        }
        if (!this.ship.checkBorders(reason = new StringBuilder())) {
            String msg = reason.toString();
            this.disable(false, msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    protected void state_saveToDisk() {
        LocalProfiler.start("Jump.saveToDisk");
        File file = new File(WarpDriveConfig.G_SCHEMALOCATION + "/auto");
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            WarpDrive.logger.warn("Unable to create auto-backup folder, skipping...");
            LocalProfiler.stop();
            return;
        }
        try {
            Date now;
            String schematicFileName;
            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd_HH'h'mm'm'ss's'SSS");
            String shipName = this.ship.shipCore.shipName.replaceAll("[^ -~]", "").replaceAll("[:/\\\\]", "");
            do {
                now = new Date();
            } while (new File(schematicFileName = WarpDriveConfig.G_SCHEMALOCATION + "/auto/" + shipName + "_" + sdfDate.format(now) + ".schematic").exists());
            NBTTagCompound schematic = new NBTTagCompound();
            short width = (short)(this.ship.shipCore.maxX - this.ship.shipCore.minX + 1);
            short length = (short)(this.ship.shipCore.maxZ - this.ship.shipCore.minZ + 1);
            short height = (short)(this.ship.shipCore.maxY - this.ship.shipCore.minY + 1);
            schematic.func_74777_a("Width", width);
            schematic.func_74777_a("Length", length);
            schematic.func_74777_a("Height", height);
            schematic.func_74768_a("shipMass", this.ship.shipCore.shipMass);
            schematic.func_74778_a("shipName", this.ship.shipCore.shipName);
            schematic.func_74768_a("shipVolume", this.ship.shipCore.shipVolume);
            NBTTagCompound tagCompoundShip = new NBTTagCompound();
            this.ship.writeToNBT(tagCompoundShip);
            schematic.func_74782_a("ship", (NBTBase)tagCompoundShip);
            WarpDrive.logger.info(this + " Saving ship state prior to jump in " + schematicFileName);
            Commons.writeNBTToFile(schematicFileName, schematic);
            if (WarpDriveConfig.LOGGING_JUMP && WarpDrive.isDev) {
                WarpDrive.logger.info(this + " Ship saved as " + schematicFileName);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.msCounter = System.currentTimeMillis();
        LocalProfiler.stop();
    }

    protected void state_getInitialVector() {
        LocalProfiler.start("Jump.getInitialVector");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Getting initial target vector...");
        }
        StringBuilder reason = new StringBuilder();
        this.betweenWorlds = this.shipMovementType == EnumShipMovementType.PLANET_TAKEOFF || this.shipMovementType == EnumShipMovementType.PLANET_LANDING || this.shipMovementType == EnumShipMovementType.HYPERSPACE_EXITING || this.shipMovementType == EnumShipMovementType.HYPERSPACE_ENTERING;
        CelestialObject celestialObjectSource = CelestialObjectManager.get(this.sourceWorld, this.ship.coreX, this.ship.coreZ);
        boolean isTargetWorldFound = this.computeTargetWorld(celestialObjectSource, this.shipMovementType, reason);
        if (!isTargetWorldFound) {
            LocalProfiler.stop();
            this.ship.messageToAllPlayersOnShip(reason.toString());
            this.disable(false, reason.toString());
            return;
        }
        if ((this.sourceWorld != null && CelestialObjectManager.isPlanet(this.sourceWorld, this.ship.coreX, this.ship.coreZ) || CelestialObjectManager.isPlanet(this.targetWorld, this.ship.coreX + this.moveX, this.ship.coreZ + this.moveZ)) && !this.ship.isUnlimited() && this.ship.actualMass > WarpDriveConfig.SHIP_VOLUME_MAX_ON_PLANET_SURFACE) {
            LocalProfiler.stop();
            String msg = String.format("Ship is too big for a planet (max is %d blocks while ship is %d blocks)", WarpDriveConfig.SHIP_VOLUME_MAX_ON_PLANET_SURFACE, this.ship.actualMass);
            this.ship.messageToAllPlayersOnShip(msg);
            this.disable(false, msg);
            return;
        }
        if (this.betweenWorlds && WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " From world " + this.sourceWorld.field_73011_w.func_80007_l() + " to " + this.targetWorld.field_73011_w.func_80007_l());
        }
        this.isPluginCheckDone = false;
        this.firstAdjustmentReason = "";
        switch (this.shipMovementType) {
            case GATE_ACTIVATING: {
                this.moveX = this.destX - this.ship.coreX;
                this.moveY = this.destY - this.ship.coreY;
                this.moveZ = this.destZ - this.ship.coreZ;
                break;
            }
            case INSTANTIATE: 
            case RESTORE: {
                this.moveX = this.destX - this.ship.coreX;
                this.moveY = this.destY - this.ship.coreY;
                this.moveZ = this.destZ - this.ship.coreZ;
                this.isPluginCheckDone = true;
                break;
            }
            case PLANET_TAKEOFF: {
                this.moveY = 0;
                break;
            }
            case PLANET_LANDING: {
                this.moveY = 245 - this.ship.maxY;
                break;
            }
            case PLANET_MOVING: 
            case SPACE_MOVING: 
            case HYPERSPACE_MOVING: {
                int rangeZ;
                int rangeX;
                if (this.ship.maxY + this.moveY > 255) {
                    this.moveY = 255 - this.ship.maxY;
                }
                if (this.ship.minY + this.moveY < 5) {
                    this.moveY = 5 - this.ship.minY;
                }
                if (Math.max(rangeX = Math.abs(this.moveX) - (this.ship.maxX - this.ship.minX), rangeZ = Math.abs(this.moveZ) - (this.ship.maxZ - this.ship.minZ)) >= 256) break;
                this.firstAdjustmentReason = this.getPossibleJumpDistance();
                this.isPluginCheckDone = true;
                break;
            }
            case HYPERSPACE_ENTERING: 
            case HYPERSPACE_EXITING: {
                break;
            }
            default: {
                WarpDrive.logger.error(String.format("Invalid movement type %s in JumpSequence.", this.shipMovementType));
            }
        }
        this.transformation = new Transformation(this.ship, this.targetWorld, this.moveX, this.moveY, this.moveZ, this.rotationSteps);
        LocalProfiler.stop();
    }

    protected void state_adjustJumpVector() {
        CheckMovementResult checkMovementResult;
        LocalProfiler.start("Jump.adjustJumpVector");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Adjusting jump vector...");
        }
        ChunkCoordinates target1 = this.transformation.apply(this.ship.minX, this.ship.minY, this.ship.minZ);
        ChunkCoordinates target2 = this.transformation.apply(this.ship.maxX, this.ship.maxY, this.ship.maxZ);
        AxisAlignedBB aabbSource = AxisAlignedBB.func_72330_a((double)this.ship.minX, (double)this.ship.minY, (double)this.ship.minZ, (double)this.ship.maxX, (double)this.ship.maxY, (double)this.ship.maxZ);
        aabbSource.func_72314_b(1.0, 1.0, 1.0);
        AxisAlignedBB aabbTarget = AxisAlignedBB.func_72330_a((double)Math.min(target1.field_71574_a, target2.field_71574_a), (double)Math.min(target1.field_71572_b, target2.field_71572_b), (double)Math.min(target1.field_71573_c, target2.field_71573_c), (double)Math.max(target1.field_71574_a, target2.field_71574_a), (double)Math.max(target1.field_71572_b, target2.field_71572_b), (double)Math.max(target1.field_71573_c, target2.field_71573_c));
        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE && !this.betweenWorlds && aabbSource.func_72326_a(aabbTarget)) {
            this.doCollisionDamage(false);
            String msg = this.firstAdjustmentReason == null || this.firstAdjustmentReason.isEmpty() ? "Source and target areas are overlapping, jump aborted! Try increasing jump distance..." : this.firstAdjustmentReason + "\nNot enough space after adjustment, jump aborted!";
            this.disable(false, msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        CelestialObject celestialObjectTarget = CelestialObjectManager.get(this.targetWorld, (int)aabbTarget.field_72340_a, (int)aabbTarget.field_72339_c);
        if (celestialObjectTarget == null) {
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.error(String.format("There's no world border defined for dimension %s (%d)", this.targetWorld.field_73011_w.func_80007_l(), this.targetWorld.field_73011_w.field_76574_g));
            }
        } else if (!celestialObjectTarget.isInsideBorder(aabbTarget)) {
            AxisAlignedBB axisAlignedBB = celestialObjectTarget.getWorldBorderArea();
            String message = String.format("Target ship position is outside planet border, unable to jump!\nWorld borders are (%d %d %d) to (%d %d %d).", (int)axisAlignedBB.field_72340_a, (int)axisAlignedBB.field_72338_b, (int)axisAlignedBB.field_72339_c, (int)axisAlignedBB.field_72336_d, (int)axisAlignedBB.field_72337_e, (int)axisAlignedBB.field_72334_f);
            LocalProfiler.stop();
            this.ship.messageToAllPlayersOnShip(message);
            this.disable(false, message);
            return;
        }
        if (!this.isPluginCheckDone && (checkMovementResult = this.checkCollisionAndProtection(this.transformation, true, "target", new VectorI(0, 0, 0))) != null) {
            String msg = checkMovementResult.reason + "\nJump aborted!";
            this.disable(false, msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    protected void state_loadTargetChunks() {
        StringBuilder reason;
        LocalProfiler.start("Jump.loadTargetChunks");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Loading chunks at target...");
        }
        if (!this.forceTargetChunks(reason = new StringBuilder())) {
            String msg = reason.toString();
            this.disable(false, msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    protected void state_saveEntitiesAndInformPlayers() {
        LocalProfiler.start("Jump.saveEntitiesAndInformPlayers");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Saving entities...");
        }
        StringBuilder reason = new StringBuilder();
        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE && !this.ship.saveEntities(reason)) {
            String msg = reason.toString();
            this.disable(false, msg);
            this.ship.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Saved " + this.ship.entitiesOnShip.size() + " entities from ship");
        }
        switch (this.shipMovementType) {
            case HYPERSPACE_ENTERING: {
                this.ship.messageToAllPlayersOnShip("Entering hyperspace...");
                break;
            }
            case HYPERSPACE_EXITING: {
                this.ship.messageToAllPlayersOnShip("Leaving hyperspace..");
                break;
            }
            case GATE_ACTIVATING: {
                this.ship.messageToAllPlayersOnShip(String.format("Engaging jumpgate towards %s!", this.nameTarget));
                break;
            }
            case INSTANTIATE: 
            case RESTORE: {
                break;
            }
            default: {
                this.ship.messageToAllPlayersOnShip(String.format("Jumping of %d blocks (XYZ %d %d %d)", (int)Math.ceil(Math.sqrt(this.moveX * this.moveX + this.moveY * this.moveY + this.moveZ * this.moveZ)), this.moveX, this.moveY, this.moveZ));
            }
        }
        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
            switch (this.rotationSteps) {
                case 1: {
                    this.ship.messageToAllPlayersOnShip("Turning to the right");
                    break;
                }
                case 2: {
                    this.ship.messageToAllPlayersOnShip("Turning back");
                    break;
                }
                case 3: {
                    this.ship.messageToAllPlayersOnShip("Turning to the left");
                    break;
                }
            }
        }
        LocalProfiler.stop();
        if (WarpDrive.isDev && WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("Removing TE duplicates: tileEntities in target world before jump: %d", this.targetWorld.field_147482_g.size()));
        }
    }

    protected boolean computeTargetWorld(CelestialObject celestialObjectSource, EnumShipMovementType shipMovementType, StringBuilder reason) {
        switch (shipMovementType) {
            case INSTANTIATE: 
            case RESTORE: {
                break;
            }
            case HYPERSPACE_EXITING: {
                CelestialObject celestialObject = CelestialObjectManager.getClosestChild(this.sourceWorld, this.ship.coreX, this.ship.coreZ);
                if (celestialObject == null) {
                    reason.append(String.format("Unable to reach space from this location!\nThere's no celestial object defined for current dimension %s (%d).", this.sourceWorld.field_73011_w.func_80007_l(), this.sourceWorld.field_73011_w.field_76574_g));
                    return false;
                }
                double distanceSquared = celestialObject.getSquareDistanceInParent(this.sourceWorld.field_73011_w.field_76574_g, this.ship.coreX, this.ship.coreZ);
                if (distanceSquared > 0.0) {
                    AxisAlignedBB axisAlignedBB = celestialObject.getAreaInParent();
                    reason.append(String.format("Ship is outside any solar system, unable to reach space!\nClosest transition area is ~%d m away (%d %d %d) to (%d %d %d).", (int)Math.sqrt(distanceSquared), (int)axisAlignedBB.field_72340_a, (int)axisAlignedBB.field_72338_b, (int)axisAlignedBB.field_72339_c, (int)axisAlignedBB.field_72336_d, (int)axisAlignedBB.field_72337_e, (int)axisAlignedBB.field_72334_f));
                    return false;
                }
                int dimensionIdSpace = celestialObject.dimensionId;
                this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(dimensionIdSpace);
                if (this.targetWorld == null) {
                    reason.append(String.format("Unable to load Space dimension %d, aborting jump.", dimensionIdSpace));
                    return false;
                }
                VectorI vEntry = celestialObject.getEntryOffset();
                this.moveX = vEntry.x;
                this.moveZ = vEntry.z;
                break;
            }
            case HYPERSPACE_ENTERING: {
                if (celestialObjectSource.parent == null) {
                    reason.append(String.format("Unable to reach hyperspace!\nThere's no parent defined for current dimension %s (%d).", this.sourceWorld.field_73011_w.func_80007_l(), this.sourceWorld.field_73011_w.field_76574_g));
                    return false;
                }
                int dimensionIdHyperspace = celestialObjectSource.parent.dimensionId;
                this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(dimensionIdHyperspace);
                if (this.targetWorld == null) {
                    reason.append(String.format("Unable to load Hyperspace dimension %d, aborting jump.", dimensionIdHyperspace));
                    return false;
                }
                VectorI vEntry = celestialObjectSource.getEntryOffset();
                this.moveX = -vEntry.x;
                this.moveZ = -vEntry.z;
                break;
            }
            case PLANET_TAKEOFF: {
                if (celestialObjectSource.parent == null) {
                    reason.append(String.format("Unable to take off!\nThere's no parent defined for current dimension %s (%d).", this.sourceWorld.field_73011_w.func_80007_l(), this.sourceWorld.field_73011_w.field_76574_g));
                    return false;
                }
                double distanceSquared = celestialObjectSource.getSquareDistanceOutsideBorder(this.ship.coreX, this.ship.coreZ);
                if (distanceSquared > 0.0) {
                    AxisAlignedBB axisAlignedBB = celestialObjectSource.getAreaToReachParent();
                    reason.append(String.format("Ship is outside planet border, unable to reach space!\nClosest transition area is ~%d m away (%d %d %d) to (%d %d %d).", (int)Math.sqrt(distanceSquared), (int)axisAlignedBB.field_72340_a, (int)axisAlignedBB.field_72338_b, (int)axisAlignedBB.field_72339_c, (int)axisAlignedBB.field_72336_d, (int)axisAlignedBB.field_72337_e, (int)axisAlignedBB.field_72334_f));
                    return false;
                }
                int dimensionIdSpace = celestialObjectSource.parent.dimensionId;
                this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(dimensionIdSpace);
                if (this.targetWorld == null) {
                    reason.append(String.format("Unable to load Space dimension %d, aborting jump.", dimensionIdSpace));
                    return false;
                }
                VectorI vEntry = celestialObjectSource.getEntryOffset();
                this.moveX = -vEntry.x;
                this.moveZ = -vEntry.z;
                break;
            }
            case PLANET_LANDING: {
                CelestialObject celestialObject = CelestialObjectManager.getClosestChild(this.sourceWorld, this.ship.coreX, this.ship.coreZ);
                if (celestialObject == null) {
                    reason.append("No planet exists in this dimension, there's nowhere to land!");
                    return false;
                }
                double distanceSquared = celestialObject.getSquareDistanceInParent(this.sourceWorld.field_73011_w.field_76574_g, this.ship.coreX, this.ship.coreZ);
                if (distanceSquared > 0.0) {
                    AxisAlignedBB axisAlignedBB = celestialObject.getAreaInParent();
                    reason.append(String.format("No planet in range, unable to enter atmosphere!\nClosest planet is %d m away (%d %d %d) to (%d %d %d).", (int)Math.sqrt(distanceSquared), (int)axisAlignedBB.field_72340_a, (int)axisAlignedBB.field_72338_b, (int)axisAlignedBB.field_72339_c, (int)axisAlignedBB.field_72336_d, (int)axisAlignedBB.field_72337_e, (int)axisAlignedBB.field_72334_f));
                    return false;
                }
                if (celestialObject.isVirtual()) {
                    reason.append(String.format("Sorry, we can't go to %s. This is a virtual celestial object. It's either a decorative planet or a server misconfiguration", celestialObject.getDisplayName()));
                    return false;
                }
                this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(celestialObject.dimensionId);
                if (this.targetWorld == null) {
                    reason.append(String.format("Sorry, we can't land here. Dimension %d isn't defined. It might be a decorative planet or a server misconfiguration", celestialObject.dimensionId));
                    return false;
                }
                VectorI vEntry = celestialObject.getEntryOffset();
                this.moveX = vEntry.x;
                this.moveZ = vEntry.z;
                break;
            }
            case PLANET_MOVING: 
            case SPACE_MOVING: 
            case HYPERSPACE_MOVING: {
                this.targetWorld = this.sourceWorld;
                break;
            }
            default: {
                reason.append(String.format("Invalid movement type %s", shipMovementType));
                return false;
            }
        }
        return true;
    }

    protected void state_moveBlocks() {
        LocalProfiler.start("Jump.moveBlocks");
        int blocksToMove = Math.min(this.blocksPerTick, this.ship.jumpBlocks.length - this.actualIndexInShip);
        int periodEffect = Math.max(1, blocksToMove / 10);
        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
            WarpDrive.logger.info(this + " Moving ship blocks " + this.actualIndexInShip + " to " + (this.actualIndexInShip + blocksToMove - 1) + " / " + (this.ship.jumpBlocks.length - 1));
        }
        int indexEffect = this.targetWorld.field_73012_v.nextInt(periodEffect);
        for (int index = 0; index < blocksToMove && this.actualIndexInShip < this.ship.jumpBlocks.length; ++index) {
            JumpBlock jumpBlock = this.ship.jumpBlocks[this.actualIndexInShip];
            if (jumpBlock != null) {
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info("Deploying from " + jumpBlock.x + " " + jumpBlock.y + " " + jumpBlock.z + " of " + jumpBlock.block + "@" + jumpBlock.blockMeta);
                }
                if (this.shipMovementType == EnumShipMovementType.INSTANTIATE) {
                    jumpBlock.removeUniqueIDs();
                    jumpBlock.fillEnergyStorage();
                }
                ChunkCoordinates target = jumpBlock.deploy(this.targetWorld, this.transformation);
                if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
                    this.sourceWorld.func_147475_p(jumpBlock.x, jumpBlock.y, jumpBlock.z);
                }
                if (--indexEffect <= 0) {
                    indexEffect = periodEffect;
                    this.doBlockEffect(jumpBlock, target);
                }
            }
            ++this.actualIndexInShip;
        }
        LocalProfiler.stop();
    }

    protected void doBlockEffect(JumpBlock jumpBlock, ChunkCoordinates target) {
        switch (this.shipMovementType) {
            case PLANET_TAKEOFF: 
            case HYPERSPACE_ENTERING: {
                PacketHandler.sendBeamPacket(this.sourceWorld, new Vector3((double)jumpBlock.x + 0.5, (double)jumpBlock.y + 0.5, (double)jumpBlock.z + 0.5), new Vector3((double)target.field_71574_a + 0.5, (double)target.field_71572_b + 32.5 + (double)this.targetWorld.field_73012_v.nextInt(5), (double)target.field_71573_c + 0.5), 0.5f, 0.7f, 0.2f, 30, 0, 100);
                PacketHandler.sendBeamPacket(this.targetWorld, new Vector3((double)target.field_71574_a + 0.5, (double)target.field_71572_b - 31.5 - (double)this.targetWorld.field_73012_v.nextInt(5), (double)target.field_71573_c + 0.5), new Vector3((double)target.field_71574_a + 0.5, (double)target.field_71572_b + 0.5, (double)target.field_71573_c + 0.5), 0.5f, 0.7f, 0.2f, 30, 0, 100);
                break;
            }
            case PLANET_LANDING: 
            case HYPERSPACE_EXITING: {
                PacketHandler.sendBeamPacket(this.sourceWorld, new Vector3((double)jumpBlock.x + 0.5, (double)jumpBlock.y + 0.5, (double)jumpBlock.z + 0.5), new Vector3((double)target.field_71574_a + 0.5, (double)target.field_71572_b - 31.5 - (double)this.targetWorld.field_73012_v.nextInt(5), (double)target.field_71573_c + 0.5), 0.7f, 0.1f, 0.6f, 30, 0, 100);
                PacketHandler.sendBeamPacket(this.targetWorld, new Vector3((double)target.field_71574_a + 0.5, (double)target.field_71572_b + 32.5 + (double)this.targetWorld.field_73012_v.nextInt(5), (double)target.field_71573_c + 0.5), new Vector3((double)target.field_71574_a + 0.5, (double)target.field_71572_b + 0.5, (double)target.field_71573_c + 0.5), 0.7f, 0.1f, 0.6f, 30, 0, 100);
                break;
            }
            case PLANET_MOVING: 
            case SPACE_MOVING: 
            case HYPERSPACE_MOVING: {
                PacketHandler.sendBeamPacket(this.targetWorld, new Vector3((double)jumpBlock.x + 0.5, (double)jumpBlock.y + 0.5, (double)jumpBlock.z + 0.5), new Vector3((double)target.field_71574_a + 0.5, (double)target.field_71572_b + 0.5, (double)target.field_71573_c + 0.5), 0.6f, 0.1f, 0.7f, 30, 0, 100);
                break;
            }
            case GATE_ACTIVATING: {
                break;
            }
            case INSTANTIATE: 
            case RESTORE: {
                if (this.v3Source != null) {
                    this.targetWorld.func_72908_a((double)target.field_71574_a + 0.5, (double)target.field_71572_b + 0.5, (double)target.field_71573_c + 0.5, "warpdrive:lowlaser", 0.5f, 1.0f);
                    PacketHandler.sendBeamPacket(this.targetWorld, this.v3Source, new Vector3((double)target.field_71574_a + 0.5, (double)target.field_71572_b + 0.5, (double)target.field_71573_c + 0.5), 0.0f, 1.0f, 0.0f, 15, 0, 100);
                }
                this.targetWorld.func_72908_a((double)jumpBlock.x + 0.5, (double)jumpBlock.y + 0.5, (double)jumpBlock.z + 0.5, jumpBlock.block.field_149762_H.func_150496_b(), (jumpBlock.block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, jumpBlock.block.field_149762_H.func_150494_d() * 0.8f);
                break;
            }
        }
    }

    protected void state_moveExternals() {
        LocalProfiler.start("Jump.moveExternals");
        int blocksToMove = Math.min(this.blocksPerTick, this.ship.jumpBlocks.length - this.actualIndexInShip);
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Moving ship externals from " + this.actualIndexInShip + " / " + (this.ship.jumpBlocks.length - 1));
        }
        int index = 0;
        while (index < blocksToMove && this.actualIndexInShip < this.ship.jumpBlocks.length) {
            JumpBlock jumpBlock = this.ship.jumpBlocks[this.ship.jumpBlocks.length - this.actualIndexInShip - 1];
            if (jumpBlock == null) {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info(this + " Moving ship externals: unexpected null found at ship[" + this.actualIndexInShip + "]");
                }
                ++this.actualIndexInShip;
                continue;
            }
            if (jumpBlock.externals != null) {
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info("Moving externals for block " + jumpBlock.block + "@" + jumpBlock.blockMeta + " at " + jumpBlock.x + " " + jumpBlock.y + " " + jumpBlock.z);
                }
                TileEntity tileEntitySource = jumpBlock.getTileEntity(this.sourceWorld);
                for (Map.Entry<String, NBTBase> external : jumpBlock.externals.entrySet()) {
                    IBlockTransformer blockTransformer = WarpDriveConfig.blockTransformers.get(external.getKey());
                    if (blockTransformer == null) continue;
                    if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
                        blockTransformer.removeExternals(this.sourceWorld, jumpBlock.x, jumpBlock.y, jumpBlock.z, jumpBlock.block, jumpBlock.blockMeta, tileEntitySource);
                    }
                    ChunkCoordinates target = this.transformation.apply(jumpBlock.x, jumpBlock.y, jumpBlock.z);
                    TileEntity newTileEntity = jumpBlock.weakTileEntity == null ? null : this.targetWorld.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
                    blockTransformer.restoreExternals(this.targetWorld, target.field_71574_a, target.field_71572_b, target.field_71573_c, jumpBlock.block, jumpBlock.blockMeta, newTileEntity, this.transformation, external.getValue());
                }
                ++index;
            }
            ++this.actualIndexInShip;
        }
        LocalProfiler.stop();
    }

    protected void state_moveEntities() {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Moving entities");
        }
        LocalProfiler.start("Jump.moveEntities");
        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
            for (MovingEntity movingEntity : this.ship.entitiesOnShip) {
                EntityPlayerMP player;
                ChunkCoordinates bedLocation;
                Entity entity = movingEntity.getEntity();
                if (entity == null) continue;
                Vec3 target = this.transformation.apply(movingEntity.v3OriginalPosition.x, movingEntity.v3OriginalPosition.y, movingEntity.v3OriginalPosition.z);
                double newEntityX = target.field_72450_a;
                double newEntityY = target.field_72448_b;
                double newEntityZ = target.field_72449_c;
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info(String.format("Entity moving: (%.2f %.2f %.2f) -> (%.2f %.2f %.2f) entity %s", movingEntity.v3OriginalPosition.x, movingEntity.v3OriginalPosition.y, movingEntity.v3OriginalPosition.z, newEntityX, newEntityY, newEntityZ, entity.toString()));
                }
                this.transformation.rotate(entity);
                Commons.moveEntity(entity, this.targetWorld, new Vector3(newEntityX, newEntityY, newEntityZ));
                if (!(entity instanceof EntityPlayerMP) || (bedLocation = (player = (EntityPlayerMP)entity).getBedLocation(this.sourceWorld.field_73011_w.field_76574_g)) == null || this.ship.minX > bedLocation.field_71574_a || this.ship.maxX < bedLocation.field_71574_a || this.ship.minY > bedLocation.field_71572_b || this.ship.maxY < bedLocation.field_71572_b || this.ship.minZ > bedLocation.field_71573_c || this.ship.maxZ < bedLocation.field_71573_c) continue;
                bedLocation = this.transformation.apply(bedLocation);
                player.setSpawnChunk(bedLocation, false, this.targetWorld.field_73011_w.field_76574_g);
            }
        }
        LocalProfiler.stop();
    }

    protected void state_removeBlocks() {
        LocalProfiler.start("Jump.removeBlocks");
        int blocksToMove = Math.min(this.blocksPerTick, this.ship.jumpBlocks.length - this.actualIndexInShip);
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Removing ship blocks " + this.actualIndexInShip + " to " + (this.actualIndexInShip + blocksToMove - 1) + " / " + (this.ship.jumpBlocks.length - 1));
        }
        for (int index = 0; index < blocksToMove && this.actualIndexInShip < this.ship.jumpBlocks.length; ++index) {
            JumpBlock jumpBlock;
            block10: {
                jumpBlock = this.ship.jumpBlocks[this.ship.jumpBlocks.length - this.actualIndexInShip - 1];
                if (jumpBlock == null) {
                    if (WarpDriveConfig.LOGGING_JUMP) {
                        WarpDrive.logger.info(this + " Removing ship part: unexpected null found at ship[" + this.actualIndexInShip + "]");
                    }
                    ++this.actualIndexInShip;
                    continue;
                }
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info("Removing block " + jumpBlock.block + "@" + jumpBlock.blockMeta + " at " + jumpBlock.x + " " + jumpBlock.y + " " + jumpBlock.z);
                }
                if (this.sourceWorld != null) {
                    if (jumpBlock.weakTileEntity != null) {
                        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                            WarpDrive.logger.info("Removing tile entity at " + jumpBlock.x + " " + jumpBlock.y + " " + jumpBlock.z);
                        }
                        this.sourceWorld.func_147475_p(jumpBlock.x, jumpBlock.y, jumpBlock.z);
                    }
                    try {
                        JumpBlock.setBlockNoLight(this.sourceWorld, jumpBlock.x, jumpBlock.y, jumpBlock.z, Blocks.field_150350_a, 0, 2);
                    }
                    catch (Exception exception) {
                        WarpDrive.logger.info("Exception while removing " + jumpBlock.block + "@" + jumpBlock.blockMeta + " at " + jumpBlock.x + " " + jumpBlock.y + " " + jumpBlock.z);
                        if (!WarpDriveConfig.LOGGING_JUMPBLOCKS) break block10;
                        exception.printStackTrace();
                    }
                }
            }
            ChunkCoordinates target = this.transformation.apply(jumpBlock.x, jumpBlock.y, jumpBlock.z);
            JumpBlock.refreshBlockStateOnClient(this.targetWorld, target.field_71574_a, target.field_71572_b, target.field_71573_c);
            ++this.actualIndexInShip;
        }
        LocalProfiler.stop();
    }

    protected void state_chunkReleasing() {
        LocalProfiler.start("Jump.chunkReleasing");
        this.releaseChunks();
        LocalProfiler.stop();
    }

    protected void state_finishing() {
        int countBefore;
        block4: {
            LocalProfiler.start("Jump.finishing()");
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(this + " Jump done in " + (float)(System.currentTimeMillis() - this.msCounter) / 1000.0f + " seconds and " + this.ticks + " ticks");
            }
            countBefore = this.targetWorld.field_147482_g.size();
            try {
                this.targetWorld.field_147482_g = JumpSequencer.removeDuplicates(this.targetWorld.field_147482_g);
            }
            catch (Exception exception) {
                if (!WarpDriveConfig.LOGGING_JUMP) break block4;
                WarpDrive.logger.info("TE Duplicates removing exception: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.doCollisionDamage(true);
        this.disable(true, "Jump done");
        int countAfter = this.targetWorld.field_147482_g.size();
        if (WarpDriveConfig.LOGGING_JUMP && countBefore != countAfter) {
            WarpDrive.logger.info(String.format("Removing TE duplicates: tileEntities in target world after jump, cleanup %d -> %d", countBefore, countAfter));
        }
        LocalProfiler.stop();
    }

    private String getPossibleJumpDistance() {
        int originalRange;
        CheckMovementResult result;
        int testRange;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Calculating possible jump distance...");
        }
        int blowPoints = 0;
        this.collisionDetected = false;
        String firstAdjustmentReason = "";
        for (testRange = originalRange = Math.max(Math.abs(this.moveX), Math.max(Math.abs(this.moveY), Math.abs(this.moveZ))); testRange >= 0 && (result = this.checkMovement((double)testRange / (double)originalRange, false)) != null; --testRange) {
            if (firstAdjustmentReason.isEmpty()) {
                firstAdjustmentReason = result.reason;
            }
            if (!result.isCollision) continue;
            ++blowPoints;
        }
        VectorI finalMovement = this.getMovementVector((double)testRange / (double)originalRange);
        if (originalRange != testRange && WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Jump range adjusted from " + originalRange + " to " + testRange + " after " + blowPoints + " collisions");
        }
        if (blowPoints > WarpDriveConfig.SHIP_COLLISION_TOLERANCE_BLOCKS) {
            result = this.checkMovement(Math.min(1.0, Math.max(0.0, (double)(testRange + 1) / (double)originalRange)), true);
            if (result != null) {
                float massCorrection = 0.5f + (float)Math.sqrt(Math.min(1.0, Math.max(0.0, (double)(this.ship.shipCore.shipMass - WarpDriveConfig.SHIP_VOLUME_MAX_ON_PLANET_SURFACE)) / (double)WarpDriveConfig.SHIP_VOLUME_MIN_FOR_HYPERSPACE));
                this.collisionDetected = true;
                this.collisionStrength = (4.0f + (float)blowPoints - (float)WarpDriveConfig.SHIP_COLLISION_TOLERANCE_BLOCKS) * massCorrection;
                this.collisionAtSource = result.atSource;
                this.collisionAtTarget = result.atTarget;
                WarpDrive.logger.info(this + " Reporting " + this.collisionAtTarget.size() + " collisions points after " + blowPoints + " blowPoints with " + String.format("%.2f", Float.valueOf(massCorrection)) + " ship mass correction => " + String.format("%.2f", Float.valueOf(this.collisionStrength)) + " explosion strength");
            } else {
                WarpDrive.logger.error("WarpDrive error: unable to compute collision points, ignoring...");
            }
        }
        this.moveX = finalMovement.x;
        this.moveY = finalMovement.y;
        this.moveZ = finalMovement.z;
        return firstAdjustmentReason;
    }

    private void doCollisionDamage(boolean atTarget) {
        if (!this.collisionDetected) {
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(this + " doCollisionDamage No collision detected...");
            }
            return;
        }
        ArrayList<Vector3> collisionPoints = atTarget ? this.collisionAtTarget : this.collisionAtSource;
        Vector3 min = collisionPoints.get(0).clone();
        Vector3 max = collisionPoints.get(0).clone();
        for (Vector3 v : collisionPoints) {
            if (min.x > v.x) {
                min.x = v.x;
            } else if (max.x < v.x) {
                max.x = v.x;
            }
            if (min.y > v.y) {
                min.y = v.y;
            } else if (max.y < v.y) {
                max.y = v.y;
            }
            if (min.z > v.z) {
                min.z = v.z;
                continue;
            }
            if (!(max.z < v.z)) continue;
            max.z = v.z;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Ship collision from " + min + " to " + max);
        }
        double rx = Math.round(min.x + (double)this.sourceWorld.field_73012_v.nextInt(Math.max(1, (int)(max.x - min.x))));
        double ry = Math.round(min.y + (double)this.sourceWorld.field_73012_v.nextInt(Math.max(1, (int)(max.y - min.y))));
        double rz = Math.round(min.z + (double)this.sourceWorld.field_73012_v.nextInt(Math.max(1, (int)(max.z - min.z))));
        this.ship.messageToAllPlayersOnShip("Ship collision detected around " + (int)rx + ", " + (int)ry + ", " + (int)rz + ". Damage report pending...");
        int nbExplosions = Math.min(5, collisionPoints.size());
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info("doCollisionDamage nbExplosions " + nbExplosions + "/" + collisionPoints.size());
        }
        for (int i = 0; i < nbExplosions; ++i) {
            Vector3 current;
            if (nbExplosions < collisionPoints.size()) {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info("doCollisionDamage random #" + i);
                }
                current = collisionPoints.get(this.sourceWorld.field_73012_v.nextInt(collisionPoints.size()));
            } else {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info("doCollisionDamage get " + i);
                }
                current = collisionPoints.get(i);
            }
            float strength = Math.max(4.0f, this.collisionStrength / (float)nbExplosions - 2.0f + 2.0f * this.sourceWorld.field_73012_v.nextFloat());
            (atTarget ? this.targetWorld : this.sourceWorld).func_72885_a(null, current.x, current.y, current.z, strength, atTarget, atTarget);
            WarpDrive.logger.info("Ship collision caused explosion at " + current.x + " " + current.y + " " + current.z + " with strength " + strength);
        }
    }

    private void restoreEntitiesPosition() {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Restoring entities position");
        }
        LocalProfiler.start("Jump.restoreEntitiesPosition");
        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
            for (MovingEntity movingEntity : this.ship.entitiesOnShip) {
                Entity entity = movingEntity.getEntity();
                if (entity == null) continue;
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info(String.format("Entity restoring position at (%f %f %f)", movingEntity.v3OriginalPosition.x, movingEntity.v3OriginalPosition.y, movingEntity.v3OriginalPosition.z));
                }
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)entity;
                    player.func_70634_a(movingEntity.v3OriginalPosition.x, movingEntity.v3OriginalPosition.y, movingEntity.v3OriginalPosition.z);
                    continue;
                }
                entity.func_70107_b(movingEntity.v3OriginalPosition.x, movingEntity.v3OriginalPosition.y, movingEntity.v3OriginalPosition.z);
            }
        }
        LocalProfiler.stop();
    }

    private CheckMovementResult checkCollisionAndProtection(ITransformation transformation, boolean fullCollisionDetails, String context, VectorI vMovement) {
        CheckMovementResult result = new CheckMovementResult();
        VectorI offset = new VectorI((int)Math.signum(this.moveX), (int)Math.signum(this.moveY), (int)Math.signum(this.moveZ));
        ChunkCoordinates coordCoreAtTarget = transformation.apply(this.ship.coreX, this.ship.coreY, this.ship.coreZ);
        ChunkCoordinates coordMinAtTarget = transformation.apply(this.ship.minX, this.ship.minY, this.ship.minZ);
        ChunkCoordinates coordMaxAtTarget = transformation.apply(this.ship.maxX, this.ship.maxY, this.ship.maxZ);
        AxisAlignedBB targetAABB = AxisAlignedBB.func_72330_a((double)coordMinAtTarget.field_71574_a, (double)coordMinAtTarget.field_71572_b, (double)coordMinAtTarget.field_71573_c, (double)coordMaxAtTarget.field_71574_a, (double)coordMaxAtTarget.field_71572_b, (double)coordMaxAtTarget.field_71573_c);
        EventWarpDrive.Ship.TargetCheck targetCheck = new EventWarpDrive.Ship.TargetCheck(this.sourceWorld, this.ship.coreX, this.ship.coreY, this.ship.coreZ, this.ship.shipCore.getShipController(), this.shipMovementType.getName(), vMovement.x, vMovement.y, vMovement.z, this.targetWorld, targetAABB);
        MinecraftForge.EVENT_BUS.post((Event)targetCheck);
        if (targetCheck.isCanceled()) {
            result.add(this.ship.coreX, this.ship.coreY, this.ship.coreZ, coordCoreAtTarget.field_71574_a, coordCoreAtTarget.field_71572_b, coordCoreAtTarget.field_71573_c, false, targetCheck.getReason());
            return result;
        }
        for (int y = this.ship.minY; y <= this.ship.maxY; ++y) {
            for (int x = this.ship.minX; x <= this.ship.maxX; ++x) {
                for (int z = this.ship.minZ; z <= this.ship.maxZ; ++z) {
                    ChunkCoordinates coordTarget = transformation.apply(x, y, z);
                    Block blockSource = this.sourceWorld.func_147439_a(x, y, z);
                    Block blockTarget = this.targetWorld.func_147439_a(coordTarget.field_71574_a, coordTarget.field_71572_b, coordTarget.field_71573_c);
                    if (Dictionary.BLOCKS_ANCHOR.contains(blockTarget)) {
                        result.add(x, y, z, (double)coordTarget.field_71574_a + 0.5 - (double)offset.x, (double)coordTarget.field_71572_b + 0.5 - (double)offset.y, (double)coordTarget.field_71573_c + 0.5 - (double)offset.z, true, String.format("Impassable %s detected at destination (%d %d %d)", blockTarget.func_149732_F(), coordTarget.field_71574_a, coordTarget.field_71572_b, coordTarget.field_71573_c));
                        if (!fullCollisionDetails) {
                            return result;
                        }
                        if (WarpDriveConfig.LOGGING_JUMP) {
                            WarpDrive.logger.info("Anchor collision at " + context);
                        }
                    }
                    if (blockSource != Blocks.field_150350_a && !Dictionary.BLOCKS_EXPANDABLE.contains(blockSource) && blockTarget != Blocks.field_150350_a && !Dictionary.BLOCKS_EXPANDABLE.contains(blockTarget)) {
                        result.add(x, y, z, (double)coordTarget.field_71574_a + 0.5 + (double)offset.x * 0.1, (double)coordTarget.field_71572_b + 0.5 + (double)offset.y * 0.1, (double)coordTarget.field_71573_c + 0.5 + (double)offset.z * 0.1, true, String.format("Obstacle %s detected at (%d %d %d)", blockTarget.func_149732_F(), coordTarget.field_71574_a, coordTarget.field_71572_b, coordTarget.field_71573_c));
                        if (!fullCollisionDetails) {
                            return result;
                        }
                        if (WarpDriveConfig.LOGGING_JUMP) {
                            WarpDrive.logger.info("Hard collision at " + context);
                        }
                    }
                    if (blockSource == Blocks.field_150350_a || !WarpDriveConfig.G_ENABLE_PROTECTION_CHECKS || !CommonProxy.isBlockPlaceCanceled(null, coordCoreAtTarget.field_71574_a, coordCoreAtTarget.field_71572_b, coordCoreAtTarget.field_71573_c, this.targetWorld, coordTarget.field_71574_a, coordTarget.field_71572_b, coordTarget.field_71573_c, blockSource, 0)) continue;
                    result.add(x, y, z, coordTarget.field_71574_a, coordTarget.field_71572_b, coordTarget.field_71573_c, false, String.format("Ship is entering a protected area at (%d %d %d)", coordTarget.field_71574_a, coordTarget.field_71572_b, coordTarget.field_71573_c));
                    return result;
                }
            }
        }
        if (fullCollisionDetails && result.isCollision) {
            return result;
        }
        return null;
    }

    private CheckMovementResult checkMovement(double ratio, boolean fullCollisionDetails) {
        CheckMovementResult result = new CheckMovementResult();
        VectorI testMovement = this.getMovementVector(ratio);
        if (this.moveY > 0 && this.ship.maxY + testMovement.y > 255 && !this.betweenWorlds) {
            result.add(this.ship.coreX, this.ship.maxY + testMovement.y, this.ship.coreZ, (double)this.ship.coreX + 0.5, (double)(this.ship.maxY + testMovement.y) + 1.0, (double)this.ship.coreZ + 0.5, false, "Ship core is moving too high");
            return result;
        }
        if (this.moveY < 0 && this.ship.minY + testMovement.y <= 8 && !this.betweenWorlds) {
            result.add(this.ship.coreX, this.ship.minY + testMovement.y, this.ship.coreZ, (double)this.ship.coreX + 0.5, this.ship.maxY + testMovement.y, (double)this.ship.coreZ + 0.5, false, "Ship core is moving too low");
            return result;
        }
        Transformation testTransformation = new Transformation(this.ship, this.targetWorld, testMovement.x, testMovement.y, testMovement.z, this.rotationSteps);
        return this.checkCollisionAndProtection(testTransformation, fullCollisionDetails, String.format("ratio %.3f movement %s", ratio, testMovement), testMovement);
    }

    private VectorI getMovementVector(double ratio) {
        return new VectorI((int)Math.round((double)this.moveX * ratio), (int)Math.round((double)this.moveY * ratio), (int)Math.round((double)this.moveZ * ratio));
    }

    private static ArrayList<Object> removeDuplicates(List<TileEntity> l) {
        TreeSet<TileEntity> s = new TreeSet<TileEntity>(new Comparator<TileEntity>(){

            @Override
            public int compare(TileEntity o1, TileEntity o2) {
                if (o1.field_145851_c == o2.field_145851_c && o1.field_145848_d == o2.field_145848_d && o1.field_145849_e == o2.field_145849_e) {
                    if (WarpDriveConfig.LOGGING_JUMP) {
                        WarpDrive.logger.warn(String.format("Removing TE duplicates: detected duplicate in %s @ %d %d %d: %s vs %s", o1.func_145831_w().field_73011_w.func_80007_l(), o1.field_145851_c, o1.field_145848_d, o1.field_145849_e, o1, o2));
                        NBTTagCompound nbtTagCompound1 = new NBTTagCompound();
                        o1.func_145841_b(nbtTagCompound1);
                        NBTTagCompound nbtTagCompound2 = new NBTTagCompound();
                        o2.func_145841_b(nbtTagCompound2);
                        WarpDrive.logger.warn(String.format("First  NBT is %s", nbtTagCompound1));
                        WarpDrive.logger.warn(String.format("Second NBT is %s", nbtTagCompound2));
                    }
                    return 0;
                }
                return 1;
            }
        });
        s.addAll(l);
        return new ArrayList<Object>(Arrays.asList(s.toArray()));
    }

    @Override
    protected void readFromNBT(NBTTagCompound tagCompound) {
        WarpDrive.logger.error(this + " readFromNBT()");
    }

    @Override
    protected void writeToNBT(NBTTagCompound tagCompound) {
        WarpDrive.logger.error(this + " writeToNBT()");
    }

    public String toString() {
        return String.format("%s/%d '%s' @ %s (%d %d %d) #%d", this.getClass().getSimpleName(), this.hashCode(), this.ship == null || this.ship.shipCore == null ? "~NULL~" : this.ship.shipCore.uuid + ":" + this.ship.shipCore.shipName, this.sourceWorld == null ? "~NULL~" : this.sourceWorld.field_73011_w.func_80007_l(), this.ship == null ? -1 : this.ship.coreX, this.ship == null ? -1 : this.ship.coreY, this.ship == null ? -1 : this.ship.coreZ, this.ticks);
    }

    private class CheckMovementResult {
        final ArrayList<Vector3> atSource = new ArrayList(1);
        final ArrayList<Vector3> atTarget = new ArrayList(1);
        boolean isCollision = false;
        public String reason = "Unknown reason";

        CheckMovementResult() {
        }

        public void add(double sx, double sy, double sz, double tx, double ty, double tz, boolean pisCollision, String preason) {
            this.atSource.add(new Vector3(sx, sy, sz));
            this.atTarget.add(new Vector3(tx, ty, tz));
            this.isCollision = this.isCollision || pisCollision;
            this.reason = preason;
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info("CheckMovementResult " + sx + ", " + sy + ", " + sz + " -> " + tx + ", " + ty + ", " + tz + " " + this.isCollision + " '" + this.reason + "'");
            }
        }
    }
}

