/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IAirContainerItem;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemComponent
extends ItemAbstractBase
implements IAirContainerItem {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private static ItemStack[] itemStackCache;

    public ItemComponent() {
        this.func_77627_a(true);
        this.func_77655_b("warpdrive.component.malformed");
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
        itemStackCache = new ItemStack[EnumComponentType.length];
    }

    public static ItemStack getItemStack(EnumComponentType enumComponentType) {
        if (enumComponentType != null) {
            int damage = enumComponentType.ordinal();
            if (itemStackCache[damage] == null) {
                ItemComponent.itemStackCache[damage] = new ItemStack((Item)WarpDrive.itemComponent, 1, damage);
            }
            return itemStackCache[damage];
        }
        return null;
    }

    public static ItemStack getItemStackNoCache(EnumComponentType enumComponentType, int amount) {
        return new ItemStack((Item)WarpDrive.itemComponent, amount, enumComponentType.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[EnumComponentType.length];
        for (EnumComponentType enumComponentType : EnumComponentType.values()) {
            this.icons[enumComponentType.ordinal()] = iconRegister.func_94245_a("warpdrive:component/" + enumComponentType.getName());
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        int damage = itemStack.func_77960_j();
        if (damage >= 0 && damage < EnumComponentType.length) {
            return "item.warpdrive.component." + EnumComponentType.get(damage).getName();
        }
        return this.func_77658_a();
    }

    public IIcon func_77617_a(int damage) {
        if (damage >= 0 && damage < EnumComponentType.length) {
            return this.icons[damage];
        }
        return this.icons[0];
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (EnumComponentType enumComponentType : EnumComponentType.values()) {
            list.add(new ItemStack(item, 1, enumComponentType.ordinal()));
        }
    }

    @Override
    public boolean canContainAir(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ItemComponent && itemStack.func_77960_j() == EnumComponentType.AIR_CANISTER.ordinal();
    }

    @Override
    public int getMaxAirStorage(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirTanks[0].getMaxAirStorage(itemStack);
        }
        return 0;
    }

    @Override
    public int getCurrentAirStorage(ItemStack itemStack) {
        return 0;
    }

    @Override
    public ItemStack consumeAir(ItemStack itemStack) {
        WarpDrive.logger.error(this + " consumeAir() with itemStack " + itemStack);
        throw new RuntimeException("Invalid call to consumeAir() on non or empty container");
    }

    @Override
    public int getAirTicksPerConsumption(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirTanks[0].getAirTicksPerConsumption(itemStack);
        }
        return 0;
    }

    @Override
    public ItemStack getFullAirContainer(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirTanks[0].getFullAirContainer(itemStack);
        }
        return null;
    }

    @Override
    public ItemStack getEmptyAirContainer(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirTanks[0].getEmptyAirContainer(itemStack);
        }
        return null;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        Block block = world.func_147439_a(x, y, z);
        return block instanceof BlockAbstractContainer || super.doesSneakBypassUse(world, x, y, z, player);
    }
}

