/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.forcefield.BlockForceFieldProjector;
import cr0s.warpdrive.block.forcefield.BlockForceFieldRelay;
import cr0s.warpdrive.data.EnumForceFieldUpgrade;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemForceFieldUpgrade
extends ItemAbstractBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private static ItemStack[] itemStackCache;

    public ItemForceFieldUpgrade() {
        this.func_77627_a(true);
        this.func_77655_b("warpdrive.forcefield.upgrade");
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
        itemStackCache = new ItemStack[EnumForceFieldUpgrade.length];
    }

    public static ItemStack getItemStack(EnumForceFieldUpgrade forceFieldUpgrade) {
        if (forceFieldUpgrade != null) {
            int damage = forceFieldUpgrade.ordinal();
            if (itemStackCache[damage] == null) {
                ItemForceFieldUpgrade.itemStackCache[damage] = new ItemStack((Item)WarpDrive.itemForceFieldUpgrade, 1, damage);
            }
            return itemStackCache[damage];
        }
        return null;
    }

    public static ItemStack getItemStackNoCache(EnumForceFieldUpgrade forceFieldUpgrade, int amount) {
        return new ItemStack((Item)WarpDrive.itemForceFieldUpgrade, amount, forceFieldUpgrade.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[EnumForceFieldUpgrade.length];
        for (EnumForceFieldUpgrade enumForceFieldUpgrade : EnumForceFieldUpgrade.values()) {
            this.icons[enumForceFieldUpgrade.ordinal()] = iconRegister.func_94245_a("warpdrive:forcefield/upgrade-" + enumForceFieldUpgrade.getName());
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        int damage = itemStack.func_77960_j();
        if (damage >= 0 && damage < EnumForceFieldUpgrade.length) {
            return this.func_77658_a() + "." + EnumForceFieldUpgrade.get(damage).getName();
        }
        return this.func_77658_a();
    }

    public IIcon func_77617_a(int damage) {
        if (damage >= 0 && damage < EnumForceFieldUpgrade.length) {
            return this.icons[damage];
        }
        return this.icons[0];
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (EnumForceFieldUpgrade enumForceFieldUpgrade : EnumForceFieldUpgrade.values()) {
            if (enumForceFieldUpgrade == EnumForceFieldUpgrade.NONE) continue;
            list.add(new ItemStack(item, 1, enumForceFieldUpgrade.ordinal()));
        }
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        Block block = world.func_147439_a(x, y, z);
        return block instanceof BlockForceFieldRelay || block instanceof BlockForceFieldProjector || super.doesSneakBypassUse(world, x, y, z, player);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean advancedItemTooltips) {
        super.func_77624_a(itemStack, entityPlayer, list, advancedItemTooltips);
        Commons.addTooltip(list, "\n");
        EnumForceFieldUpgrade forceFieldUpgrade = EnumForceFieldUpgrade.get(itemStack.func_77960_j());
        if (forceFieldUpgrade.maxCountOnProjector > 0) {
            Commons.addTooltip(list, StatCollector.func_74837_a((String)"item.warpdrive.forcefield.upgrade.tooltip.usage.projector", (Object[])new Object[0]));
        }
        if (forceFieldUpgrade.maxCountOnRelay > 0) {
            Commons.addTooltip(list, StatCollector.func_74837_a((String)"item.warpdrive.forcefield.upgrade.tooltip.usage.relay", (Object[])new Object[0]));
        }
        Commons.addTooltip(list, StatCollector.func_74837_a((String)"item.warpdrive.forcefield.upgrade.tooltip.usage.dismount", (Object[])new Object[0]));
    }
}

