/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.api.IControlChannel;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.api.IWarpTool;
import cr0s.warpdrive.block.energy.BlockEnergyBank;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemTuningDriver
extends ItemAbstractBase
implements IWarpTool {
    public static final int MODE_VIDEO_CHANNEL = 0;
    public static final int MODE_BEAM_FREQUENCY = 1;
    public static final int MODE_CONTROL_CHANNEL = 2;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemTuningDriver() {
        this.func_77656_e(0);
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
        this.func_77625_d(1);
        this.func_77655_b("warpdrive.tool.tuning_driver");
        this.func_77664_n();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[3];
        this.icons[0] = iconRegister.func_94245_a("warpdrive:tool/tuning_driver-cyan");
        this.icons[1] = iconRegister.func_94245_a("warpdrive:tool/tuning_driver-purple");
        this.icons[2] = iconRegister.func_94245_a("warpdrive:tool/tuning_driver-yellow");
    }

    public IIcon func_77617_a(int damage) {
        if (damage < this.icons.length) {
            return this.icons[damage];
        }
        return Blocks.field_150480_ab.func_149840_c(0);
    }

    public String func_77667_c(ItemStack itemStack) {
        int damage = itemStack.func_77960_j();
        switch (damage) {
            case 0: {
                return this.func_77658_a() + ".video_channel";
            }
            case 1: {
                return this.func_77658_a() + ".beam_frequency";
            }
            case 2: {
                return this.func_77658_a() + ".control_channel";
            }
        }
        return this.func_77658_a();
    }

    public static int getVideoChannel(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver)) {
            return -1;
        }
        if (!itemStack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound.func_74764_b("videoChannel")) {
            return tagCompound.func_74762_e("videoChannel");
        }
        return -1;
    }

    public static ItemStack setVideoChannel(ItemStack itemStack, int videoChannel) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver) || videoChannel == -1) {
            return itemStack;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a("videoChannel", videoChannel);
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    public static int getBeamFrequency(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver)) {
            return -1;
        }
        if (!itemStack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound.func_74764_b("beamFrequency")) {
            return tagCompound.func_74762_e("beamFrequency");
        }
        return -1;
    }

    public static ItemStack setBeamFrequency(ItemStack itemStack, int beamFrequency) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver) || beamFrequency == -1) {
            return itemStack;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a("beamFrequency", beamFrequency);
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    public static int getControlChannel(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver)) {
            return -1;
        }
        if (!itemStack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound.func_74764_b("controlChannel")) {
            return tagCompound.func_74762_e("controlChannel");
        }
        return -1;
    }

    public static ItemStack setControlChannel(ItemStack itemStack, int controlChannel) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver) || controlChannel == -1) {
            return itemStack;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a("controlChannel", controlChannel);
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    public static ItemStack setValue(ItemStack itemStack, int dye) {
        switch (itemStack.func_77960_j()) {
            case 0: {
                return ItemTuningDriver.setVideoChannel(itemStack, dye);
            }
            case 1: {
                return ItemTuningDriver.setBeamFrequency(itemStack, dye);
            }
            case 2: {
                return ItemTuningDriver.setControlChannel(itemStack, dye);
            }
        }
        return itemStack;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (world.field_72995_K || !(itemStack.func_77973_b() instanceof ItemTuningDriver)) {
            return itemStack;
        }
        MovingObjectPosition movingObjectPosition = Commons.getInteractingBlock(world, entityPlayer);
        if (movingObjectPosition.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) {
            return itemStack;
        }
        if (entityPlayer.func_70093_af() && entityPlayer.field_71075_bZ.field_75098_d) {
            switch (itemStack.func_77960_j()) {
                case 0: {
                    ItemTuningDriver.setVideoChannel(itemStack, world.field_73012_v.nextInt(0xFFFFFFF));
                    Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.video_channel.get", (Object[])new Object[]{entityPlayer.func_70005_c_(), ItemTuningDriver.getVideoChannel(itemStack)}));
                    return itemStack;
                }
                case 1: {
                    ItemTuningDriver.setBeamFrequency(itemStack, world.field_73012_v.nextInt(65000));
                    Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.beam_frequency.get", (Object[])new Object[]{entityPlayer.func_70005_c_(), ItemTuningDriver.getBeamFrequency(itemStack)}));
                    return itemStack;
                }
                case 2: {
                    ItemTuningDriver.setControlChannel(itemStack, world.field_73012_v.nextInt(0xFFFFFFF));
                    Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.control_channel.get", (Object[])new Object[]{entityPlayer.func_70005_c_(), ItemTuningDriver.getControlChannel(itemStack)}));
                    return itemStack;
                }
            }
            return itemStack;
        }
        switch (itemStack.func_77960_j()) {
            case 0: {
                itemStack.func_77964_b(1);
                entityPlayer.func_70062_b(0, itemStack);
                break;
            }
            case 1: {
                itemStack.func_77964_b(2);
                entityPlayer.func_70062_b(0, itemStack);
                break;
            }
            case 2: {
                itemStack.func_77964_b(0);
                entityPlayer.func_70062_b(0, itemStack);
                break;
            }
            default: {
                itemStack.func_77964_b(0);
            }
        }
        world.func_72956_a((Entity)entityPlayer, "WarpDrive:ding", 0.1f, 1.0f);
        return itemStack;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return false;
        }
        switch (itemStack.func_77960_j()) {
            case 0: {
                if (tileEntity instanceof IVideoChannel) {
                    if (entityPlayer.func_70093_af()) {
                        ItemTuningDriver.setVideoChannel(itemStack, ((IVideoChannel)tileEntity).getVideoChannel());
                        Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.video_channel.get", (Object[])new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getVideoChannel(itemStack)}));
                    } else {
                        ((IVideoChannel)tileEntity).setVideoChannel(ItemTuningDriver.getVideoChannel(itemStack));
                        Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.video_channel.set", (Object[])new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getVideoChannel(itemStack)}));
                    }
                    return true;
                }
                return false;
            }
            case 1: {
                if (tileEntity instanceof IBeamFrequency) {
                    if (entityPlayer.func_70093_af()) {
                        ItemTuningDriver.setBeamFrequency(itemStack, ((IBeamFrequency)tileEntity).getBeamFrequency());
                        Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.beam_frequency.get", (Object[])new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getBeamFrequency(itemStack)}));
                    } else {
                        ((IBeamFrequency)tileEntity).setBeamFrequency(ItemTuningDriver.getBeamFrequency(itemStack));
                        Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.beam_frequency.set", (Object[])new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getBeamFrequency(itemStack)}));
                    }
                    return true;
                }
                return false;
            }
            case 2: {
                if (tileEntity instanceof IControlChannel) {
                    if (entityPlayer.func_70093_af()) {
                        ItemTuningDriver.setControlChannel(itemStack, ((IControlChannel)tileEntity).getControlChannel());
                        Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.control_channel.get", (Object[])new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getControlChannel(itemStack)}));
                    } else {
                        ((IControlChannel)tileEntity).setControlChannel(ItemTuningDriver.getControlChannel(itemStack));
                        Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.control_channel.set", (Object[])new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getControlChannel(itemStack)}));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        Block block = world.func_147439_a(x, y, z);
        return block instanceof BlockEnergyBank || super.doesSneakBypassUse(world, x, y, z, entityPlayer);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean advancedItemTooltips) {
        String tooltip;
        super.func_77624_a(itemStack, entityPlayer, list, advancedItemTooltips);
        switch (itemStack.func_77960_j()) {
            case 0: {
                tooltip = StatCollector.func_74837_a((String)"warpdrive.video_channel.tooltip", (Object[])new Object[]{ItemTuningDriver.getVideoChannel(itemStack)});
                break;
            }
            case 1: {
                tooltip = StatCollector.func_74837_a((String)"warpdrive.beam_frequency.tooltip", (Object[])new Object[]{ItemTuningDriver.getBeamFrequency(itemStack)});
                break;
            }
            case 2: {
                tooltip = StatCollector.func_74837_a((String)"warpdrive.control_channel.tooltip", (Object[])new Object[]{ItemTuningDriver.getControlChannel(itemStack)});
                break;
            }
            default: {
                tooltip = "I'm broken :(";
            }
        }
        tooltip = tooltip + "\n" + StatCollector.func_74838_a((String)"item.warpdrive.tool.tuning_driver.tooltip.usage");
        Commons.addTooltip(list, tooltip);
    }
}

