/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.render.EntityFXBeam;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;

public class MessageBeamEffect
implements IMessage,
IMessageHandler<MessageBeamEffect, IMessage> {
    private Vector3 source;
    private Vector3 target;
    private float red;
    private float green;
    private float blue;
    private int age;

    public MessageBeamEffect() {
    }

    public MessageBeamEffect(Vector3 source, Vector3 target, float red, float green, float blue, int age) {
        this.source = source;
        this.target = target;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.age = age;
    }

    public MessageBeamEffect(double sourceX, double sourceY, double sourceZ, double targetX, double targetY, double targetZ, float red, float green, float blue, int age, int energy) {
        this.source = new Vector3(sourceX, sourceY, sourceZ);
        this.target = new Vector3(targetX, targetY, targetZ);
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.age = age;
    }

    public void fromBytes(ByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.source = new Vector3(x, y, z);
        x = buffer.readDouble();
        y = buffer.readDouble();
        z = buffer.readDouble();
        this.target = new Vector3(x, y, z);
        this.red = buffer.readFloat();
        this.green = buffer.readFloat();
        this.blue = buffer.readFloat();
        this.age = buffer.readShort();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeDouble(this.source.x);
        buffer.writeDouble(this.source.y);
        buffer.writeDouble(this.source.z);
        buffer.writeDouble(this.target.x);
        buffer.writeDouble(this.target.y);
        buffer.writeDouble(this.target.z);
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeShort(Math.min(Short.MAX_VALUE, this.age));
    }

    @SideOnly(value=Side.CLIENT)
    private void handle(World world) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityFXBeam(world, this.source.clone(), this.target.clone(), this.red, this.green, this.blue, this.age));
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageBeamEffect beamEffectMessage, MessageContext context) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            WarpDrive.logger.error("WorldObj is null, ignoring beam packet");
            return null;
        }
        if (WarpDriveConfig.LOGGING_EFFECTS) {
            WarpDrive.logger.info("Received beam packet from " + beamEffectMessage.source + " to " + beamEffectMessage.target + " as RGB " + beamEffectMessage.red + " " + beamEffectMessage.green + " " + beamEffectMessage.blue + " age " + beamEffectMessage.age);
        }
        beamEffectMessage.handle((World)Minecraft.func_71410_x().field_71441_e);
        return null;
    }
}

