/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.network.MessageClientValidation;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class MessageClientSync
implements IMessage,
IMessageHandler<MessageClientSync, IMessage> {
    private NBTTagCompound tagCompound;

    public MessageClientSync() {
    }

    public MessageClientSync(EntityPlayerMP entityPlayerMP, CelestialObject celestialObject) {
        this.tagCompound = new NBTTagCompound();
        this.tagCompound.func_74782_a("celestialObjects", CelestialObjectManager.writeClientSync(entityPlayerMP, celestialObject));
        this.tagCompound.func_74782_a("items_breathingHelmet", Dictionary.writeItemsToNBT(Dictionary.ITEMS_BREATHING_HELMET));
        this.tagCompound.func_74782_a("items_flyInSpace", Dictionary.writeItemsToNBT(Dictionary.ITEMS_FLYINSPACE));
        this.tagCompound.func_74782_a("items_noFallDamage", Dictionary.writeItemsToNBT(Dictionary.ITEMS_NOFALLDAMAGE));
    }

    public void fromBytes(ByteBuf buffer) {
        this.tagCompound = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.tagCompound);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageClientSync messageClientSync, MessageContext context) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            WarpDrive.logger.error("WorldObj is null, ignoring client synchronization packet");
            return null;
        }
        if (WarpDriveConfig.LOGGING_CLIENT_SYNCHRONIZATION) {
            WarpDrive.logger.info(String.format("Received client synchronization packet: %s", messageClientSync.tagCompound));
        }
        try {
            CelestialObjectManager.readClientSync(messageClientSync.tagCompound.func_150295_c("celestialObjects", 10));
            Dictionary.ITEMS_BREATHING_HELMET = Dictionary.readItemsFromNBT(messageClientSync.tagCompound.func_150295_c("items_breathingHelmet", 8));
            Dictionary.ITEMS_FLYINSPACE = Dictionary.readItemsFromNBT(messageClientSync.tagCompound.func_150295_c("items_flyInSpace", 8));
            Dictionary.ITEMS_NOFALLDAMAGE = Dictionary.readItemsFromNBT(messageClientSync.tagCompound.func_150295_c("items_noFallDamage", 8));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WarpDrive.logger.error(String.format("Fails to parse client synchronization packet %s", messageClientSync.tagCompound));
        }
        return new MessageClientValidation();
    }
}

