/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.movement.TileEntityTransporterCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EntityFXRegistry;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.render.AbstractEntityFX;
import cr0s.warpdrive.render.EntityFXDot;
import cr0s.warpdrive.render.EntityFXEnergizing;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MessageTransporterEffect
implements IMessage,
IMessageHandler<MessageTransporterEffect, IMessage> {
    private boolean isTransporterRoom;
    private GlobalPosition globalPosition;
    private ArrayList<Integer> idEntities;
    private ArrayList<Vector3> v3EntityPositions;
    private double lockStrength;
    private int tickEnergizing;
    private int tickCooldown;

    public MessageTransporterEffect() {
    }

    public MessageTransporterEffect(boolean isTransporterRoom, GlobalPosition globalPosition, Collection<MovingEntity> movingEntities, double lockStrength, int tickEnergizing, int tickCooldown) {
        this.isTransporterRoom = isTransporterRoom;
        this.globalPosition = globalPosition;
        if (movingEntities == null || movingEntities.isEmpty()) {
            this.idEntities = null;
            this.v3EntityPositions = null;
        } else {
            this.idEntities = new ArrayList(movingEntities.size());
            this.v3EntityPositions = new ArrayList(movingEntities.size());
            for (MovingEntity movingEntity : movingEntities) {
                Entity entity;
                if (movingEntity == MovingEntity.INVALID || (entity = movingEntity.getEntity()) == null) continue;
                this.idEntities.add(entity.func_145782_y());
                this.v3EntityPositions.add(movingEntity.v3OriginalPosition);
            }
        }
        this.lockStrength = lockStrength;
        this.tickEnergizing = tickEnergizing;
        this.tickCooldown = tickCooldown;
    }

    public void fromBytes(ByteBuf buffer) {
        this.isTransporterRoom = buffer.readBoolean();
        short dimensionId = buffer.readShort();
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        this.globalPosition = new GlobalPosition(dimensionId, x, y, z);
        int countEntities = buffer.readByte();
        this.idEntities = new ArrayList(countEntities);
        this.v3EntityPositions = new ArrayList(countEntities);
        for (int indexEntity = 0; indexEntity < countEntities; ++indexEntity) {
            int idEntity = buffer.readInt();
            this.idEntities.add(idEntity);
            double xEntity = buffer.readDouble();
            double yEntity = buffer.readDouble();
            double zEntity = buffer.readDouble();
            this.v3EntityPositions.add(new Vector3(xEntity, yEntity, zEntity));
        }
        this.lockStrength = buffer.readFloat();
        this.tickEnergizing = buffer.readShort();
        this.tickCooldown = buffer.readShort();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.isTransporterRoom);
        buffer.writeShort(this.globalPosition.dimensionId);
        buffer.writeInt(this.globalPosition.x);
        buffer.writeInt(this.globalPosition.y);
        buffer.writeInt(this.globalPosition.z);
        int countEntities = this.idEntities == null ? 0 : this.idEntities.size();
        buffer.writeByte(countEntities);
        for (int indexEntity = 0; indexEntity < countEntities; ++indexEntity) {
            buffer.writeInt(this.idEntities.get(indexEntity).intValue());
            Vector3 v3EntityPosition = this.v3EntityPositions.get(indexEntity);
            buffer.writeDouble(v3EntityPosition.x);
            buffer.writeDouble(v3EntityPosition.y);
            buffer.writeDouble(v3EntityPosition.z);
        }
        buffer.writeFloat((float)this.lockStrength);
        buffer.writeShort(this.tickEnergizing);
        buffer.writeShort(this.tickCooldown);
    }

    @SideOnly(value=Side.CLIENT)
    private void handle(World world) {
        int maxRenderDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16;
        int maxRenderDistance_squared = maxRenderDistance * maxRenderDistance;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (this.globalPosition.distance2To((Entity)player) > (double)maxRenderDistance_squared) {
            return;
        }
        if (!this.isTransporterRoom) {
            this.spawnParticlesInArea(world, this.globalPosition.getVectorI(), false, 0.4f, 0.7f, 0.9f, 0.1f, 0.15f, 0.1f);
        } else {
            this.spawnParticlesInTransporterRoom(world, this.globalPosition.getVectorI(), false, 0.4f, 0.7f, 0.9f, 0.1f, 0.15f, 0.1f);
        }
        for (int indexEntity = 0; indexEntity < this.idEntities.size(); ++indexEntity) {
            AbstractEntityFX effect;
            Entity entity = world.func_73045_a(this.idEntities.get(indexEntity).intValue());
            if (entity == null) continue;
            Vector3 v3Position = this.v3EntityPositions.get(indexEntity).clone();
            if (entity instanceof EntityPlayer && entity == Minecraft.func_71410_x().field_71439_g) {
                v3Position.translate(ForgeDirection.DOWN, entity.func_70047_e());
            }
            if ((effect = EntityFXRegistry.get(world, v3Position, 0.5)) == null) {
                Vector3 v3Target = v3Position.clone().translate(ForgeDirection.UP, entity.field_70131_O + 0.5f);
                effect = new EntityFXEnergizing(world, v3Position, v3Target, 0.35f + 0.05f * world.field_73012_v.nextFloat(), 0.5f + 0.15f * world.field_73012_v.nextFloat(), 0.85f + 0.1f * world.field_73012_v.nextFloat(), 20, entity.field_70130_N);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)effect);
                EntityFXRegistry.add(effect);
                continue;
            }
            effect.refresh();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticlesInArea(World world, VectorI vCenter, boolean isFalling, float redBase, float greenBase, float blueBase, float redFactor, float greenFactor, float blueFactor) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(vCenter.x - WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS), (double)((double)vCenter.y - 1.0), (double)(vCenter.z - WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS), (double)((double)(vCenter.x + WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS) + 1.0), (double)((double)vCenter.y + 2.0), (double)((double)(vCenter.z + WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS) + 1.0));
        Vector3 v3Motion = new Vector3(0.0, 0.0, 0.0);
        Vector3 v3Acceleration = new Vector3(0.0, isFalling ? -0.001 : 0.001, 0.0);
        double yRange = aabb.field_72337_e - aabb.field_72338_b;
        int quantityInArea = (int)Commons.clamp(1L, 5L, Math.round(Commons.interpolate(0.2, 1.0, 0.8, 5.0, this.lockStrength)));
        for (int count = 0; count < quantityInArea; ++count) {
            VectorI vPosition;
            Block block;
            double y = isFalling ? aabb.field_72337_e - Math.pow(world.field_73012_v.nextDouble(), 3.0) * yRange : aabb.field_72338_b + Math.pow(world.field_73012_v.nextDouble(), 3.0) * yRange;
            Vector3 v3Position = new Vector3(aabb.field_72340_a + world.field_73012_v.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a), y, aabb.field_72339_c + world.field_73012_v.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c));
            if ((isFalling && MathHelper.func_76128_c((double)y) == MathHelper.func_76128_c((double)aabb.field_72337_e) || !isFalling && MathHelper.func_76128_c((double)y) == MathHelper.func_76128_c((double)aabb.field_72338_b)) && !(block = (vPosition = new VectorI(MathHelper.func_76128_c((double)v3Position.x), MathHelper.func_76128_c((double)v3Position.y), MathHelper.func_76128_c((double)v3Position.z))).getBlock((IBlockAccess)world)).isAir((IBlockAccess)world, vPosition.x, vPosition.y, vPosition.z) && block.func_149662_c()) {
                v3Position.y = y += isFalling ? -1.0 : 1.0;
            }
            EntityFXDot effect = new EntityFXDot(world, v3Position, v3Motion, v3Acceleration, 0.98, 30);
            effect.func_70538_b(redBase + redFactor * world.field_73012_v.nextFloat(), greenBase + greenFactor * world.field_73012_v.nextFloat(), blueBase + blueFactor * world.field_73012_v.nextFloat());
            effect.func_82338_g(1.0f);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)effect);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticlesInTransporterRoom(World world, VectorI vTransporter, boolean isFalling, float redBase, float greenBase, float blueBase, float redFactor, float greenFactor, float blueFactor) {
        TileEntity tileEntity = vTransporter.getTileEntity((IBlockAccess)world);
        if (!(tileEntity instanceof TileEntityTransporterCore)) {
            WarpDrive.logger.error(String.format("Missing transporter core at %s: %s", vTransporter, tileEntity));
            return;
        }
        Vector3 v3Motion = new Vector3(0.0, 0.0, 0.0);
        Vector3 v3Acceleration = new Vector3(0.0, isFalling ? -0.001 : 0.001, 0.0);
        double yRange = 2.5;
        Collection<VectorI> vContainments = ((TileEntityTransporterCore)tileEntity).getContainments();
        if (vContainments == null) {
            WarpDrive.logger.error(String.format("No containments blocks identified for transporter core at %s", vTransporter));
            return;
        }
        for (VectorI vContainment : vContainments) {
            if (world.field_73012_v.nextFloat() < 0.85f) continue;
            double y = isFalling ? (double)vContainment.y + 0.5 - Math.pow(world.field_73012_v.nextDouble(), 3.0) * 2.5 : (double)vContainment.y + 0.5 + Math.pow(world.field_73012_v.nextDouble(), 3.0) * 2.5;
            Vector3 v3Position = new Vector3((double)vContainment.x + world.field_73012_v.nextDouble(), y, (double)vContainment.z + world.field_73012_v.nextDouble());
            EntityFXDot effect = new EntityFXDot(world, v3Position, v3Motion, v3Acceleration, 0.98, 30);
            effect.func_70538_b(redBase + redFactor * world.field_73012_v.nextFloat(), greenBase + greenFactor * world.field_73012_v.nextFloat(), blueBase + blueFactor * world.field_73012_v.nextFloat());
            effect.func_82338_g(1.0f);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)effect);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageTransporterEffect messageTransporterEffect, MessageContext context) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            WarpDrive.logger.error("WorldObj is null, ignoring particle packet");
            return null;
        }
        if (WarpDriveConfig.LOGGING_EFFECTS) {
            WarpDrive.logger.info("Received transporter effect isTransporterRoom %s at %s towards %d entities, with %.3f lockStrength, energizing in %d ticks, cooldown for %d ticks", new Object[]{messageTransporterEffect.isTransporterRoom, messageTransporterEffect.globalPosition, messageTransporterEffect.idEntities.size(), messageTransporterEffect.lockStrength, messageTransporterEffect.tickEnergizing, messageTransporterEffect.tickCooldown});
        }
        messageTransporterEffect.handle((World)Minecraft.func_71410_x().field_71441_e);
        return null;
    }
}

