/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.render.AbstractEntityFX;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class EntityFXEnergizing
extends AbstractEntityFX {
    private static final ResourceLocation TEXTURE = new ResourceLocation("warpdrive", "textures/particle/energy_grey.png");
    private double radius;
    private double length;
    private final int countSteps;
    private float rotYaw;
    private float rotPitch;
    private float prevYaw;
    private float prevPitch;

    public EntityFXEnergizing(World world, Vector3 position, Vector3 target, float red, float green, float blue, int age, float radius) {
        super(world, position.x, position.y, position.z, 0.0, 0.0, 0.0);
        this.func_70538_b(red, green, blue);
        this.func_70105_a(0.02f, 0.02f);
        this.field_70145_X = true;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.radius = radius;
        float xd = (float)(this.field_70165_t - target.x);
        float yd = (float)(this.field_70163_u - target.y);
        float zd = (float)(this.field_70161_v - target.z);
        this.length = new Vector3((Entity)this).distanceTo(target);
        double lengthXZ = MathHelper.func_76133_a((double)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, lengthXZ) * 180.0 / Math.PI);
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        this.field_70547_e = age;
        EntityLivingBase entityRender = Minecraft.func_71410_x().field_71451_h;
        int visibleDistance = 300;
        if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            visibleDistance = 100;
            this.countSteps = 1;
        } else {
            this.countSteps = 6;
        }
        if (entityRender.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) > (double)visibleDistance) {
            this.field_70547_e = 0;
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
    }

    public void func_70539_a(Tessellator tessellator, float partialTick, float cosYaw, float cosPitch, float sinYaw, float sinSinPitch, float cosSinPitch) {
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        double factorFadeIn = Math.min(((float)this.field_70546_d + partialTick) / 20.0f, 1.0f);
        float alpha = 0.5f;
        if (this.field_70547_e - this.field_70546_d <= 4) {
            alpha = 0.5f - (float)(4 - (this.field_70547_e - this.field_70546_d)) * 0.1f;
        } else {
            double timeAlpha = (double)((float)(((this.getSeed() ^ 0x47C8) & 0xFFFF) + this.field_70546_d) + partialTick) + 0.0167;
            alpha = (float)((double)alpha + Math.pow(Math.sin(timeAlpha * 0.37) + Math.sin(0.178 + timeAlpha * 0.17), 2.0) * 0.05);
        }
        double timeTexture = (float)((this.getSeed() & 0xFFFF) + this.field_70546_d) + partialTick;
        double uOffset = (double)((int)Math.floor(timeTexture * 0.5) % 16) / 16.0;
        double vOffset = Math.pow(Math.sin(timeTexture * 0.2), 2.0) * 0.005;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        float xx = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTick - field_70556_an);
        float yy = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTick - field_70554_ao);
        float zz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTick - field_70555_ap);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        float rotYaw = this.prevYaw + (this.rotYaw - this.prevYaw) * partialTick;
        float rotPitch = this.prevPitch + (this.rotPitch - this.prevPitch) * partialTick;
        float rotSpin = 0.0f;
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(180.0f + rotYaw), (float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)rotPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        double radius = this.radius * factorFadeIn;
        double yMin = this.length * (0.5 - factorFadeIn / 2.0);
        double yMax = this.length * (0.5 + factorFadeIn / 2.0);
        double uMin = uOffset;
        double uMax = uMin + 0.03125;
        double vMin = -1.0 + vOffset;
        double vMax = vMin + this.length * factorFadeIn;
        tessellator.func_78382_b();
        tessellator.func_78380_c(200);
        tessellator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha);
        double angleMax = 0.7853981633974483;
        double angleStep = 0.7853981633974483 / (double)this.countSteps;
        double angle = 0.0;
        double cosPrev = radius * Math.cos(angle);
        double sinPrev = radius * Math.sin(angle);
        for (int indexStep = 1; indexStep <= this.countSteps; ++indexStep) {
            double cosNext = radius * Math.cos(angle += angleStep);
            double sinNext = radius * Math.sin(angle);
            tessellator.func_78374_a(cosPrev, yMax, sinPrev, uMax, vMax);
            tessellator.func_78374_a(cosPrev, yMin, sinPrev, uMax, vMin);
            tessellator.func_78374_a(cosNext, yMin, sinNext, uMin, vMin);
            tessellator.func_78374_a(cosNext, yMax, sinNext, uMin, vMax);
            tessellator.func_78374_a(-cosPrev, yMax, sinPrev, uMax, vMax);
            tessellator.func_78374_a(-cosPrev, yMin, sinPrev, uMax, vMin);
            tessellator.func_78374_a(-cosNext, yMin, sinNext, uMin, vMin);
            tessellator.func_78374_a(-cosNext, yMax, sinNext, uMin, vMax);
            tessellator.func_78374_a(cosPrev, yMax, -sinPrev, uMax, vMax);
            tessellator.func_78374_a(cosPrev, yMin, -sinPrev, uMax, vMin);
            tessellator.func_78374_a(cosNext, yMin, -sinNext, uMin, vMin);
            tessellator.func_78374_a(cosNext, yMax, -sinNext, uMin, vMax);
            tessellator.func_78374_a(-cosPrev, yMax, -sinPrev, uMax, vMax);
            tessellator.func_78374_a(-cosPrev, yMin, -sinPrev, uMax, vMin);
            tessellator.func_78374_a(-cosNext, yMin, -sinNext, uMin, vMin);
            tessellator.func_78374_a(-cosNext, yMax, -sinNext, uMin, vMax);
            tessellator.func_78374_a(sinPrev, yMax, cosPrev, uMax, vMax);
            tessellator.func_78374_a(sinPrev, yMin, cosPrev, uMax, vMin);
            tessellator.func_78374_a(sinNext, yMin, cosNext, uMin, vMin);
            tessellator.func_78374_a(sinNext, yMax, cosNext, uMin, vMax);
            tessellator.func_78374_a(-sinPrev, yMax, cosPrev, uMax, vMax);
            tessellator.func_78374_a(-sinPrev, yMin, cosPrev, uMax, vMin);
            tessellator.func_78374_a(-sinNext, yMin, cosNext, uMin, vMin);
            tessellator.func_78374_a(-sinNext, yMax, cosNext, uMin, vMax);
            tessellator.func_78374_a(sinPrev, yMax, -cosPrev, uMax, vMax);
            tessellator.func_78374_a(sinPrev, yMin, -cosPrev, uMax, vMin);
            tessellator.func_78374_a(sinNext, yMin, -cosNext, uMin, vMin);
            tessellator.func_78374_a(sinNext, yMax, -cosNext, uMin, vMax);
            tessellator.func_78374_a(-sinPrev, yMax, -cosPrev, uMax, vMax);
            tessellator.func_78374_a(-sinPrev, yMin, -cosPrev, uMax, vMin);
            tessellator.func_78374_a(-sinNext, yMin, -cosNext, uMin, vMin);
            tessellator.func_78374_a(-sinNext, yMax, -cosNext, uMin, vMax);
            cosPrev = cosNext;
            sinPrev = sinNext;
        }
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        tessellator.func_78382_b();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(new ResourceLocation("textures/particle/particles.png"));
    }
}

