/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.entity.EntityParticleBunch;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderEntity;
import net.minecraft.entity.Entity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderEntityParticleBunch
extends RenderEntity {
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_SIZE_X = new double[]{0.0, 0.8, 1.0, 8.0, 10.0, 80.0, 100.0};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_SIZE_Y = new double[]{0.01, 0.015, 0.02, 0.04, 0.045, 0.065, 0.07};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_RED_INSIDE_Y = new double[]{0.4, 0.6, 0.7, 0.8, 0.6, 0.2, 0.2};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_GREEN_INSIDE_Y = new double[]{0.4, 0.5, 0.4, 0.2, 0.2, 0.3, 0.4};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_BLUE_INSIDE_Y = new double[]{0.2, 0.2, 0.5, 0.6, 0.6, 0.7, 0.8};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_RED_OUTSIDE_Y = new double[]{0.7, 0.9, 0.8, 0.9, 0.8, 0.65, 0.45};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_GREEN_OUTSIDE_Y = new double[]{0.8, 1.0, 0.9, 0.8, 0.6, 0.75, 1.0};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_BLUE_OUTSIDE_Y = new double[]{0.2, 0.3, 0.5, 0.6, 0.6, 0.8, 0.9};

    public void func_76986_a(Entity entity, double x, double y, double z, float rotation, float partialTick) {
        if (entity instanceof EntityParticleBunch) {
            this.doRender((EntityParticleBunch)entity, x, y, z, rotation, partialTick);
        }
    }

    public void func_76979_b(Entity entity, double x, double y, double z, float rotation, float partialTick) {
    }

    public void doRender(EntityParticleBunch entityParticleBunch, double x, double y, double z, float rotation, float partialTick) {
        int maxRenderDistanceSquared = Minecraft.func_71410_x().field_71474_y.field_74347_j ? 16384 : 400;
        if (x * x + y * y + z * z > (double)maxRenderDistanceSquared) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        double energy = entityParticleBunch.getEnergy();
        float size = (float)Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_SIZE_Y, energy);
        int rayCount_base = 45;
        RenderEntityParticleBunch.renderStar((float)entityParticleBunch.field_70173_aa + partialTick, entityParticleBunch.func_145782_y(), 45, (float)Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_RED_INSIDE_Y, energy), (float)Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_GREEN_INSIDE_Y, energy), (float)Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_BLUE_INSIDE_Y, energy), (float)Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_RED_OUTSIDE_Y, energy), (float)Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_GREEN_OUTSIDE_Y, energy), (float)Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_BLUE_OUTSIDE_Y, energy), size, size, size);
        GL11.glPopMatrix();
    }

    private static void renderStar(float ticksExisted, long seed, int rayCount_base, float redIn, float greenIn, float blueIn, float redOut, float greenOut, float blueOut, float scaleX, float scaleY, float scaleZ) {
        Random random = new Random(seed);
        int tickRotationPeriod = 220 + 2 * random.nextInt(30);
        int tickRotation = (int)(ticksExisted % (float)tickRotationPeriod);
        if (tickRotation >= tickRotationPeriod / 2) {
            tickRotation = tickRotationPeriod - tickRotation - 1;
        }
        float cycleRotation = (float)(2 * tickRotation) / (float)tickRotationPeriod;
        int tickBoostPeriod = 15 + 2 * random.nextInt(10);
        int tickBoost = (int)(ticksExisted % (float)tickBoostPeriod);
        if (tickBoost >= tickBoostPeriod / 2) {
            tickBoost = tickBoostPeriod - tickBoost - 1;
        }
        float cycleBoost = (float)(2 * tickBoost) / (float)tickBoostPeriod;
        float boost = 0.0f;
        if (cycleBoost > 0.7f) {
            boost = (cycleBoost - 0.6f) / 0.4f;
        }
        int rayCount = rayCount_base + random.nextInt(10);
        Tessellator tessellator = Tessellator.field_78398_a;
        RenderHelper.func_74518_a();
        GL11.glPushAttrib((int)24640);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)false);
        GL11.glPushMatrix();
        GL11.glScalef((float)scaleX, (float)scaleY, (float)scaleZ);
        for (int i = 0; i < rayCount; ++i) {
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f + cycleRotation * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_78371_b(6);
            float rayLength = random.nextFloat() * 15.0f + 5.0f + boost * 5.0f;
            float rayWidth = random.nextFloat() * 2.0f + 1.0f + boost * 1.0f;
            tessellator.func_78369_a(redIn, greenIn, blueIn, (float)((int)(255.0f * (1.0f - boost))));
            tessellator.func_78377_a(0.0, 0.0, 0.0);
            tessellator.func_78369_a(redOut, greenOut, blueOut, 0.0f);
            tessellator.func_78377_a(-0.866 * (double)rayWidth, (double)rayLength, -0.5 * (double)rayWidth);
            tessellator.func_78377_a(0.866 * (double)rayWidth, (double)rayLength, -0.5 * (double)rayWidth);
            tessellator.func_78377_a(0.0, (double)rayLength, 1.0 * (double)rayWidth);
            tessellator.func_78377_a(-0.866 * (double)rayWidth, (double)rayLength, -0.5 * (double)rayWidth);
            tessellator.func_78381_a();
        }
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glPopAttrib();
        RenderHelper.func_74519_b();
    }
}

