/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.BreathingManager;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.render.RenderCommons;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderOverlayAir {
    private static final int WARNING_ON_JOIN_TICKS = 400;
    private static Minecraft minecraft = Minecraft.func_71410_x();
    private static float ratioPreviousAir = 1.0f;
    private static long timePreviousAir = 0L;

    private void renderAir(int width, int height) {
        long timeDelta;
        EntityClientPlayerMP entityPlayer = RenderOverlayAir.minecraft.field_71439_g;
        if (entityPlayer == null) {
            return;
        }
        int x = MathHelper.func_76128_c((double)entityPlayer.field_70165_t);
        int y = MathHelper.func_76128_c((double)entityPlayer.field_70163_u);
        int z = MathHelper.func_76128_c((double)entityPlayer.field_70161_v);
        CelestialObject celestialObject = CelestialObjectManager.get(entityPlayer.field_70170_p, x, z);
        if (celestialObject == null || celestialObject.hasAtmosphere()) {
            return;
        }
        boolean hasVoidNearby = this.isVoid((IBlockAccess)entityPlayer.field_70170_p, x, y, z) || this.isVoid((IBlockAccess)entityPlayer.field_70170_p, x - 2, y, z) || this.isVoid((IBlockAccess)entityPlayer.field_70170_p, x + 2, y, z) || this.isVoid((IBlockAccess)entityPlayer.field_70170_p, x, y, z - 2) || this.isVoid((IBlockAccess)entityPlayer.field_70170_p, x, y, z + 2);
        boolean hasValidSetup = BreathingManager.hasValidSetup((EntityLivingBase)entityPlayer);
        float ratioAirReserve = BreathingManager.getAirReserveRatio((EntityPlayer)entityPlayer);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int alpha = 255;
        if (hasVoidNearby || entityPlayer.field_70173_aa < 400) {
            if (!hasValidSetup) {
                alpha = RenderCommons.drawSplashAlarm(width, height, "warpdrive.breathing.alarm", "warpdrive.breathing.invalid_setup");
            } else if (ratioAirReserve <= 0.0f) {
                alpha = RenderCommons.drawSplashAlarm(width, height, "warpdrive.breathing.alarm", "warpdrive.breathing.no_air");
            } else if (ratioAirReserve < 0.15f) {
                alpha = RenderCommons.drawSplashAlarm(width, height, "warpdrive.breathing.alarm", "warpdrive.breathing.low_reserve");
            }
        }
        minecraft.func_110434_K().func_110577_a(Gui.field_110324_m);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = width / 2 + 91;
        int top = height - GuiIngameForge.right_height;
        long timeWorld = entityPlayer.field_70170_p.func_82737_E();
        if (ratioAirReserve != ratioPreviousAir) {
            timePreviousAir = timeWorld;
            ratioPreviousAir = ratioAirReserve;
        }
        if ((timeDelta = timeWorld - timePreviousAir) >= 0L && timeDelta <= 8L) {
            RenderCommons.drawTexturedModalRect(left - 9, top, 25, 18, 9, 9, 100);
        } else if (timeDelta < 0L || timeDelta > 16L) {
            RenderCommons.drawTexturedModalRect(left - 9, top, 16, 18, 9, 9, 100);
        }
        int full = MathHelper.func_76143_f((double)((double)ratioAirReserve * 71.0));
        RenderCommons.drawTexturedModalRect(left - 81, top + 2, 20, 84, 71, 5, 100);
        if (alpha != 255) {
            float factor = 1.0f - (float)alpha / 255.0f;
            GL11.glColor4f((float)1.0f, (float)(0.2f + 0.8f * factor), (float)(0.2f + 0.8f * factor), (float)1.0f);
        }
        RenderCommons.drawTexturedModalRect(left - 10 - full, top + 2, 91 - full, 89, full, 5, 100);
        GuiIngameForge.right_height += 10;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    private boolean isVoid(IBlockAccess blockAccess, int x, int y, int z) {
        Block block = blockAccess.func_147439_a(x, y, z);
        return block.isAir(blockAccess, x, y, z) && !BreathingManager.isAirBlock(block);
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.AIR) {
            this.renderAir(event.resolution.func_78326_a(), event.resolution.func_78328_b());
        }
    }
}

