/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cpw.mods.fml.client.FMLClientHandler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.StarMapRegistry;
import cr0s.warpdrive.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class RenderSpaceSky
extends IRenderHandler {
    private static RenderSpaceSky INSTANCE;
    public static final int callListStars;
    private static float starBrightness;
    private static final float ALPHA_TOLERANCE = 0.00390625f;
    public static final int callListUpperSkyBox;
    public static final int callListBottomSkyBox;
    static final double PLANET_FAR = 1786.0;
    static final double PLANET_APPROACHING = 512.0;
    static final double PLANET_ORBIT = 128.0;

    public static RenderSpaceSky getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RenderSpaceSky();
        }
        return INSTANCE;
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        Vec3 vec3Player = mc.field_71439_g.func_70666_h(partialTicks);
        CelestialObject celestialObject = world.field_73011_w == null ? null : CelestialObjectManager.get((World)world, (int)vec3Player.field_72450_a, (int)vec3Player.field_72449_c);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        float alphaBase = 1.0f;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        float starBrightness = 0.2f;
        if (world.field_73011_w != null) {
            starBrightness = world.func_72880_h(partialTicks);
        }
        if (starBrightness > 0.0f && celestialObject != null) {
            this.renderStars_cached(1.0f * starBrightness);
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        if (celestialObject != null && celestialObject.opacityCelestialObjects > 0.0f) {
            Vector3 vectorPlayer = StarMapRegistry.getUniversalCoordinates(celestialObject, vec3Player.field_72450_a, vec3Player.field_72448_b, vec3Player.field_72449_c);
            for (CelestialObject celestialObjectChild : CelestialObjectManager.getRenderStack()) {
                if (celestialObject == celestialObjectChild || !celestialObject.id.equals(celestialObjectChild.parentId)) continue;
                RenderSpaceSky.renderCelestialObject(tessellator, celestialObjectChild, celestialObject.opacityCelestialObjects, vectorPlayer);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    private static void renderCelestialObject(Tessellator tessellator, CelestialObject celestialObject, float alphaSky, Vector3 vectorPlayer) {
        double distanceToBorder;
        Vector3 vectorCenter = StarMapRegistry.getUniversalCoordinates(celestialObject, celestialObject.dimensionCenterX, 64.0, celestialObject.dimensionCenterZ);
        Vector3 vectorBorderPos = StarMapRegistry.getUniversalCoordinates(celestialObject, celestialObject.dimensionCenterX + celestialObject.borderRadiusX, 64.0, celestialObject.dimensionCenterZ + celestialObject.borderRadiusZ);
        if (vectorCenter == null || vectorBorderPos == null) {
            return;
        }
        double borderRadiusX = vectorBorderPos.x - vectorCenter.x;
        double borderRadiusZ = vectorBorderPos.z - vectorCenter.z;
        double dx = Math.abs(vectorPlayer.x - vectorCenter.x) - borderRadiusX;
        double dz = Math.abs(vectorPlayer.z - vectorCenter.z) - borderRadiusZ;
        if (dx <= 0.0 && dz <= 0.0) {
            distanceToBorder = 0.0;
        } else {
            double dxOutside = Math.max(0.0, dx);
            double dzOutside = Math.max(0.0, dz);
            distanceToBorder = Math.sqrt(dxOutside * dxOutside + dzOutside * dzOutside);
        }
        double distanceToCenterX = vectorCenter.x - vectorPlayer.x;
        double distanceToCenterZ = vectorCenter.z - vectorPlayer.z;
        double distanceToCenter = Math.sqrt(distanceToCenterX * distanceToCenterX + distanceToCenterZ * distanceToCenterZ);
        double transitionFar = (Math.max(512.0, Math.min(1786.0, distanceToBorder)) - 512.0) / 1274.0;
        double transitionApproaching = (Math.max(128.0, Math.min(512.0, distanceToBorder)) - 128.0) / 384.0;
        double transitionOrbit = Math.max(0.0, Math.min(128.0, distanceToBorder)) / 128.0;
        double offsetX = (1.0 - transitionOrbit) * (distanceToCenterX / borderRadiusX);
        double offsetZ = (1.0 - transitionOrbit) * (distanceToCenterZ / borderRadiusZ);
        double planetY_far = (double)(celestialObject.dimensionId + 99 - 50) * Math.log(distanceToCenter) / 1.0;
        double planetY = planetY_far * transitionApproaching;
        double renderRange = 90.0 + 5.0 * (distanceToCenter / Math.max(borderRadiusX, borderRadiusZ));
        double renderSize = 0.05 * Math.min(1000.0, Math.max(borderRadiusX, borderRadiusZ)) * (1.0 - transitionOrbit) + 25.0 * (transitionOrbit < 1.0 ? transitionOrbit : 1.0 - transitionApproaching) + 2.5 * (transitionApproaching < 1.0 ? transitionApproaching : 1.0 - transitionFar) + 1.0 * transitionFar;
        double angleH = Math.atan2(distanceToCenterX, distanceToCenterZ);
        double angleV_far = Math.atan2(Math.sqrt(distanceToCenterX * distanceToCenterX + distanceToCenterZ * distanceToCenterZ), planetY);
        double angleV = Math.PI * (1.0 - transitionOrbit) + angleV_far * transitionOrbit;
        double angleS = 0.15 * (double)celestialObject.dimensionId * transitionApproaching + angleH * (1.0 - transitionApproaching);
        if (WarpDriveConfig.LOGGING_RENDERING && celestialObject.dimensionId == 1 && Minecraft.func_71386_F() / 10L % 100L == 0L) {
            WarpDrive.logger.info(String.format("transition Far %.2f Approaching %.2f Orbit %.2f distanceToCenter %.3f %.3f offset %.3f %.3f angle H %.3f V_far %.3f V %.3f S %.3f", transitionFar, transitionApproaching, transitionOrbit, distanceToCenterX, distanceToCenterZ, offsetX, offsetZ, angleH, angleV_far, angleV, angleS));
        }
        double sinH = Math.sin(angleH);
        double cosH = Math.cos(angleH);
        double sinV = Math.sin(angleV);
        double cosV = Math.cos(angleV);
        double sinS = Math.sin(angleS);
        double cosS = Math.cos(angleS);
        GL11.glPushMatrix();
        double time = (double)Minecraft.func_71386_F() / 1000.0;
        for (CelestialObject.RenderData renderData : celestialObject.setRenderData) {
            float offsetU = (float)(Math.signum(renderData.periodU) * (time / Math.abs(renderData.periodU) % 1.0));
            float offsetV = (float)(Math.signum(renderData.periodV) * (time / Math.abs(renderData.periodV) % 1.0));
            GL11.glColor4f((float)renderData.red, (float)renderData.green, (float)renderData.blue, (float)(renderData.alpha * alphaSky));
            if (renderData.texture != null) {
                GL11.glEnable((int)3553);
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(renderData.resourceLocation);
            } else {
                GL11.glDisable((int)3553);
            }
            if (renderData.isAdditive) {
                GL11.glBlendFunc((int)770, (int)1);
            } else {
                GL11.glBlendFunc((int)770, (int)771);
            }
            tessellator.func_78382_b();
            for (int indexVertex = 0; indexVertex < 4; ++indexVertex) {
                double offset1 = (double)((indexVertex & 2) - 1) * renderSize;
                double offset2 = (double)((indexVertex + 1 & 2) - 1) * renderSize;
                double valV = offset1 * cosS - offset2 * sinS;
                double valH = offset2 * cosS + offset1 * sinS;
                double y = valV * sinV + renderRange * cosV;
                double valD = renderRange * sinV - valV * cosV;
                double x = valD * sinH - valH * cosH + renderSize * offsetX;
                double z = valH * sinH + valD * cosH + renderSize * offsetZ;
                if (renderData.texture != null) {
                    tessellator.func_78374_a(x, y, z, (double)((float)((indexVertex & 2) / 2) + offsetU), (double)((float)((indexVertex + 1 & 2) / 2) + offsetV));
                    continue;
                }
                tessellator.func_78377_a(x, y, z);
            }
            tessellator.func_78381_a();
            renderRange -= 2.5;
        }
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPopMatrix();
    }

    private void renderStars_direct(float brightness) {
        Random rand = new Random(10842L);
        boolean hasMoreStars = rand.nextBoolean() || rand.nextBoolean();
        Tessellator tessellator = Tessellator.field_78398_a;
        double renderRangeMax = 100.0;
        for (int indexStars = 0; indexStars < (hasMoreStars ? 20000 : 2000); ++indexStars) {
            double randomZ;
            double randomY;
            double randomX;
            double randomLength;
            while ((randomLength = (randomX = rand.nextDouble() * 2.0 - 1.0) * randomX + (randomY = rand.nextDouble() * 2.0 - 1.0) * randomY + (randomZ = rand.nextDouble() * 2.0 - 1.0) * randomZ) >= 1.0 || randomLength <= 0.9) {
            }
            double renderSize = (double)0.2f + (double)0.025f * Math.log(1.1 - rand.nextDouble());
            randomLength = 1.0 / Math.sqrt(randomLength);
            double x0 = (randomX *= randomLength) * 100.0;
            double y0 = (randomY *= randomLength) * 100.0;
            double z0 = (randomZ *= randomLength) * 100.0;
            double angleH = Math.atan2(randomX, randomZ);
            double angleV = Math.atan2(Math.sqrt(randomX * randomX + randomZ * randomZ), randomY);
            double angleS = rand.nextDouble() * Math.PI * 2.0;
            int rgb = RenderSpaceSky.getStarColorRGB(rand);
            GL11.glColor4f((float)((float)(rgb >> 16 & 0xFF) / 255.0f), (float)((float)(rgb >> 8 & 0xFF) / 255.0f), (float)((float)(rgb & 0xFF) / 255.0f), (float)brightness);
            double sinH = Math.sin(angleH);
            double cosH = Math.cos(angleH);
            double sinV = Math.sin(angleV);
            double cosV = Math.cos(angleV);
            double sinS = Math.sin(angleS);
            double cosS = Math.cos(angleS);
            tessellator.func_78382_b();
            for (int indexVertex = 0; indexVertex < 4; ++indexVertex) {
                double valZero = 0.0;
                double offset1 = (double)((indexVertex & 2) - 1) * renderSize;
                double offset2 = (double)((indexVertex + 1 & 2) - 1) * renderSize;
                double valV = offset1 * cosS - offset2 * sinS;
                double valH = offset2 * cosS + offset1 * sinS;
                double y1 = valV * sinV + 0.0 * cosV;
                double valD = 0.0 * sinV - valV * cosV;
                double x1 = valD * sinH - valH * cosH;
                double z1 = valH * sinH + valD * cosH;
                tessellator.func_78377_a(x0 + x1, y0 + y1, z0 + z1);
            }
            tessellator.func_78381_a();
        }
    }

    private void renderStars_cached(float brightness) {
        if (Math.abs(starBrightness - brightness) > 0.00390625f) {
            starBrightness = brightness;
            GL11.glPushMatrix();
            GL11.glNewList((int)callListStars, (int)4864);
            this.renderStars_direct(brightness);
            GL11.glEndList();
            GL11.glPopMatrix();
        }
        GL11.glCallList((int)callListStars);
    }

    private static int getStarColorRGB(Random rand) {
        float saturation;
        float hue;
        double colorType = rand.nextDouble();
        float brightness = 1.0f - 0.8f * rand.nextFloat();
        if (colorType <= 0.08) {
            hue = 0.48f + 0.08f * rand.nextFloat();
            saturation = 0.18f + 0.22f * rand.nextFloat();
        } else if (colorType <= 0.24) {
            hue = 0.126f + 0.04f * rand.nextFloat();
            saturation = 0.0f + 0.15f * rand.nextFloat();
            brightness *= 0.95f;
        } else if (colorType <= 0.45) {
            hue = 0.126f + 0.04f * rand.nextFloat();
            saturation = 0.15f + 0.15f * rand.nextFloat();
            brightness *= 0.9f;
        } else if (colorType <= 0.67) {
            hue = 0.126f + 0.04f * rand.nextFloat();
            saturation = 0.8f + 0.15f * rand.nextFloat();
            brightness = rand.nextInt(3) == 1 ? (brightness *= 0.9f) : (brightness *= 0.85f);
        } else if (colorType <= 0.92) {
            hue = 0.055f + 0.055f * rand.nextFloat();
            saturation = 0.85f + 0.15f * rand.nextFloat();
            brightness = rand.nextInt(3) == 1 ? (brightness *= 0.9f) : (brightness *= 0.8f);
        } else {
            hue = 0.95f + 0.05f * rand.nextFloat();
            if (rand.nextInt(3) == 1) {
                saturation = 0.8f + 0.2f * rand.nextFloat();
                brightness *= 0.95f;
            } else {
                saturation = 0.7f + 0.2f * rand.nextFloat();
                brightness *= 0.65f;
            }
        }
        return Color.HSBtoRGB(hue, saturation, brightness);
    }

    private static Vec3 getCustomSkyColor() {
        return Vec3.func_72443_a((double)0.26796875, (double)0.1796875, (double)0.0);
    }

    public static float getSkyBrightness(float par1) {
        float var2 = FMLClientHandler.instance().getClient().field_71441_e.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76126_a((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 1.0f;
    }

    static {
        int z;
        int x;
        INSTANCE = null;
        callListStars = GLAllocation.func_74526_a((int)3);
        starBrightness = 0.0f;
        callListUpperSkyBox = callListStars + 1;
        callListBottomSkyBox = callListStars + 2;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glNewList((int)callListUpperSkyBox, (int)4864);
        int stepSize = 64;
        int nbSteps = 6;
        float y = 16.0f;
        for (x = -384; x <= 384; x += 64) {
            for (z = -384; z <= 384; z += 64) {
                tessellator.func_78382_b();
                tessellator.func_78377_a((double)x, (double)y, (double)z);
                tessellator.func_78377_a((double)(x + 64), (double)y, (double)z);
                tessellator.func_78377_a((double)(x + 64), (double)y, (double)(z + 64));
                tessellator.func_78377_a((double)x, (double)y, (double)(z + 64));
                tessellator.func_78381_a();
            }
        }
        GL11.glEndList();
        GL11.glNewList((int)callListBottomSkyBox, (int)4864);
        y = -16.0f;
        tessellator.func_78382_b();
        for (x = -384; x <= 384; x += 64) {
            for (z = -384; z <= 384; z += 64) {
                tessellator.func_78377_a((double)(x + 64), (double)y, (double)z);
                tessellator.func_78377_a((double)x, (double)y, (double)z);
                tessellator.func_78377_a((double)x, (double)y, (double)(z + 64));
                tessellator.func_78377_a((double)(x + 64), (double)y, (double)(z + 64));
            }
        }
        tessellator.func_78381_a();
        GL11.glEndList();
    }
}

