/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.render.RenderBlank;
import cr0s.warpdrive.render.RenderSpaceSky;
import net.minecraft.entity.Entity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;

public abstract class AbstractWorldProvider
extends WorldProvider {
    protected CelestialObject celestialObjectDimension = null;
    protected boolean isRemote;
    protected static CelestialObject celestialObject = null;

    protected void updateCelestialObject() throws RuntimeException {
        if (this.field_76574_g == 0) {
            throw new RuntimeException("Critical error: you can't use a WorldProvider before settings its dimension id!");
        }
        if (this.celestialObjectDimension == null) {
            this.isRemote = FMLCommonHandler.instance().getEffectiveSide().isClient();
            this.celestialObjectDimension = CelestialObjectManager.get(this.isRemote, this.field_76574_g, 0, 0);
        }
    }

    public String getSaveFolder() {
        this.updateCelestialObject();
        if (this.celestialObjectDimension == null) {
            throw new RuntimeException(String.format("Critical error: there's no celestial object defining %s dimension id %d, unable to proceed further", this.isRemote ? "client" : "server", this.field_76574_g));
        }
        return this.celestialObjectDimension.id;
    }

    public String func_80007_l() {
        this.updateCelestialObject();
        if (this.celestialObjectDimension == null) {
            if (this.isRemote) {
                return String.format("DIM%d", this.field_76574_g);
            }
            throw new RuntimeException(String.format("Critical error: there's no celestial object defining %s dimension id %d, unable to proceed further", "server", this.field_76574_g));
        }
        return this.celestialObjectDimension.id;
    }

    public boolean func_76566_a(int x, int z) {
        int y = this.field_76579_a.func_72825_h(x, z);
        return y != 0;
    }

    public ChunkCoordinates func_76554_h() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 getSkyColor(Entity cameraEntity, float partialTicks) {
        if (this.getCloudRenderer() == null) {
            this.setCloudRenderer(RenderBlank.getInstance());
        }
        if (this.getSkyRenderer() == null) {
            this.setSkyRenderer(RenderSpaceSky.getInstance());
        }
        CelestialObject celestialObject = AbstractWorldProvider.celestialObject = cameraEntity.field_70170_p == null ? null : CelestialObjectManager.get(cameraEntity.field_70170_p, MathHelper.func_76128_c((double)cameraEntity.field_70165_t), MathHelper.func_76128_c((double)cameraEntity.field_70161_v));
        if (AbstractWorldProvider.celestialObject == null) {
            return Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
        }
        return Vec3.func_72443_a((double)AbstractWorldProvider.celestialObject.backgroundColor.red, (double)AbstractWorldProvider.celestialObject.backgroundColor.green, (double)AbstractWorldProvider.celestialObject.backgroundColor.blue);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float celestialAngle, float par2) {
        float factor = Commons.clamp(0.0f, 1.0f, MathHelper.func_76134_b((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f);
        float red = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.colorFog.red;
        float green = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.colorFog.green;
        float blue = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.colorFog.blue;
        float factorRed = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.factorFog.red;
        float factorGreen = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.factorFog.green;
        float factorBlue = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.factorFog.blue;
        return Vec3.func_72443_a((double)(red *= factor * factorRed + (1.0f - factorRed)), (double)(green *= factor * factorGreen + (1.0f - factorGreen)), (double)(blue *= factor * factorBlue + (1.0f - factorBlue)));
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        if (celestialObject == null) {
            return 0.0f;
        }
        float starBrightnessVanilla = super.getStarBrightness(partialTicks);
        return AbstractWorldProvider.celestialObject.baseStarBrightness + AbstractWorldProvider.celestialObject.vanillaStarBrightness * starBrightnessVanilla;
    }
}

