/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.structures.Orb;
import cr0s.warpdrive.config.structures.OrbInstance;
import cr0s.warpdrive.data.JumpBlock;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public final class EntitySphereGen
extends Entity {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    private int radius;
    private int gasColor;
    private static final int BLOCKS_PER_TICK = 5000;
    private static final int STATE_SAVING = 0;
    private static final int STATE_SETUP = 1;
    private static final int STATE_DELETE = 2;
    private static final int STATE_STOP = 3;
    private int state = 2;
    private int ticksDelay = 0;
    private int currentIndex = 0;
    private int pregenSize = 0;
    private ArrayList<JumpBlock> blocks;
    private ArrayList<Boolean> isSurfaces;
    private OrbInstance orbInstance;
    private boolean replace;

    public EntitySphereGen(World world) {
        super(world);
    }

    public EntitySphereGen(World world, int x, int y, int z, OrbInstance orbInstance, boolean replace) {
        super(world);
        this.xCoord = x;
        this.field_70165_t = x;
        this.yCoord = y;
        this.field_70163_u = y;
        this.zCoord = z;
        this.field_70161_v = z;
        this.orbInstance = orbInstance;
        this.gasColor = this.field_70170_p.field_73012_v.nextInt(12);
        this.radius = orbInstance.getTotalThickness();
        this.state = 0;
        this.pregenSize = (int)Math.ceil(4.1887902047863905 * Math.pow(this.radius + 1, 3.0));
        this.blocks = new ArrayList(this.pregenSize);
        this.isSurfaces = new ArrayList(this.pregenSize);
        this.ticksDelay = world.field_73012_v.nextInt(60);
        this.replace = replace;
    }

    public void killEntity() {
        this.state = 3;
        int minY_clamped = Math.max(0, this.yCoord - this.radius);
        int maxY_clamped = Math.min(255, this.yCoord + this.radius);
        for (int x = this.xCoord - this.radius; x <= this.xCoord + this.radius; ++x) {
            for (int z = this.zCoord - this.radius; z <= this.zCoord + this.radius; ++z) {
                for (int y = minY_clamped; y <= maxY_clamped; ++y) {
                    if (this.field_70170_p.func_147439_a(x, y, z) == Blocks.field_150350_a) continue;
                    this.field_70170_p.func_147471_g(x, y, z);
                }
            }
        }
        this.field_70170_p.func_72900_e((Entity)this);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.ticksDelay > 0) {
            --this.ticksDelay;
            return;
        }
        switch (this.state) {
            case 0: {
                this.tickScheduleBlocks();
                this.state = 1;
                break;
            }
            case 1: {
                if (this.currentIndex >= this.blocks.size() - 1) {
                    this.state = 2;
                    break;
                }
                this.tickPlaceBlocks();
                break;
            }
            case 2: {
                this.currentIndex = 0;
                this.killEntity();
                break;
            }
            default: {
                WarpDrive.logger.error((Object)((Object)this) + " Invalid state " + this.state + ". Killing entity...");
                this.killEntity();
            }
        }
    }

    private void tickPlaceBlocks() {
        int blocksToMove = Math.min(5000, this.blocks.size() - this.currentIndex);
        LocalProfiler.start("[EntitySphereGen] Placing blocks from " + this.currentIndex + " to " + (this.currentIndex + blocksToMove) + "/" + this.blocks.size());
        for (int index = 0; index < blocksToMove && this.currentIndex < this.blocks.size(); ++index) {
            int notifyFlag = this.currentIndex % 1024 == 0 ? 2 : 2;
            JumpBlock jumpBlock = this.blocks.get(this.currentIndex);
            if (this.isSurfaces.get(this.currentIndex).booleanValue()) {
                this.field_70170_p.func_147465_d(jumpBlock.x, jumpBlock.y, jumpBlock.z, jumpBlock.block, jumpBlock.blockMeta, notifyFlag);
            } else {
                JumpBlock.setBlockNoLight(this.field_70170_p, jumpBlock.x, jumpBlock.y, jumpBlock.z, jumpBlock.block, jumpBlock.blockMeta, notifyFlag);
            }
            ++this.currentIndex;
        }
        LocalProfiler.stop();
    }

    private void tickScheduleBlocks() {
        LocalProfiler.start("[EntitySphereGen] Saving blocks, radius " + this.radius);
        double sqRadiusHigh = ((double)this.radius + 0.5) * ((double)this.radius + 0.5);
        double sqRadiusLow = ((double)this.radius - 0.5) * ((double)this.radius - 0.5);
        int ceilRadius = this.radius + 1;
        for (int x = 0; x <= ceilRadius; ++x) {
            double x2 = ((double)x + 0.5) * ((double)x + 0.5);
            for (int y = 0; y <= ceilRadius; ++y) {
                double x2y2 = x2 + ((double)y + 0.5) * ((double)y + 0.5);
                for (int z = 0; z <= ceilRadius; ++z) {
                    double sqRange = x2y2 + ((double)z + 0.5) * ((double)z + 0.5);
                    if (sqRange > sqRadiusHigh) continue;
                    boolean isSurface = sqRange > sqRadiusLow;
                    Orb.OrbShell orbShell = this.orbInstance.getShellForSqRadius(sqRange);
                    this.addBlock(isSurface, new JumpBlock((Filler)orbShell.getRandomUnit(this.field_70146_Z), this.xCoord + x, this.yCoord + y, this.zCoord + z));
                    this.addBlock(isSurface, new JumpBlock((Filler)orbShell.getRandomUnit(this.field_70146_Z), this.xCoord - x, this.yCoord + y, this.zCoord + z));
                    this.addBlock(isSurface, new JumpBlock((Filler)orbShell.getRandomUnit(this.field_70146_Z), this.xCoord + x, this.yCoord - y, this.zCoord + z));
                    this.addBlock(isSurface, new JumpBlock((Filler)orbShell.getRandomUnit(this.field_70146_Z), this.xCoord + x, this.yCoord + y, this.zCoord - z));
                    this.addBlock(isSurface, new JumpBlock((Filler)orbShell.getRandomUnit(this.field_70146_Z), this.xCoord - x, this.yCoord - y, this.zCoord + z));
                    this.addBlock(isSurface, new JumpBlock((Filler)orbShell.getRandomUnit(this.field_70146_Z), this.xCoord + x, this.yCoord - y, this.zCoord - z));
                    this.addBlock(isSurface, new JumpBlock((Filler)orbShell.getRandomUnit(this.field_70146_Z), this.xCoord - x, this.yCoord + y, this.zCoord - z));
                    this.addBlock(isSurface, new JumpBlock((Filler)orbShell.getRandomUnit(this.field_70146_Z), this.xCoord - x, this.yCoord - y, this.zCoord - z));
                }
            }
        }
        if (this.blocks != null && this.blocks.size() > this.pregenSize) {
            WarpDrive.logger.warn("[EntitySphereGen] Saved " + this.blocks.size() + " blocks (estimated to " + this.pregenSize + ")");
        }
        LocalProfiler.stop();
    }

    private void addBlock(boolean isSurface, JumpBlock jumpBlock) {
        if (this.blocks == null) {
            return;
        }
        if (this.field_70170_p.func_147439_a(jumpBlock.x, jumpBlock.y, jumpBlock.z).func_149667_c(Blocks.field_150355_j)) {
            if (this.field_70170_p.field_73012_v.nextInt(50) != 1) {
                jumpBlock.block = WarpDrive.blockGas;
                jumpBlock.blockMeta = this.gasColor;
            }
            this.blocks.add(jumpBlock);
            this.isSurfaces.add(isSurface);
            return;
        }
        if (!this.replace && !this.field_70170_p.func_147437_c(jumpBlock.x, jumpBlock.y, jumpBlock.z)) {
            return;
        }
        this.blocks.add(jumpBlock);
        this.isSurfaces.add(isSurface);
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
    }

    protected void func_70088_a() {
        this.field_70145_X = true;
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int p_70056_9_) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }
}

