/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.GenericSet;
import cr0s.warpdrive.config.Loot;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.data.Transformation;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenStructure {
    private final boolean corrupted;
    private final Random rand;
    private final Filler fillerHullPlain;
    private final Filler fillerHullGlass;
    private final Filler fillerSolarPanel;
    private final Filler fillerWiring;
    private final Filler fillerPropulsion;

    public WorldGenStructure(boolean corrupted, Random rand) {
        this.corrupted = corrupted;
        this.rand = rand;
        GenericSet<Filler> fillerSetHull_plain = WarpDriveConfig.FillerManager.getRandomSetFromGroup(rand, "hull_plain");
        if (fillerSetHull_plain == null) {
            WarpDrive.logger.warn(String.format("No FillerSet found with group %s during world generation: check your configuration", "hull_plain"));
            this.fillerHullPlain = new Filler();
            this.fillerHullPlain.block = Blocks.field_150348_b;
            this.fillerHullGlass = new Filler();
            this.fillerHullGlass.block = Blocks.field_150359_w;
        } else {
            this.fillerHullPlain = fillerSetHull_plain.getRandomUnit(rand);
            String nameFillerGlass = "hull_glass:" + fillerSetHull_plain.getName();
            GenericSet<Filler> fillerSetHull_glass = WarpDriveConfig.FillerManager.getGenericSet(nameFillerGlass);
            if (fillerSetHull_glass == null) {
                WarpDrive.logger.warn(String.format("No FillerSet found with group %s during world generation: check your configuration", nameFillerGlass));
                this.fillerHullGlass = new Filler();
                this.fillerHullGlass.block = Blocks.field_150359_w;
            } else {
                this.fillerHullGlass = fillerSetHull_glass.getRandomUnit(rand);
            }
        }
        GenericSet<Filler> fillerSetSolarPanel = WarpDriveConfig.FillerManager.getRandomSetFromGroup(rand, "ship_solarPanel");
        if (fillerSetSolarPanel == null) {
            WarpDrive.logger.warn(String.format("No FillerSet found with group %s during world generation: check your configuration", "ship_solarPanel"));
            this.fillerSolarPanel = new Filler();
            this.fillerSolarPanel.block = Blocks.field_150322_A;
            this.fillerWiring = new Filler();
            this.fillerWiring.block = Blocks.field_150422_aJ;
        } else {
            this.fillerSolarPanel = fillerSetSolarPanel.getRandomUnit(rand);
            String nameFillerWiring = "ship_wiring:" + fillerSetSolarPanel.getName();
            GenericSet<Filler> fillerSetWiring = WarpDriveConfig.FillerManager.getGenericSet(nameFillerWiring);
            if (fillerSetWiring == null) {
                WarpDrive.logger.warn(String.format("No FillerSet found with group %s during world generation: check your configuration", nameFillerWiring));
                this.fillerWiring = new Filler();
                this.fillerWiring.block = Blocks.field_150422_aJ;
            } else {
                this.fillerWiring = fillerSetWiring.getRandomUnit(rand);
            }
        }
        GenericSet<Filler> fillerSetPropulsion = WarpDriveConfig.FillerManager.getRandomSetFromGroup(rand, "ship_propulsion");
        if (fillerSetPropulsion == null) {
            WarpDrive.logger.warn(String.format("No FillerSet found with group %s during world generation: check your configuration", "ship_propulsion"));
            this.fillerPropulsion = new Filler();
            this.fillerPropulsion.block = Blocks.field_150364_r;
        } else {
            this.fillerPropulsion = fillerSetPropulsion.getRandomUnit(rand);
        }
    }

    public void setHullPlain(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(400) == 1) {
            world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 17.0f, false, true);
        } else if (this.corrupted && this.rand.nextInt(10) == 1) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        } else {
            this.fillerHullPlain.setBlock(world, x, y, z);
        }
    }

    public void setHullGlass(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(5) == 1) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        } else {
            this.fillerHullGlass.setBlock(world, x, y, z);
        }
    }

    public void setSolarPanel(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(3) == 1) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        } else {
            this.fillerSolarPanel.setBlock(world, x, y, z);
        }
    }

    public void setWiring(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(3) == 1) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        } else {
            this.fillerWiring.setBlock(world, x, y, z);
        }
    }

    public void setPropulsion(World world, int x, int y, int z) {
        this.fillerPropulsion.setBlock(world, x, y, z);
    }

    public void fillInventoryWithLoot(World worldObj, Random rand, int x, int y, int z, String group) {
        TileEntity tileEntity = worldObj.func_147438_o(x, y, z);
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            int size = inventory.func_70302_i_();
            int countLoots = Math.min(rand.nextInt(3) + rand.nextInt(4), size);
            GenericSet<Loot> lootSet = WarpDriveConfig.LootManager.getRandomSetFromGroup(rand, group);
            if (lootSet == null) {
                WarpDrive.logger.warn(String.format("No LootSet found with group %s for inventory @ %s (%d %d %d): check your configuration", group, worldObj.field_73011_w.func_80007_l(), x, y, z));
                return;
            }
            for (int i = 0; i < countLoots; ++i) {
                boolean isAdded = false;
                for (int countLootRetries = 0; countLootRetries < 3 && !isAdded; ++countLootRetries) {
                    ItemStack itemStackLoot = lootSet.getRandomUnit(rand).getItemStack(rand);
                    for (int countSlotRetries = 0; countSlotRetries < 5 && !isAdded; ++countSlotRetries) {
                        int indexSlot = rand.nextInt(size);
                        if (!inventory.func_94041_b(indexSlot, itemStackLoot)) continue;
                        inventory.func_70299_a(indexSlot, itemStackLoot);
                        isAdded = true;
                    }
                }
                if (isAdded) continue;
                WarpDrive.logger.info(String.format("Unable to find a valid loot from LootSet %s for inventory %s in @ %s (%d %d %d): check your configuration", lootSet.getFullName(), inventory.func_145825_b() == null ? "-null name-" : inventory.func_145825_b(), worldObj.field_73011_w.func_80007_l(), x, y, z));
            }
        }
    }

    public void generateFromFile(World world, String filename, int targetX, int targetY, int targetZ, byte rotationSteps) {
        StringBuilder reason = new StringBuilder();
        JumpShip jumpShip = JumpShip.createFromFile(filename, reason);
        if (jumpShip == null) {
            WarpDrive.logger.error(String.format("%s Failed to read schematic %s: %s", this, filename, reason.toString()));
            return;
        }
        this.deployShip(world, jumpShip, targetX, targetY, targetZ, rotationSteps);
    }

    public void deployShip(World world, JumpShip jumpShip, int targetX, int targetY, int targetZ, byte rotationSteps) {
        Transformation transformation = new Transformation(jumpShip, world, targetX - jumpShip.coreX, targetY - jumpShip.coreY, targetZ - jumpShip.coreZ, rotationSteps);
        for (int index = 0; index < jumpShip.jumpBlocks.length; ++index) {
            JumpBlock jumpBlock = jumpShip.jumpBlocks[index];
            if (jumpBlock == null) {
                if (!WarpDriveConfig.LOGGING_BUILDING) continue;
                WarpDrive.logger.info("At index " + index + ", skipping undefined block");
                continue;
            }
            if (jumpBlock.block == Blocks.field_150350_a) {
                if (!WarpDriveConfig.LOGGING_BUILDING) continue;
                WarpDrive.logger.info("At index " + index + ", skipping air block");
                continue;
            }
            if (Dictionary.BLOCKS_ANCHOR.contains(jumpBlock.block)) {
                if (!WarpDriveConfig.LOGGING_BUILDING) continue;
                WarpDrive.logger.info("At index " + index + ", skipping anchor block " + jumpBlock.block);
                continue;
            }
            ++index;
            if (WarpDriveConfig.LOGGING_WORLD_GENERATION && WarpDrive.isDev) {
                WarpDrive.logger.info(String.format("At index %d, deploying %s ", index, jumpBlock));
            }
            ChunkCoordinates targetLocation = transformation.apply(jumpBlock.x, jumpBlock.y, jumpBlock.z);
            Block blockAtTarget = world.func_147439_a(targetLocation.field_71574_a, targetLocation.field_71572_b, targetLocation.field_71573_c);
            if (blockAtTarget == Blocks.field_150350_a || Dictionary.BLOCKS_EXPANDABLE.contains(blockAtTarget)) {
                jumpBlock.deploy(world, transformation);
                continue;
            }
            if (!WarpDriveConfig.LOGGING_WORLD_GENERATION || !WarpDrive.isDev) continue;
            WarpDrive.logger.info("Deployment collision detected at " + (targetX + jumpBlock.x) + " " + (targetY + jumpBlock.y) + " " + (targetZ + jumpBlock.z));
        }
    }
}

