/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores.ores;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.netherores.NetherOresCore;
import powercrystals.netherores.entity.EntityArmedOre;
import powercrystals.netherores.gui.NOCreativeTab;
import powercrystals.netherores.ores.INetherOre;
import powercrystals.netherores.ores.Ores;
import powercrystals.netherores.world.BlockHellfish;

public class BlockNetherOres
extends Block
implements INetherOre {
    private final int _blockIndex;
    private final IIcon[] _netherOresIcons = new IIcon[16];
    private final Ores[] _ores;
    private Random rand = new Random();
    private ThreadLocal<Boolean> explode = new ThreadLocal();
    private ThreadLocal<Boolean> willAnger = new ThreadLocal();

    public BlockNetherOres(int n) {
        super(Blocks.field_150424_aL.func_149688_o());
        this.func_149711_c(5.0f);
        this.func_149752_b(1.0f);
        this.func_149663_c("netherores.ore." + n);
        this.func_149672_a(Block.field_149769_e);
        this.func_149647_a(NOCreativeTab.tab);
        this._blockIndex = n;
        Ores[] oresArray = Ores.values();
        this._ores = Arrays.copyOfRange(oresArray, n * 16, Math.min(n * 16 + 16, oresArray.length));
    }

    public int getBlockIndex() {
        return this._blockIndex;
    }

    public void func_149651_a(IIconRegister iIconRegister) {
        int n = this._ores.length;
        for (int i = 0; i < n; ++i) {
            this._netherOresIcons[i] = iIconRegister.func_94245_a("netherores:" + this._ores[i].name());
        }
    }

    public IIcon func_149691_a(int n, int n2) {
        return this._netherOresIcons[n2];
    }

    public ArrayList<ItemStack> getDrops(World world, int n, int n2, int n3, int n4, int n5) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        int n6 = this.quantityDropped(n4, n5, world.field_73012_v);
        ItemStack itemStack = new ItemStack(this.func_149650_a(n4, world.field_73012_v, n5), 1, this.func_149692_a(n4));
        if (n4 < this._ores.length && this._ores[n4].getDropItem() != null) {
            itemStack = this._ores[n4].getDropItem();
        } else {
            n6 = 1;
        }
        for (int i = 0; i < n6; ++i) {
            arrayList.add(itemStack.func_77946_l());
        }
        return arrayList;
    }

    public int func_149692_a(int n) {
        return n;
    }

    public int quantityDropped(int n, int n2, Random random) {
        int n3 = this._ores[n].getDropCount();
        if (n3 > 1) {
            int n4 = n2 > 0 ? random.nextInt(n2 + 1) + 1 : 1;
            return random.nextInt(n3 * n4) + n4;
        }
        return 1;
    }

    public boolean canSilkHarvest(World world, EntityPlayer entityPlayer, int n, int n2, int n3, int n4) {
        return true;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int getExpDrop(IBlockAccess iBlockAccess, int n, int n2) {
        int n3 = 0;
        if (this._ores[n].getDropCount() > 1 && this._ores[n].getDropItem() != null) {
            n3 = this._ores[n].getExp();
            n3 = MathHelper.func_76136_a((Random)this.rand, (int)n3, (int)(n3 * 2 + 1)) + (n3 > 1 ? this.rand.nextInt(n3) : 0);
        }
        return n3;
    }

    public boolean removedByPlayer(World world, EntityPlayer entityPlayer, int n, int n2, int n3, boolean bl) {
        boolean bl2 = entityPlayer == null || !EnchantmentHelper.func_77502_d((EntityLivingBase)entityPlayer);
        this.explode.set(bl2);
        this.willAnger.set(true);
        boolean bl3 = super.removedByPlayer(world, entityPlayer, n, n2, n3, bl);
        if (bl2 || NetherOresCore.silkyStopsPigmen.getBoolean(true)) {
            BlockNetherOres.angerPigmen(entityPlayer, world, n, n2, n3);
        }
        this.willAnger.set(false);
        this.explode.set(true);
        if (NetherOresCore.enableFortuneExplosions.getBoolean(true)) {
            int n4 = EnchantmentHelper.func_77517_e((EntityLivingBase)entityPlayer);
            int n5 = n4 = n4 > 0 ? world.field_73012_v.nextInt(n4) : 0;
            while (n4-- > 0) {
                BlockNetherOres.checkExplosionChances(this, world, n, n2, n3);
            }
        }
        return bl3;
    }

    public void func_149749_a(World world, int n, int n2, int n3, Block block, int n4) {
        if (this.explode.get() != Boolean.FALSE) {
            BlockNetherOres.checkExplosionChances(this, world, n, n2, n3);
        }
        if (this.willAnger.get() != Boolean.TRUE) {
            BlockNetherOres.angerPigmen(world, n, n2, n3);
        }
        if (NetherOresCore.hellFishFromOre.getBoolean(false) && world.field_73012_v.nextInt(10000) < NetherOresCore.hellFishFromOreChance.getInt()) {
            BlockHellfish.spawnHellfish(world, n, n2, n3);
        }
        super.func_149749_a(world, n, n2, n3, block, n4);
    }

    public void onBlockExploded(World world, int n, int n2, int n3, Explosion explosion) {
        this.explode.set(false);
        this.willAnger.set(NetherOresCore.enableMobsAngerPigmen.getBoolean(true) || explosion == null || !(explosion.func_94613_c() instanceof EntityLiving));
        super.onBlockExploded(world, n, n2, n3, explosion);
        this.willAnger.set(true);
        this.explode.set(true);
        if (NetherOresCore.enableExplosionChainReactions.getBoolean(true)) {
            BlockNetherOres.checkExplosionChances(this, world, n, n2, n3);
        }
    }

    public boolean isFireSource(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return forgeDirection == ForgeDirection.UP;
    }

    public static void checkExplosionChances(Block block, World world, int n, int n2, int n3) {
        if (!world.field_72995_K && NetherOresCore.enableExplosions.getBoolean(true)) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        int n4;
                        int n5;
                        int n6;
                        if ((i | j | k) == 0 || !((block = world.func_147439_a(n6 = n + i, n5 = n2 + j, n4 = n3 + k)) instanceof INetherOre) || world.field_73012_v.nextInt(1000) >= NetherOresCore.explosionProbability.getInt()) continue;
                        EntityArmedOre entityArmedOre = new EntityArmedOre(world, (double)n6 + 0.5, (double)n5 + 0.5, (double)n4 + 0.5, block);
                        world.func_72838_d((Entity)entityArmedOre);
                        world.func_72908_a((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "game.tnt.primed", 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public static void angerPigmen(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        int n4 = NetherOresCore.pigmenAggroRange.getInt();
        if (NetherOresCore.enableAngryPigmen.getBoolean(true)) {
            List list = world.func_72872_a(EntityPigZombie.class, AxisAlignedBB.func_72330_a((double)(n - n4), (double)(n2 - n4), (double)(n3 - n4), (double)(n + n4 + 1), (double)(n2 + n4 + 1), (double)(n3 + n4 + 1)));
            for (int i = 0; i < list.size(); ++i) {
                ((EntityPigZombie)list.get(i)).func_70835_c((Entity)entityPlayer);
            }
        }
    }

    public static void angerPigmen(World world, int n, int n2, int n3) {
        BlockNetherOres.angerPigmen(null, world, n, n2, n3);
    }
}

