/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import net.minecraft.block.Block;

public final class BlockWrapper {
    public Block block;
    public int metadata;

    public BlockWrapper(Block block, int n) {
        this.block = block;
        this.metadata = n;
    }

    public BlockWrapper set(Block block, int n) {
        if (block != null) {
            this.block = block;
            this.metadata = n;
        } else {
            this.block = null;
            this.metadata = 0;
        }
        return this;
    }

    public boolean isEqual(BlockWrapper blockWrapper) {
        if (blockWrapper == null) {
            return false;
        }
        if (this.metadata == blockWrapper.metadata) {
            if (this.block == blockWrapper.block) {
                return true;
            }
            if (this.block != null && blockWrapper.block != null) {
                return this.block.delegate.get() == blockWrapper.block.delegate.get();
            }
        }
        return false;
    }

    final int getId() {
        return Block.func_149682_b((Block)this.block);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BlockWrapper)) {
            return false;
        }
        return this.isEqual((BlockWrapper)object);
    }

    public int hashCode() {
        return this.metadata | this.getId() << 16;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append('@').append(System.identityHashCode(this)).append('{');
        stringBuilder.append("m:").append(this.metadata).append(", i:").append(this.block == null ? null : this.block.getClass().getName());
        stringBuilder.append('@').append(System.identityHashCode(this.block)).append(", v:");
        stringBuilder.append(this.getId()).append('}');
        return stringBuilder.toString();
    }
}

