/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.asm.writer;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.asm.writer.HierarchyNode;
import net.ilexiconn.llibrary.server.asm.writer.RawClassFetcher;
import net.ilexiconn.llibrary.server.core.plugin.LLibraryPlugin;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ClassHierarchy {
    private static Method findLoadedClass;
    private final HierarchyNode root;

    ClassHierarchy(HierarchyNode root) {
        this.root = root;
    }

    public static ClassHierarchy build(String type, ClassLoader classLoader, RawClassFetcher fetcher) {
        return new ClassHierarchy(ClassHierarchy.fetchNode(type.replace('/', '.'), classLoader, fetcher));
    }

    private static HierarchyNode fetchNode(String type, ClassLoader classLoader, RawClassFetcher fetcher) {
        Class<?> loadedClass = ClassHierarchy.getLoadedClass(type);
        if (loadedClass != null) {
            return ClassHierarchy.readClassNode(loadedClass);
        }
        HierarchyNode rawClassNode = ClassHierarchy.readRawClass(type, classLoader, fetcher);
        if (rawClassNode != null) {
            return rawClassNode;
        }
        LLibraryPlugin.LOGGER.warn("Failed to fetch hierarchy node for {}. This may cause patch issues", (Object)type);
        return new HierarchyNode(type, false);
    }

    private static HierarchyNode readClassNode(Class<?> type) {
        Class<?>[] interfaces;
        HierarchyNode node = new HierarchyNode(type.getName(), type.isInterface());
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            node.add(ClassHierarchy.readClassNode(superclass));
        }
        for (Class<?> interfaceType : interfaces = type.getInterfaces()) {
            node.add(ClassHierarchy.readClassNode(interfaceType));
        }
        return node;
    }

    @Nullable
    private static HierarchyNode readRawClass(String type, ClassLoader classLoader, RawClassFetcher fetcher) {
        try {
            byte[] rawBytes = ClassHierarchy.readRawBytes(type, fetcher);
            if (rawBytes != null) {
                ClassNode classNode = ClassHierarchy.read(rawBytes);
                HierarchyNode node = new HierarchyNode(type, Modifier.isInterface(classNode.access));
                if (classNode.superName != null) {
                    node.add(ClassHierarchy.fetchNode(classNode.superName.replace('/', '.'), classLoader, fetcher));
                }
                if (classNode.interfaces != null) {
                    for (String interfaceType : classNode.interfaces) {
                        node.add(ClassHierarchy.fetchNode(interfaceType.replace('/', '.'), classLoader, fetcher));
                    }
                }
                return node;
            }
        }
        catch (IOException e) {
            LLibraryPlugin.LOGGER.error("Failed to read bytes for class {}", (Object)type, (Object)e);
        }
        return null;
    }

    @Nullable
    private static byte[] readRawBytes(String type, RawClassFetcher fetcher) throws IOException {
        String typePath = type.replace('.', '/');
        byte[] rawBytes = fetcher.fetch(typePath);
        if (rawBytes != null) {
            return rawBytes;
        }
        ClassLoader appClassLoader = Launch.class.getClassLoader();
        try (InputStream input = appClassLoader.getResourceAsStream(typePath + ".class");){
            if (input == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)input);
            return byArray;
        }
    }

    private static ClassNode read(byte[] bytes) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 7);
        return node;
    }

    @Nullable
    private static Class<?> getLoadedClass(String name) {
        if (findLoadedClass == null) {
            return null;
        }
        try {
            return (Class)findLoadedClass.invoke((Object)Launch.classLoader, name);
        }
        catch (ReflectiveOperationException e) {
            LLibraryPlugin.LOGGER.error("Failed to find loaded class", (Throwable)e);
            return null;
        }
    }

    public String findCommon(ClassHierarchy other) {
        if (other.root.instanceOf(this.root)) {
            return this.root.getType();
        }
        if (this.root.instanceOf(other.root)) {
            return other.root.getType();
        }
        if (this.root.isInterface() || other.root.isInterface()) {
            return "java.lang.Object";
        }
        HierarchyNode node = this.root;
        do {
            if ((node = node.getSuper()) != null) continue;
            return "java.lang.Object";
        } while (!other.root.instanceOf(node));
        return node.getType();
    }

    static {
        try {
            findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoadedClass.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            LLibraryPlugin.LOGGER.error("Failed to get findLoadedClass method", (Throwable)e);
        }
    }
}

