/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.factory;

import de.eydamos.backpack.factory.IFactory;
import de.eydamos.backpack.gui.GuiBackpack;
import de.eydamos.backpack.helper.BackpackHelper;
import de.eydamos.backpack.storage.container.Boundaries;
import de.eydamos.backpack.storage.container.ContainerAdvanced;
import de.eydamos.backpack.storage.slot.SlotBackpack;
import de.eydamos.backpack.storage.slot.SlotMainHand;
import de.eydamos.guiadvanced.form.Label;
import de.eydamos.guiadvanced.subpart.GuiSlot;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FactoryBackpack
implements IFactory {
    public static ContainerAdvanced getContainer(EntityPlayer player, boolean heldItem) {
        int col;
        int row;
        ItemStack backpack = BackpackHelper.getBackpackFromPlayer(player, heldItem);
        if (backpack.func_190926_b()) {
            return null;
        }
        IInventory backpackInventory = BackpackHelper.getInventory(player, heldItem);
        ContainerAdvanced container = new ContainerAdvanced(backpackInventory, player);
        int slotsPerRow = BackpackHelper.getSlotsPerRow(backpack);
        int inventoryRows = (int)Math.ceil((float)backpackInventory.func_70302_i_() / (float)slotsPerRow);
        int maxWidth = Math.max(9, slotsPerRow) * 18;
        container.setWidth(maxWidth + 16);
        int x = 8;
        int y = 17;
        container.addBoundary(Boundaries.BACKPACK);
        int remainingSlots = backpackInventory.func_70302_i_();
        for (row = 0; row < inventoryRows; ++row) {
            int cols = remainingSlots >= slotsPerRow ? slotsPerRow : remainingSlots;
            remainingSlots -= cols;
            if (cols * 18 < maxWidth) {
                x += (int)Math.round((double)maxWidth / 2.0 - (double)(cols * 18) / 2.0) + 1;
            }
            for (int col2 = 0; col2 < cols; ++col2) {
                container.addSlot(new SlotBackpack(backpackInventory, col2 + row * slotsPerRow, x, y));
                x += 18;
            }
            y += 18;
            x = 8;
        }
        container.addBoundary(Boundaries.BACKPACK_END);
        container.addBoundary(Boundaries.INVENTORY);
        y += 14;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                container.addSlot(new Slot((IInventory)player.field_71071_by, col + row * 9 + 9, x, y));
                x += 18;
            }
            y += 18;
            x = 8;
        }
        container.addBoundary(Boundaries.INVENTORY_END);
        container.addBoundary(Boundaries.HOTBAR);
        y += 6;
        for (col = 0; col < 9; ++col) {
            SlotMainHand slot = col == player.field_71071_by.field_70461_c ? new SlotMainHand((IInventory)player.field_71071_by, col, x, y) : new Slot((IInventory)player.field_71071_by, col, x, y);
            container.addSlot(slot);
            x += 18;
        }
        container.addBoundary(Boundaries.HOTBAR_END);
        y += 18;
        container.setHeight(y += 7);
        return container;
    }

    @SideOnly(value=Side.CLIENT)
    public static GuiContainer getGuiContainer(EntityPlayer player, boolean heldItem) {
        ItemStack backpack = BackpackHelper.getBackpackFromPlayer(player, heldItem);
        if (backpack.func_190926_b()) {
            return null;
        }
        ContainerAdvanced container = FactoryBackpack.getContainer(player, heldItem);
        GuiBackpack guiBackpack = new GuiBackpack(container);
        int slotsPerRow = BackpackHelper.getSlotsPerRow(backpack);
        int inventoryRows = (int)Math.ceil((float)container.getInventoryToSave().func_70302_i_() / (float)slotsPerRow);
        int textPositionY = 17 + inventoryRows * 18 + 2;
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            Slot slot = (Slot)container.field_75151_b.get(i);
            GuiSlot guiSlot = new GuiSlot(slot.field_75223_e - 1, slot.field_75221_f - 1);
            guiBackpack.addSubPart(guiSlot);
        }
        guiBackpack.addSubPart(new Label(8, 6, 0x404040, container.getInventoryToSave().func_70005_c_()));
        guiBackpack.addSubPart(new Label(8, textPositionY, 0x404040, "container.inventory"));
        return guiBackpack;
    }
}

