/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorState;
import forestry.api.core.ITileStructure;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.apiculture.gui.ContainerAlveary;
import forestry.apiculture.network.PacketActiveUpdate;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.interfaces.IActivatable;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TileAlvearyPlain
extends TileAlveary
implements ISidedInventory,
IBeeHousing,
IClimatised,
IHintSource,
IActivatable {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_PRODUCT_1 = 2;
    public static final int SLOT_PRODUCT_COUNT = 7;
    public static final int BLOCK_META = 0;
    protected IBeekeepingLogic beekeepingLogic;
    protected BiomeGenBase biome;
    protected float tempChange = 0.0f;
    protected float humidChange = 0.0f;
    private boolean active;
    private int displayHealthMax = 0;
    private int displayHealth = 0;
    private IBee displayQueen;
    private final Set<IBeeModifier> modifiers = new LinkedHashSet<IBeeModifier>();
    private final Set<IBeeListener> eventHandlers = new LinkedHashSet<IBeeListener>();

    public TileAlvearyPlain() {
        super(0);
    }

    @Override
    public void openGui(EntityPlayer player) {
        if (this.isMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.AlvearyGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (this.hasMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.AlvearyGUI.ordinal(), this.field_145850_b, this.masterX, this.masterY, this.masterZ);
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.setBiomeInformation();
    }

    private void setBiomeInformation() {
        this.biome = this.field_145850_b.getBiomeGenForCoordsBody(this.field_145851_c, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tempChange = nbttagcompound.func_74760_g("TempChange");
        this.humidChange = nbttagcompound.func_74760_g("HumidChange");
        if (this.beekeepingLogic != null) {
            this.beekeepingLogic.readFromNBT(nbttagcompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74776_a("TempChange", this.tempChange);
        nbttagcompound.func_74776_a("HumidChange", this.humidChange);
        if (this.beekeepingLogic != null) {
            this.beekeepingLogic.writeToNBT(nbttagcompound);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.active);
        if (this.active) {
            ItemStack queen = this.func_70301_a(0);
            data.writeItemStack(queen);
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.active = data.readBoolean();
        if (this.active) {
            ItemStack queen = data.readItemStack();
            this.func_70299_a(0, queen);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this));
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setBiomeInformation();
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.beekeepingLogic == null) {
            return;
        }
        if (!this.isMaster()) {
            return;
        }
        boolean canWork = this.beekeepingLogic.canWork();
        this.setActive(canWork);
        if (canWork) {
            this.beekeepingLogic.doWork();
        }
        this.equalizeTemperature();
        this.equalizeHumidity();
    }

    @Override
    protected void updateClientSide() {
        if (this.isMaster() && this.active && this.displayQueen != null && this.updateOnInterval(2)) {
            this.displayQueen.doFX(this.beekeepingLogic.getEffectData(), this);
            if (this.updateOnInterval(50)) {
                float fxX = (float)this.field_145851_c + 0.5f;
                float fxY = (float)this.field_145848_d + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 6.0f / 16.0f;
                float fxZ = (float)this.field_145849_e + 0.5f;
                float f3 = 1.6f;
                float f4 = this.field_145850_b.field_73012_v.nextFloat() * f3 - 0.5f;
                Proxies.common.addEntitySwarmFX(this.field_145850_b, fxX - f3, fxY, fxZ + f4, 0.0f, 0.0f, 0.0f);
                Proxies.common.addEntitySwarmFX(this.field_145850_b, fxX + f3, fxY, fxZ + f4, 0.0f, 0.0f, 0.0f);
                Proxies.common.addEntitySwarmFX(this.field_145850_b, fxX + f4, fxY, fxZ - f3, 0.0f, 0.0f, 0.0f);
                Proxies.common.addEntitySwarmFX(this.field_145850_b, fxX + f4, fxY, fxZ + f3, 0.0f, 0.0f, 0.0f);
            }
        }
    }

    private void equalizeTemperature() {
        if (this.tempChange == 0.0f) {
            return;
        }
        this.tempChange -= 0.05f * this.tempChange;
        if (this.tempChange <= 0.001f && this.tempChange >= -0.001f) {
            this.tempChange = 0.0f;
        }
    }

    private void equalizeHumidity() {
        if (this.humidChange == 0.0f) {
            return;
        }
        this.humidChange -= 0.05f * this.humidChange;
        if (this.humidChange <= 0.001f && this.humidChange >= 0.001f) {
            this.humidChange = 0.0f;
        }
    }

    private int getHealthDisplay() {
        if (this.displayQueen == null) {
            return 0;
        }
        if (this.displayQueen.getMate() != null) {
            return this.displayQueen.getHealth();
        }
        return this.displayHealth;
    }

    private int getMaxHealthDisplay() {
        if (this.displayQueen == null) {
            return 0;
        }
        if (this.displayQueen.getMate() != null) {
            return this.displayQueen.getMaxHealth();
        }
        return this.displayHealthMax;
    }

    public int getHealthScaled(int i) {
        if (this.getMaxHealthDisplay() == 0) {
            return 0;
        }
        return this.getHealthDisplay() * i / this.getMaxHealthDisplay();
    }

    @Override
    protected void createInventory() {
        this.setInternalInventory(new AlvearyInventoryAdapter(this));
    }

    @Override
    public void makeMaster() {
        super.makeMaster();
        if (this.beekeepingLogic == null) {
            this.beekeepingLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
        }
    }

    @Override
    public void onStructureReset() {
        super.onStructureReset();
        this.modifiers.clear();
        this.eventHandlers.clear();
        this.setActive(false);
    }

    @Override
    public void registerBeeModifier(IBeeModifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public void removeBeeModifier(IBeeModifier modifier) {
        this.modifiers.remove(modifier);
    }

    @Override
    public void registerBeeListener(IBeeListener modifier) {
        this.eventHandlers.add(modifier);
    }

    @Override
    public void removeBeeListener(IBeeListener modifier) {
        this.eventHandlers.remove(modifier);
    }

    @Override
    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
        float temperature = this.biome.func_150564_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.tempChange = Math.min(boundaryUp - temperature, Math.max(boundaryDown - temperature, this.tempChange + change));
    }

    @Override
    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
        float humidity = this.biome.field_76751_G;
        this.humidChange = Math.min(boundaryUp - humidity, Math.max(boundaryDown - humidity, this.humidChange + change));
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public ItemStack getQueen() {
        return this.func_70301_a(0);
    }

    @Override
    public ItemStack getDrone() {
        return this.func_70301_a(1);
    }

    @Override
    public void setQueen(ItemStack itemstack) {
        this.func_70299_a(0, itemstack);
    }

    @Override
    public ItemStack func_70298_a(int slotIndex, int amount) {
        ItemStack itemStack = super.func_70298_a(slotIndex, amount);
        if (slotIndex == 0) {
            this.handleQueenChange();
        }
        return itemStack;
    }

    @Override
    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        super.func_70299_a(slotIndex, itemStack);
        if (slotIndex == 0) {
            this.handleQueenChange();
        }
    }

    private void handleQueenChange() {
        TileAlvearyPlain master;
        if (!Proxies.common.isSimulating(this.field_145850_b) && (master = (TileAlvearyPlain)this.getCentralTE()) != null) {
            ItemStack itemStack = this.func_70301_a(0);
            master.displayQueen = BeeManager.beeRoot.getMember(itemStack);
        }
    }

    @Override
    public void setDrone(ItemStack itemstack) {
        this.func_70299_a(1, itemstack);
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.biome;
    }

    @Override
    public EnumTemperature getTemperature() {
        if (this.isHellish() && this.tempChange >= 0.0f) {
            return EnumTemperature.HELLISH;
        }
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        float mod = 2.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getTerritoryModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getProductionModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getMutationModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getLifespanModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getFloweringModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getGeneticDecay(genome, mod);
        }
        return mod;
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public boolean canBreed() {
        return true;
    }

    @Override
    public boolean addProduct(ItemStack product, boolean all) {
        IInventoryAdapter inventory = this.getStructureInventory();
        if (inventory == null) {
            return false;
        }
        return InvTools.tryAddStack((IInventory)inventory, product, 2, 7, all);
    }

    @Override
    @Deprecated
    public void setErrorState(IErrorState state) {
        this.removeErrorStates();
        if (state != EnumErrorCode.OK) {
            this.addErrorState(state);
        }
    }

    @Override
    public void wearOutEquipment(int amount) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.wearOutEquipment(amount);
        }
    }

    @Override
    public void onQueenChange(ItemStack queenStack) {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            return;
        }
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.onQueenChange(queenStack);
        }
    }

    @Override
    public void onQueenDeath(IBee queen) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.onQueenDeath(queen);
        }
    }

    @Override
    public void onPostQueenDeath(IBee queen) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.onPostQueenDeath(queen);
        }
    }

    @Override
    public boolean onPollenRetrieved(IBee queen, IIndividual pollen, boolean isHandled) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            if (!eventHandler.onPollenRetrieved(queen, pollen, isHandled)) continue;
            isHandled = true;
        }
        return isHandled;
    }

    @Override
    public boolean onEggLaid(IBee queen) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            if (!eventHandler.onEggLaid(queen)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSealed() {
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isSealed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isSelfLighted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isSunlightSimulated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHellish() {
        if (BiomeHelper.isBiomeHellish(this.biome)) {
            return true;
        }
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isHellish()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        ITileStructure central;
        IInventoryAdapter inventory = super.getInternalInventory();
        if (this.isMaster()) {
            return inventory;
        }
        if (this.hasMaster() && (central = this.getCentralTE()) instanceof TileAlveary) {
            return ((TileAlveary)central).getInternalInventory();
        }
        return inventory;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.displayHealth = j;
                break;
            }
            case 1: {
                this.displayHealthMax = j;
                break;
            }
            case 4: {
                this.tempChange = (float)j / 100.0f;
                break;
            }
            case 5: {
                this.humidChange = (float)j / 100.0f;
                break;
            }
            case 6: {
                this.biome = BiomeGenBase.func_150568_d((int)j);
            }
        }
    }

    public void sendGUINetworkData(ContainerAlveary container, ICrafting iCrafting) {
        if (this.beekeepingLogic == null) {
            return;
        }
        iCrafting.func_71112_a((Container)container, 0, this.beekeepingLogic.getBreedingTime());
        iCrafting.func_71112_a((Container)container, 1, this.beekeepingLogic.getTotalBreedingTime());
        iCrafting.func_71112_a((Container)container, 4, Math.round(this.tempChange * 100.0f));
        iCrafting.func_71112_a((Container)container, 5, Math.round(this.humidChange * 100.0f));
        iCrafting.func_71112_a((Container)container, 6, this.biome.field_76756_M);
    }

    @Override
    @Deprecated
    public IErrorState getErrorState() {
        ITileStructure tile;
        ImmutableSet<IErrorState> errorStates = null;
        if (this.hasMaster() && (tile = this.getCentralTE()) != null) {
            errorStates = ((IErrorSource)((Object)tile)).getErrorStates();
        }
        if (errorStates == null) {
            errorStates = this.getErrorStates();
        }
        if (errorStates.size() == 0) {
            return EnumErrorCode.OK;
        }
        return (IErrorState)this.getErrorStates().iterator().next();
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public float getExactTemperature() {
        return this.biome.func_150564_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) + this.tempChange;
    }

    @Override
    public float getExactHumidity() {
        return this.biome.field_76751_G + this.humidChange;
    }

    @Override
    public boolean hasHints() {
        return Config.hints.get("alveary").length > 0;
    }

    @Override
    public String[] getHints() {
        return Config.hints.get("alveary");
    }

    @Override
    public GameProfile getOwnerName() {
        return this.getOwner();
    }

    private static class AlvearyInventoryAdapter
    extends TileInventoryAdapter<TileAlvearyPlain> {
        public AlvearyInventoryAdapter(TileAlvearyPlain tileAlvearyPlain) {
            super(tileAlvearyPlain, 9, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return BeeManager.beeRoot.isMember(itemStack) && !BeeManager.beeRoot.isDrone(itemStack);
            }
            if (slotIndex == 1) {
                return BeeManager.beeRoot.isDrone(itemStack);
            }
            return false;
        }

        @Override
        public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex != 0 && slotIndex != 1;
        }
    }
}

