/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.core.genetics.alleles.AlleleCategorized;
import forestry.plugins.PluginApiculture;

public class AlleleEffectNone
extends AlleleCategorized
implements IAlleleBeeEffect {
    public AlleleEffectNone(String name) {
        super("forestry", "effect", name, true);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        return null;
    }

    @Override
    public boolean isCombinable() {
        return false;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        area[0] = (int)((float)area[0] * housing.getTerritoryModifier(genome, 1.0f));
        area[1] = (int)((float)area[1] * housing.getTerritoryModifier(genome, 1.0f));
        area[2] = (int)((float)area[2] * housing.getTerritoryModifier(genome, 1.0f));
        if (area[0] < 1) {
            area[0] = 1;
        }
        if (area[1] < 1) {
            area[1] = 1;
        }
        if (area[2] < 1) {
            area[2] = 1;
        }
        PluginApiculture.proxy.addBeeHiveFX("particles/swarm_bee", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimary().getIconColour(0), area[0], area[1], area[2]);
        return storedData;
    }
}

