/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.core.config.ForestryBlock;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public enum HiveDescription implements IHiveDescription
{
    FOREST(1, 3.0f, BeeDefinition.FOREST, HiveManager.genHelper.tree()),
    MEADOWS(2, 1.0f, BeeDefinition.MEADOWS, HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c})),
    DESERT(3, 1.0f, BeeDefinition.MODEST, HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150354_m, Blocks.field_150322_A})),
    JUNGLE(4, 4.0f, BeeDefinition.TROPICAL, HiveManager.genHelper.tree()),
    END(5, 4.0f, BeeDefinition.ENDED, HiveManager.genHelper.ground(Blocks.field_150377_bs)){

        @Override
        public boolean isGoodBiome(BiomeGenBase biome) {
            return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END);
        }
    }
    ,
    SNOW(6, 2.0f, BeeDefinition.WINTRY, HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150433_aE})){

        @Override
        public void postGen(World world, int x, int y, int z) {
            if (world.func_147437_c(x, y + 1, z)) {
                world.func_147465_d(x, y + 1, z, Blocks.field_150431_aC, 0, 0);
            }
        }
    }
    ,
    SWAMP(7, 2.0f, BeeDefinition.MARSHY, HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c}));

    private final int meta;
    private final float genChance;
    private final IBeeGenome beeGenome;
    private final IHiveGen hiveGen;

    private HiveDescription(int meta, float genChance, BeeDefinition beeTemplate, IHiveGen hiveGen) {
        this.meta = meta;
        this.genChance = genChance;
        this.beeGenome = beeTemplate.getGenome();
        this.hiveGen = hiveGen;
    }

    @Override
    public IHiveGen getHiveGen() {
        return this.hiveGen;
    }

    @Override
    public Block getBlock() {
        return ForestryBlock.beehives.block();
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    @Override
    public boolean isGoodBiome(BiomeGenBase biome) {
        return !BiomeHelper.isBiomeHellish(biome);
    }

    @Override
    public boolean isGoodHumidity(EnumHumidity humidity) {
        EnumHumidity idealHumidity = this.beeGenome.getPrimary().getHumidity();
        EnumTolerance humidityTolerance = this.beeGenome.getToleranceHumid();
        return AlleleManager.climateHelper.isWithinLimits(humidity, idealHumidity, humidityTolerance);
    }

    @Override
    public boolean isGoodTemperature(EnumTemperature temperature) {
        EnumTemperature idealTemperature = this.beeGenome.getPrimary().getTemperature();
        EnumTolerance temperatureTolerance = this.beeGenome.getToleranceTemp();
        return AlleleManager.climateHelper.isWithinLimits(temperature, idealTemperature, temperatureTolerance);
    }

    @Override
    public float getGenChance() {
        return this.genChance;
    }

    @Override
    public void postGen(World world, int x, int y, int z) {
    }
}

