/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.gadgets.BlockFireproofLog;
import forestry.arboriculture.gadgets.BlockLog;
import forestry.arboriculture.worldgen.BlockTypeLeaf;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.core.config.ForestryBlock;
import forestry.core.utils.StackUtils;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;
import forestry.plugins.PluginArboriculture;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public abstract class WorldGenTree
extends WorldGenArboriculture {
    protected int girth;
    protected int height;
    protected int minHeight = 4;
    protected int maxHeight = 80;

    public WorldGenTree(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(leafSpawn--, 0.0f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(leafSpawn--, 0.5f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(leafSpawn--, 1.9f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(leafSpawn--, 1.9f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
    }

    protected WorldGenBase.Vector getCenteredAt(int yCenter, int offset) {
        float cent = this.girth % 2 == 0 ? 0.5f : 0.0f;
        return new WorldGenBase.Vector(cent + (float)offset, yCenter, cent + (float)offset);
    }

    protected void generateAdjustedCylinder(int yCenter, float radius, int height, BlockType block) {
        this.generateAdjustedCylinder(yCenter, 0, radius, height, block, WorldGenBase.EnumReplaceMode.NONE);
    }

    protected void generateAdjustedCylinder(int yCenter, float radius, int height, BlockType block, WorldGenBase.EnumReplaceMode replace) {
        this.generateAdjustedCylinder(yCenter, 0, radius, height, block, replace);
    }

    protected void generateAdjustedCylinder(int yCenter, int offset, float radius, int height, BlockType block, WorldGenBase.EnumReplaceMode replace) {
        this.generateCylinder(this.getCenteredAt(yCenter, offset), radius + (float)this.girth, height, block, replace);
    }

    @Override
    public boolean canGrow() {
        return this.tree.canGrow(this.world, this.startX, this.startY, this.startZ, this.tree.getGirth(this.world, this.startX, this.startY, this.startZ), this.height);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(5, 2);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    protected int determineGirth(int base) {
        return base;
    }

    protected int modifyByHeight(int val, int min, int max) {
        int determined = Math.round((float)val * this.tree.getHeightModifier() * PluginArboriculture.treeInterface.getTreekeepingMode(this.world).getHeightModifier(null, 1.0f));
        return determined < min ? min : (determined > max ? max : determined);
    }

    protected int determineHeight(int required, int variation) {
        int determined = Math.round((float)(required + this.rand.nextInt(variation)) * this.tree.getHeightModifier() * PluginArboriculture.treeInterface.getTreekeepingMode(this.world).getHeightModifier(null, 1.0f));
        return determined < this.minHeight ? this.minHeight : (determined > this.maxHeight ? this.maxHeight : determined);
    }

    @Override
    public BlockType getLeaf(GameProfile owner) {
        return new BlockTypeLeaf(owner);
    }

    @Override
    public BlockType getWood() {
        IAlleleBoolean fireproof;
        ItemStack woodStack = this.tree.getGenome().getPrimary().getLogStacks()[0];
        Block block = StackUtils.getBlock(woodStack);
        int meta = woodStack.func_77960_j();
        if (block instanceof BlockLog && (fireproof = (IAlleleBoolean)this.tree.getGenome().getActiveAllele(EnumTreeChromosome.FIREPROOF)).getValue()) {
            BlockLog blockLog = (BlockLog)block;
            ForestryBlock fireproofLogBlock = BlockFireproofLog.getFireproofLog(blockLog);
            return new BlockType(fireproofLogBlock.block(), meta);
        }
        return new BlockType(block, meta);
    }
}

