/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.fluids.FluidHelper;
import forestry.core.gadgets.BlockForestry;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IOwnable;
import forestry.core.items.ItemNBTTile;
import forestry.core.proxy.Proxies;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockBase
extends BlockForestry {
    private final List<MachineDefinition> definitions = new ArrayList<MachineDefinition>();
    private final boolean hasTESR;

    public BlockBase(Material material) {
        this(material, false);
    }

    public BlockBase(Material material, boolean hasTESR) {
        super(material);
        this.hasTESR = hasTESR;
    }

    public MachineDefinition addDefinition(MachineDefinition definition) {
        definition.setBlock((Block)this);
        while (this.definitions.size() <= definition.meta) {
            this.definitions.add(null);
        }
        this.definitions.set(definition.meta, definition);
        return definition;
    }

    public boolean func_149662_c() {
        return !this.hasTESR;
    }

    public boolean func_149686_d() {
        return !this.hasTESR;
    }

    public int func_149645_b() {
        if (this.hasTESR) {
            return Proxies.common.getByBlockModelId();
        }
        return 0;
    }

    private MachineDefinition getDefinition(IBlockAccess world, int x, int y, int z) {
        return this.getDefinition(world.func_72805_g(x, y, z));
    }

    private MachineDefinition getDefinition(int metadata) {
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            return this.definitions.get(0);
        }
        return this.definitions.get(metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (MachineDefinition definition : this.definitions) {
            if (definition == null) continue;
            definition.getSubBlocks(item, tab, list);
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        MachineDefinition definition;
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            metadata = 0;
        }
        if ((definition = this.definitions.get(metadata)) == null) {
            return null;
        }
        return definition.createMachine();
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.createTileEntity(world, meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (this.getDefinition(metadata).handlesDrops()) {
            return this.getDefinition(metadata).getDrops(world, x, y, z, metadata, fortune);
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        MachineDefinition definition = this.getDefinition(world, x, y, z);
        return definition != null && definition.isSolidOnSide(world, x, y, z, side.ordinal());
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entityliving, stack);
        TileForestry tile = (TileForestry)world.func_147438_o(x, y, z);
        if (stack.func_77973_b() instanceof ItemNBTTile && stack.func_77942_o()) {
            tile.func_145839_a(stack.func_77978_p());
            tile.field_145851_c = x;
            tile.field_145848_d = y;
            tile.field_145849_e = z;
        }
        tile.rotateAfterPlacement(world, x, y, z, entityliving, stack);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        if (this.getDefinition((IBlockAccess)world, x, y, z).onBlockActivated(world, x, y, z, player, side, par7, par8, par9)) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        TileBase tile = (TileBase)world.func_147438_o(x, y, z);
        if (!Utils.isUseableByPlayer(player, tile)) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() != Items.field_151133_ar && tile instanceof IFluidHandler && tile.allowsAlteration(player) && FluidHelper.handleRightClick((IFluidHandler)tile, ForgeDirection.getOrientation((int)side), player, true, tile.canDrainWithBucket())) {
            return true;
        }
        if (!Proxies.common.isSimulating(world)) {
            return true;
        }
        if (tile.allowsViewing(player)) {
            tile.openGui(player, tile);
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("for.chat.accesslocked", new Object[]{PlayerUtil.getOwnerName(tile)}));
        }
        return true;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        return this.getDefinition((IBlockAccess)world, x, y, z).rotateBlock(world, x, y, z, axis);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.getDefinition((IBlockAccess)world, x, y, z).onBlockAdded(world, x, y, z);
    }

    @Override
    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        IOwnable tile = (IOwnable)world.func_147438_o(x, y, z);
        if (tile == null) {
            return world.func_147468_f(x, y, z);
        }
        if (tile.isOwned() && !tile.allowsRemoval(player)) {
            return false;
        }
        if (this.getDefinition((IBlockAccess)world, x, y, z).removedByPlayer(world, player, x, y, z)) {
            return world.func_147468_f(x, y, z);
        }
        return false;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            metadata = 0;
        }
        return this.definitions.get(metadata).canConnectRedstone(world, x, y, z, side);
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (MachineDefinition def : this.definitions) {
            if (def == null) continue;
            def.registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            return null;
        }
        return this.definitions.get(metadata).getBlockTextureFromSideAndMetadata(side, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            metadata = 0;
        }
        return this.definitions.get(metadata).getIcon(world, x, y, z, side, metadata);
    }

    public boolean func_149710_n() {
        return this.hasTESR;
    }
}

