/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.network.PacketId;
import forestry.core.network.PacketNBT;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;

public abstract class BreedingTracker
extends WorldSavedData
implements IBreedingTracker {
    private List<String> discoveredSpecies = new ArrayList<String>();
    private List<String> discoveredMutations = new ArrayList<String>();
    private String modeName;
    private final GameProfile username;
    private static final String MUTATION_FORMAT = "%s-%s=%s";

    public BreedingTracker(String s, GameProfile username) {
        super(s);
        this.username = username;
    }

    @Override
    public String getModeName() {
        return this.modeName;
    }

    @Override
    public void setModeName(String name) {
        this.modeName = name;
        this.func_76185_a();
    }

    protected abstract IBreedingTracker getBreedingTracker(EntityPlayer var1);

    protected abstract String speciesRootUID();

    @Override
    public void synchToPlayer(EntityPlayer player) {
        IBreedingTracker breedingTracker = this.getBreedingTracker(player);
        String modeName = breedingTracker.getModeName();
        this.setModeName(modeName);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.encodeToNBT(nbttagcompound);
        Proxies.net.sendToPlayer(new PacketNBT(PacketId.GENOME_TRACKER_UPDATE, nbttagcompound), player);
    }

    @Override
    public void decodeFromNBT(NBTTagCompound nbttagcompound) {
        this.func_76184_a(nbttagcompound);
    }

    @Override
    public void encodeToNBT(NBTTagCompound nbttagcompound) {
        this.func_76187_b(nbttagcompound);
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        int i;
        if (nbttagcompound.func_74764_b("BMS")) {
            this.modeName = nbttagcompound.func_74779_i("BMS");
        }
        this.discoveredSpecies = new ArrayList<String>();
        int count = nbttagcompound.func_74762_e("SpeciesCount");
        for (i = 0; i < count; ++i) {
            this.discoveredSpecies.add(nbttagcompound.func_74779_i("SD" + i));
        }
        this.discoveredMutations = new ArrayList<String>();
        count = nbttagcompound.func_74762_e("MutationsCount");
        for (i = 0; i < count; ++i) {
            this.discoveredMutations.add(nbttagcompound.func_74779_i("MD" + i));
        }
    }

    public void func_76187_b(NBTTagCompound nbttagcompound) {
        int i;
        if (this.modeName != null && !this.modeName.isEmpty()) {
            nbttagcompound.func_74778_a("BMS", this.modeName);
        }
        nbttagcompound.func_74778_a("TYPE", this.speciesRootUID());
        nbttagcompound.func_74768_a("SpeciesCount", this.discoveredSpecies.size());
        for (i = 0; i < this.discoveredSpecies.size(); ++i) {
            if (this.discoveredSpecies.get(i) == null) continue;
            nbttagcompound.func_74778_a("SD" + i, this.discoveredSpecies.get(i));
        }
        nbttagcompound.func_74768_a("MutationsCount", this.discoveredMutations.size());
        for (i = 0; i < this.discoveredMutations.size(); ++i) {
            if (this.discoveredMutations.get(i) == null) continue;
            nbttagcompound.func_74778_a("MD" + i, this.discoveredMutations.get(i));
        }
    }

    private static String getMutationString(IMutation mutation) {
        String species0 = mutation.getAllele0().getUID();
        String species1 = mutation.getAllele1().getUID();
        String resultSpecies = mutation.getTemplate()[0].getUID();
        return String.format(MUTATION_FORMAT, species0, species1, resultSpecies);
    }

    @Override
    public void registerMutation(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        this.discoveredMutations.add(mutationString);
        this.func_76185_a();
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.speciesRootUID());
        ForestryEvent.MutationDiscovered event = new ForestryEvent.MutationDiscovered(speciesRoot, this.username, mutation, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public boolean isDiscovered(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        return this.discoveredMutations.contains(mutationString);
    }

    @Override
    public boolean isDiscovered(IAlleleSpecies species) {
        return this.discoveredSpecies.contains(species.getUID());
    }

    @Override
    public int getSpeciesBred() {
        return this.discoveredSpecies.size();
    }

    @Override
    public void registerBirth(IIndividual individual) {
        this.registerSpecies(individual.getGenome().getPrimary());
        this.registerSpecies(individual.getGenome().getSecondary());
    }

    @Override
    public void registerSpecies(IAlleleSpecies species) {
        if (!this.discoveredSpecies.contains(species.getUID())) {
            this.discoveredSpecies.add(species.getUID());
            ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.speciesRootUID());
            ForestryEvent.SpeciesDiscovered event = new ForestryEvent.SpeciesDiscovered(speciesRoot, this.username, species, this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }
}

