/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.Chromosome;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;

public abstract class SpeciesRoot
implements ISpeciesRoot {
    private final LinkedHashMap<ItemStack, Float> researchCatalysts = new LinkedHashMap();
    public final HashMap<String, IAllele[]> speciesTemplates = new HashMap();

    @Override
    public Map<ItemStack, Float> getResearchCatalysts() {
        return Collections.unmodifiableMap(this.researchCatalysts);
    }

    @Override
    public void setResearchSuitability(ItemStack itemstack, float suitability) {
        this.researchCatalysts.put(itemstack, Float.valueOf(suitability));
    }

    @Override
    public Map<String, IAllele[]> getGenomeTemplates() {
        return this.speciesTemplates;
    }

    @Override
    public void registerTemplate(IAllele[] template) {
        this.registerTemplate(template[0].getUID(), template);
    }

    @Override
    public IAllele[] getRandomTemplate(Random rand) {
        return ((IAllele[][])this.speciesTemplates.values().toArray((T[])new IAllele[0][]))[rand.nextInt(this.speciesTemplates.values().size())];
    }

    @Override
    public IAllele[] getTemplate(String identifier) {
        IAllele[] template = this.speciesTemplates.get(identifier);
        if (template == null) {
            return null;
        }
        return Arrays.copyOf(template, template.length);
    }

    @Override
    public Collection<? extends IMutation> getCombinations(IAllele other) {
        ArrayList<IMutation> combinations = new ArrayList<IMutation>();
        for (IMutation iMutation : this.getMutations(false)) {
            if (!iMutation.isPartner(other)) continue;
            combinations.add(iMutation);
        }
        return combinations;
    }

    @Override
    public Collection<? extends IMutation> getPaths(IAllele result, IChromosomeType chromosomeType) {
        ArrayList<IMutation> paths = new ArrayList<IMutation>();
        for (IMutation iMutation : this.getMutations(false)) {
            if (iMutation.getTemplate()[chromosomeType.ordinal()] != result) continue;
            paths.add(iMutation);
        }
        return paths;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] template) {
        IChromosome[] chromosomes = new Chromosome[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) continue;
            chromosomes[i] = new Chromosome(template[i]);
        }
        return chromosomes;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] templateActive, IAllele[] templateInactive) {
        IChromosome[] chromosomes = new Chromosome[templateActive.length];
        for (int i = 0; i < templateActive.length; ++i) {
            if (templateActive[i] == null) continue;
            chromosomes[i] = new Chromosome(templateActive[i], templateInactive[i]);
        }
        return chromosomes;
    }
}

