/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.AllelePlantType;
import java.util.EnumSet;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.EnumPlantType;

public abstract class Allele
implements IAllele {
    protected final String uid;
    protected final boolean isDominant;
    protected final String unlocalizedName;
    public static AlleleHelper helper;
    public static IAlleleTreeSpecies treeOak;
    public static IAlleleTreeSpecies treeBirch;
    public static IAlleleTreeSpecies treeSpruce;
    public static IAlleleTreeSpecies treePine;
    public static IAlleleTreeSpecies treeJungle;
    public static IAlleleTreeSpecies treeAcacia;
    public static IAlleleTreeSpecies treeDarkOak;
    public static IAlleleTreeSpecies treeLarch;
    public static IAlleleTreeSpecies treeTeak;
    public static IAlleleTreeSpecies treeDesertAcacia;
    public static IAlleleTreeSpecies treeLime;
    public static IAlleleTreeSpecies treeChestnut;
    public static IAlleleTreeSpecies treeWenge;
    public static IAlleleTreeSpecies treeBaobab;
    public static IAlleleTreeSpecies treeSequioa;
    public static IAlleleTreeSpecies treeGiganteum;
    public static IAlleleTreeSpecies treeKapok;
    public static IAlleleTreeSpecies treeEbony;
    public static IAlleleTreeSpecies treeMahogany;
    public static IAlleleTreeSpecies treeBalsa;
    public static IAlleleTreeSpecies treePapaya;
    public static IAlleleTreeSpecies treeWalnut;
    public static IAlleleTreeSpecies treeDate;
    public static IAlleleTreeSpecies treeCherry;
    public static IAlleleTreeSpecies treeWillow;
    public static IAlleleTreeSpecies treeSipiri;
    public static IAlleleTreeSpecies treeMahoe;
    public static IAlleleTreeSpecies treePoplar;
    public static IAlleleTreeSpecies treeLemon;
    public static IAlleleTreeSpecies treePlum;
    public static IAlleleTreeSpecies treeMaple;
    public static IAlleleTreeSpecies treeIpe;
    public static IAlleleTreeSpecies treePadauk;
    public static IAlleleTreeSpecies treeCocobolo;
    public static IAlleleTreeSpecies treeZebrawood;
    public static IAlleleButterflySpecies mothBrimstone;
    public static IAlleleButterflySpecies mothLatticedHeath;
    public static IAlleleButterflySpecies mothAtlas;
    public static IAlleleButterflySpecies lepiCabbageWhite;
    public static IAlleleButterflySpecies lepiGlasswing;
    public static IAlleleButterflySpecies lepiEmeraldPeacock;
    public static IAlleleButterflySpecies lepiThoasSwallow;
    public static IAlleleButterflySpecies lepiCitrusSwallow;
    public static IAlleleButterflySpecies lepiZebraSwallow;
    public static IAlleleButterflySpecies lepiBlackSwallow;
    public static IAlleleButterflySpecies lepiDianaFrit;
    public static IAlleleButterflySpecies lepiSpeckledWood;
    public static IAlleleButterflySpecies lepiMadeiranSpeckledWood;
    public static IAlleleButterflySpecies lepiCanarySpeckledWood;
    public static IAlleleButterflySpecies lepiMenelausBlueMorpho;
    public static IAlleleButterflySpecies lepiPeleidesBlueMorpho;
    public static IAlleleButterflySpecies lepiRhetenorBlueMorpho;
    public static IAlleleButterflySpecies lepiBrimstone;
    public static IAlleleButterflySpecies lepiAurora;
    public static IAlleleButterflySpecies lepiPostillion;
    public static IAlleleButterflySpecies lepiPalaenoSulphur;
    public static IAlleleButterflySpecies lepiReseda;
    public static IAlleleButterflySpecies lepiSpringAzure;
    public static IAlleleButterflySpecies lepiGozoraAzure;
    public static IAlleleButterflySpecies lepiComma;
    public static IAlleleButterflySpecies lepiBatesia;
    public static IAlleleButterflySpecies lepiBlueWing;
    public static IAlleleButterflySpecies lepiMonarch;
    public static IAlleleButterflySpecies lepiBlueDuke;
    public static IAlleleButterflySpecies lepiGlassyTiger;
    public static IAlleleButterflySpecies lepiPostman;
    public static IAlleleButterflySpecies lepiSpicebush;
    public static IAlleleButterflySpecies lepiMalachite;
    public static IAlleleButterflySpecies lepiLLacewing;
    public static IAlleleGrowth growthLightlevel;
    public static IAlleleGrowth growthAcacia;
    public static IAlleleGrowth growthTropical;
    public static IAlleleFruit fruitNone;
    public static IAlleleFruit fruitApple;
    public static IAlleleFruit fruitCocoa;
    public static IAlleleFruit fruitChestnut;
    public static IAlleleFruit fruitCoconut;
    public static IAlleleFruit fruitWalnut;
    public static IAlleleFruit fruitCherry;
    public static IAlleleFruit fruitDates;
    public static IAlleleFruit fruitPapaya;
    public static IAlleleFruit fruitLemon;
    public static IAlleleFruit fruitPlum;
    public static IAlleleFruit fruitJujube;
    public static Allele effectNone;
    public static Allele effectAggressive;
    public static Allele effectHeroic;
    public static Allele effectBeatific;
    public static Allele effectMiasmic;
    public static Allele effectMisanthrope;
    public static Allele effectGlacial;
    public static Allele effectRadioactive;
    public static Allele effectCreeper;
    public static Allele effectIgnition;
    public static Allele effectExploration;
    public static Allele effectFestiveEaster;
    public static Allele effectSnowing;
    public static Allele effectDrunkard;
    public static Allele effectReanimation;
    public static Allele effectResurrection;
    public static Allele effectRepulsion;
    public static Allele effectFertile;
    public static Allele effectMycophilic;
    public static Allele leavesNone;
    public static Allele butterflyNone;
    public static final Allele plantTypeNone;
    public static final Allele plantTypePlains;
    public static final Allele plantTypeDesert;
    public static final Allele plantTypeBeach;
    public static final Allele plantTypeCave;
    public static final Allele plantTypeWater;
    public static final Allele plantTypeNether;
    public static final Allele plantTypeCrop;

    protected Allele(String uid, String unlocalizedName, boolean isDominant) {
        this(uid, unlocalizedName, isDominant, true);
    }

    protected Allele(String uid, String unlocalizedName, boolean isDominant, boolean doRegister) {
        this.uid = uid;
        this.isDominant = isDominant;
        this.unlocalizedName = unlocalizedName;
        if (doRegister) {
            AlleleManager.alleleRegistry.registerAllele(this);
        }
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public boolean isDominant() {
        return this.isDominant;
    }

    @Override
    public String getName() {
        return StatCollector.func_74838_a((String)this.getUnlocalizedName());
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String toString() {
        return this.uid;
    }

    static {
        plantTypeNone = new AllelePlantType("none", EnumSet.noneOf(EnumPlantType.class), true);
        plantTypePlains = new AllelePlantType(EnumPlantType.Plains);
        plantTypeDesert = new AllelePlantType(EnumPlantType.Desert);
        plantTypeBeach = new AllelePlantType(EnumPlantType.Beach);
        plantTypeCave = new AllelePlantType(EnumPlantType.Cave);
        plantTypeWater = new AllelePlantType(EnumPlantType.Water);
        plantTypeNether = new AllelePlantType(EnumPlantType.Nether);
        plantTypeCrop = new AllelePlantType(EnumPlantType.Crop);
    }
}

