/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.IErrorState;
import forestry.core.config.SessionVars;
import forestry.core.gui.ErrorLedger;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Ledger;
import forestry.core.interfaces.IErrorSource;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class LedgerManager {
    public final GuiForestry gui;
    public final Minecraft minecraft;
    @Nullable
    public IErrorSource errorSource;
    protected final List<Ledger> ledgers = new ArrayList<Ledger>();
    protected final List<ErrorLedger> errorLedgers = new ArrayList<ErrorLedger>();

    public LedgerManager(GuiForestry gui) {
        this.gui = gui;
        this.minecraft = Proxies.common.getClientInstance();
    }

    public void add(IErrorSource errorSource) {
        this.errorSource = errorSource;
        int maxErrorLedgerCount = (this.gui.getSizeY() - 10) / 24;
        for (int i = 0; i < maxErrorLedgerCount; ++i) {
            this.errorLedgers.add(new ErrorLedger(this));
        }
    }

    public void add(Ledger ledger) {
        this.ledgers.add(ledger);
        if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
            ledger.setFullyOpen();
        }
    }

    public void insert(Ledger ledger) {
        this.ledgers.add(this.ledgers.size() - 1, ledger);
    }

    protected Ledger getAtPosition(int mX, int mY) {
        if (this.ledgers.size() > 0) {
            int xShift = (this.gui.field_146294_l - this.gui.getSizeX()) / 2 + this.gui.getSizeX();
            int yShift = (this.gui.field_146295_m - this.gui.getSizeY()) / 2 + 8;
            for (Ledger ledger : this.ledgers) {
                if (!ledger.isVisible()) continue;
                ledger.currentShiftX = xShift;
                ledger.currentShiftY = yShift;
                if (ledger.intersectsWith(mX, mY)) {
                    return ledger;
                }
                yShift += ledger.getHeight();
            }
        }
        if (this.errorSource != null) {
            int xShiftError = (this.gui.field_146294_l - this.gui.getSizeX()) / 2;
            int yShiftError = (this.gui.field_146295_m - this.gui.getSizeY()) / 2 + 8;
            for (ErrorLedger errorLedger : this.errorLedgers) {
                if (!errorLedger.isVisible()) continue;
                errorLedger.currentShiftX = xShiftError - errorLedger.getWidth();
                errorLedger.currentShiftY = yShiftError;
                if (errorLedger.intersectsWith(mX, mY)) {
                    return errorLedger;
                }
                yShiftError += errorLedger.getHeight();
            }
        }
        return null;
    }

    protected void drawLedgers() {
        int yPos = 8;
        for (Ledger ledger : this.ledgers) {
            ledger.update();
            if (!ledger.isVisible()) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ledger.draw(this.gui.getSizeX(), yPos);
            yPos += ledger.getHeight();
        }
        if (this.errorSource != null) {
            yPos = 8;
            int index = 0;
            for (IErrorState errorState : this.errorSource.getErrorStates()) {
                if (index >= this.errorLedgers.size()) break;
                ErrorLedger errorLedger = this.errorLedgers.get(index++);
                errorLedger.setState(errorState);
                errorLedger.update();
                if (!errorLedger.isVisible()) continue;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                errorLedger.draw(-errorLedger.getWidth(), yPos);
                yPos += errorLedger.getHeight();
            }
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
        Ledger ledger = this.getAtPosition(mouseX, mouseY);
        if (ledger != null) {
            int startX = mouseX - (this.gui.field_146294_l - this.gui.getSizeX()) / 2 + 12;
            int startY = mouseY - (this.gui.field_146295_m - this.gui.getSizeY()) / 2 - 12;
            String tooltip = ledger.getTooltip();
            int textWidth = this.minecraft.field_71466_p.func_78256_a(tooltip);
            this.gui.func_73733_a(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
            this.minecraft.field_71466_p.func_78261_a(tooltip, startX, startY, -1);
        }
    }

    public void handleMouseClicked(int x, int y, int mouseButton) {
        Ledger ledger;
        if (mouseButton == 0 && (ledger = this.getAtPosition(x, y)) != null && !ledger.handleMouseClicked(x, y, mouseButton)) {
            List<Ledger> toggleLedgers = this.ledgers.contains(ledger) ? this.ledgers : this.errorLedgers;
            for (Ledger other : toggleLedgers) {
                if (other == ledger || !other.isOpen()) continue;
                other.toggleOpen();
            }
            ledger.toggleOpen();
        }
    }

    public boolean ledgerOverlaps(int x, int y, int width, int height) {
        return this.getAtPosition(x + width, y + height) != null || this.getAtPosition(x + width, y) != null || this.getAtPosition(x, y + height) != null || this.getAtPosition(x, y) != null;
    }
}

