/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import forestry.core.proxy.Proxies;
import forestry.factory.gadgets.TileWorktable;
import forestry.factory.recipes.RecipeMemory;
import java.io.IOException;
import net.minecraft.tileentity.TileEntity;

public class PacketWorktableMemoryUpdate
extends PacketCoordinates {
    private RecipeMemory recipeMemory;

    public static void onPacketData(DataInputStreamForestry data) throws IOException {
        new PacketWorktableMemoryUpdate(data);
    }

    private PacketWorktableMemoryUpdate(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketWorktableMemoryUpdate(TileWorktable worktable) {
        super(PacketId.WORKTABLE_MEMORY_UPDATE, worktable);
        this.recipeMemory = worktable.getMemory();
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.recipeMemory.writeData(data);
    }

    @Override
    protected void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof TileWorktable) {
            ((TileWorktable)tile).getMemory().readData(data);
        }
    }
}

