/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.core.vect.IVect;
import forestry.core.vect.Vect;
import forestry.core.vect.VectUtil;
import forestry.farming.logic.FarmLogicWatered;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class FarmLogicCrops
extends FarmLogicWatered {
    private final Iterable<IFarmable> seeds;
    private static final ItemStack farmland = new ItemStack(Blocks.field_150458_ak, 1, Short.MAX_VALUE);

    public FarmLogicCrops(IFarmHousing housing, Iterable<IFarmable> seeds) {
        super(housing, new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150458_ak));
        this.seeds = seeds;
    }

    @Override
    public boolean isAcceptedGround(ItemStack itemStack) {
        return super.isAcceptedGround(itemStack) || StackUtils.isIdenticalItem(farmland, itemStack);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        ArrayList products = this.produce;
        this.produce = new ArrayList();
        Vect coords = new Vect(this.housing.getCoords());
        Vect area = new Vect(this.housing.getArea());
        Vect offset = new Vect(this.housing.getOffset());
        Vect min = coords.add(offset);
        Vect max = min.add(area);
        AxisAlignedBB harvestBox = AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = this.housing.getWorld().func_72872_a(Entity.class, harvestBox);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack contained;
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityItem)) continue;
            EntityItem item = (EntityItem)entity;
            if (item.field_70128_L || !this.isAcceptedGermling(contained = item.func_92059_d()) && !this.isWindfall(contained)) continue;
            this.produce.add(contained.func_77946_l());
            item.func_70106_y();
        }
        return products;
    }

    @Override
    protected boolean maintainCrops(int x, int y, int z, ForgeDirection direction, int extent) {
        World world = this.getWorld();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!VectUtil.isAirBlock(world, position) && !Utils.isReplaceableBlock(this.getWorld(), position.x, position.y, position.z)) continue;
            ItemStack below = VectUtil.getAsItemStack(world, position.add(0, -1, 0));
            if (this.ground.func_77973_b() != below.func_77973_b() || below.func_77960_j() <= 0) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(IVect position) {
        World world = this.getWorld();
        for (IFarmable candidate : this.seeds) {
            if (!this.housing.plantGermling(candidate, world, position.getX(), position.getY(), position.getZ())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y + 1, z, direction, i);
            for (IFarmable seed : this.seeds) {
                ICrop crop = seed.getCropAt(world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

