/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.api.genetics.IFruitBearer;
import forestry.core.config.ForestryItem;
import forestry.core.vect.Vect;
import forestry.core.vect.VectUtil;
import forestry.farming.logic.CropFruit;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FarmLogicOrchard
extends FarmLogic {
    private final Collection<IFarmable> farmables;
    private final HashMap<Vect, Integer> lastExtents = new HashMap();

    public FarmLogicOrchard(IFarmHousing housing) {
        super(housing);
        this.farmables = Farmables.farmables.get("farmOrchard");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return ForestryItem.fruits.item().func_77617_a(0);
    }

    @Override
    public String getName() {
        return "Orchard";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(40.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x, int y, int z, ForgeDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        int lastExtent;
        Vect start = new Vect(x, y, z);
        if (!this.lastExtents.containsKey(start)) {
            this.lastExtents.put(start, 0);
        }
        if ((lastExtent = this.lastExtents.get(start).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x, y + 1, z, direction, lastExtent);
        Collection<ICrop> crops = this.getHarvestBlocks(position);
        this.lastExtents.put(start, ++lastExtent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(Vect position) {
        HashSet<Vect> seen = new HashSet<Vect>();
        Stack<ICrop> crops = new Stack<ICrop>();
        World world = this.getWorld();
        if (!VectUtil.isWoodBlock(world, position) && !this.isFruitBearer(world, position)) {
            return crops;
        }
        List<Vect> candidates = this.processHarvestBlock(crops, seen, position, position);
        ArrayList<Vect> temp = new ArrayList<Vect>();
        while (!candidates.isEmpty() && crops.size() < 20) {
            for (Vect candidate : candidates) {
                temp.addAll(this.processHarvestBlock(crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private List<Vect> processHarvestBlock(Stack<ICrop> crops, Set<Vect> seen, Vect start, Vect position) {
        World world = this.getWorld();
        ArrayList<Vect> candidates = new ArrayList<Vect>();
        for (int i = -2; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    Vect candidate = new Vect(position.x + i, position.y + j, position.z + k);
                    if (Math.abs(candidate.x - start.x) > 5 || Math.abs(candidate.z - start.z) > 5 || seen.contains(candidate)) continue;
                    if (VectUtil.isWoodBlock(world, candidate)) {
                        candidates.add(candidate);
                        seen.add(candidate);
                        continue;
                    }
                    if (!this.isFruitBearer(world, candidate)) continue;
                    candidates.add(candidate);
                    seen.add(candidate);
                    ICrop crop = this.getCrop(world, candidate);
                    if (crop == null) continue;
                    crops.push(crop);
                }
            }
        }
        return candidates;
    }

    private boolean isFruitBearer(World world, Vect position) {
        if (VectUtil.isAirBlock(world, position)) {
            return false;
        }
        TileEntity tile = world.func_147438_o(position.x, position.y, position.z);
        if (tile instanceof IFruitBearer) {
            return true;
        }
        for (IFarmable farmable : this.farmables) {
            if (!farmable.isSaplingAt(world, position.x, position.y, position.z)) continue;
            return true;
        }
        return false;
    }

    private ICrop getCrop(World world, Vect position) {
        if (VectUtil.isAirBlock(world, position)) {
            return null;
        }
        TileEntity tile = world.func_147438_o(position.x, position.y, position.z);
        if (tile instanceof IFruitBearer) {
            IFruitBearer fruitBearer = (IFruitBearer)tile;
            if (fruitBearer.hasFruit() && fruitBearer.getRipeness() >= 0.9f) {
                return new CropFruit(world, position, fruitBearer.getFruitFamily());
            }
        } else {
            for (IFarmable seed : this.farmables) {
                ICrop crop = seed.getCropAt(world, position.x, position.y, position.z);
                if (crop == null) continue;
                return crop;
            }
        }
        return null;
    }
}

