/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.recipes.RecipeManagers;
import forestry.core.GameMode;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.fluids.Fluids;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.MachineNBTDefinition;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemNBTTile;
import forestry.core.network.IPacketHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.RecipeUtil;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.factory.DummyManagers;
import forestry.factory.GuiHandlerFactory;
import forestry.factory.gadgets.MachineBottler;
import forestry.factory.gadgets.MachineCarpenter;
import forestry.factory.gadgets.MachineCentrifuge;
import forestry.factory.gadgets.MachineFabricator;
import forestry.factory.gadgets.MachineFermenter;
import forestry.factory.gadgets.MachineMoistener;
import forestry.factory.gadgets.MachineRaintank;
import forestry.factory.gadgets.MachineSqueezer;
import forestry.factory.gadgets.MachineStill;
import forestry.factory.gadgets.MillRainmaker;
import forestry.factory.gadgets.TileWorktable;
import forestry.factory.network.PacketHandlerFactory;
import forestry.factory.recipes.CraftGuideIntegration;
import forestry.factory.triggers.FactoryTriggers;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginManager;
import forestry.plugins.PluginStorage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@Plugin(pluginID="Factory", name="Factory", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.factory.description")
public class PluginFactory
extends ForestryPlugin {
    public static MachineDefinition definitionBottler;
    public static MachineDefinition definitionCarpenter;
    public static MachineDefinition definitionCentrifuge;
    public static MachineDefinition definitionFermenter;
    public static MachineDefinition definitionMoistener;
    public static MachineDefinition definitionSqueezer;
    public static MachineDefinition definitionStill;
    public static MachineDefinition definitionRainmaker;
    public static MachineDefinition definitionFabricator;
    public static MachineDefinition definitionRaintank;
    public static MachineDefinition definitionWorktable;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        RecipeManagers.carpenterManager = new MachineCarpenter.RecipeManager();
        RecipeManagers.centrifugeManager = new MachineCentrifuge.RecipeManager();
        RecipeManagers.fabricatorManager = new MachineFabricator.RecipeManager();
        RecipeManagers.fermenterManager = new MachineFermenter.RecipeManager();
        RecipeManagers.moistenerManager = new MachineMoistener.RecipeManager();
        RecipeManagers.squeezerManager = new MachineSqueezer.RecipeManager();
        RecipeManagers.stillManager = new MachineStill.RecipeManager();
        RecipeManagers.craftingProviders = ImmutableList.of((Object)RecipeManagers.carpenterManager, (Object)RecipeManagers.centrifugeManager, (Object)RecipeManagers.fabricatorManager, (Object)RecipeManagers.fermenterManager, (Object)RecipeManagers.moistenerManager, (Object)RecipeManagers.squeezerManager, (Object)RecipeManagers.stillManager);
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerFactory();
    }

    @Override
    protected void disabledSetupAPI() {
        super.disabledSetupAPI();
        RecipeManagers.carpenterManager = new DummyManagers.CarpenterManager();
        RecipeManagers.centrifugeManager = new DummyManagers.CentrifugeManager();
        RecipeManagers.fabricatorManager = new DummyManagers.FabricatorManager();
        RecipeManagers.fermenterManager = new DummyManagers.FermenterManager();
        RecipeManagers.moistenerManager = new DummyManagers.MoistenerManager();
        RecipeManagers.squeezerManager = new DummyManagers.SqueezerManager();
        RecipeManagers.stillManager = new DummyManagers.StillManager();
        RecipeManagers.craftingProviders = ImmutableList.of((Object)RecipeManagers.carpenterManager, (Object)RecipeManagers.centrifugeManager, (Object)RecipeManagers.fabricatorManager, (Object)RecipeManagers.fermenterManager, (Object)RecipeManagers.moistenerManager, (Object)RecipeManagers.squeezerManager, (Object)RecipeManagers.stillManager);
    }

    @Override
    public void preInit() {
        super.preInit();
        ForestryBlock.factoryTESR.registerBlock((Block)new BlockBase(Material.field_151573_f, true), ItemForestryBlock.class, "factory");
        BlockBase factoryTESR = (BlockBase)ForestryBlock.factoryTESR.block();
        definitionBottler = factoryTESR.addDefinition(new MachineDefinition(0, "forestry.Bottler", MachineBottler.class, Proxies.render.getRenderDefaultMachine("textures/blocks/bottler_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 0), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), ForestryItem.canEmpty, Character.valueOf('Y'), ForestryItem.sturdyCasing})));
        definitionCarpenter = factoryTESR.addDefinition(new MachineDefinition(1, "forestry.Carpenter", MachineCarpenter.class, Proxies.render.getRenderDefaultMachine("textures/blocks/carpenter_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 1), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), ForestryItem.sturdyCasing})));
        definitionCentrifuge = factoryTESR.addDefinition(new MachineDefinition(2, "forestry.Centrifuge", MachineCentrifuge.class, Proxies.render.getRenderDefaultMachine("textures/blocks/centrifuge_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 2), "X#X", "XYX", "X#X", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), ForestryItem.sturdyCasing.getItemStack())));
        definitionFermenter = factoryTESR.addDefinition(new MachineDefinition(3, "forestry.Fermenter", MachineFermenter.class, Proxies.render.getRenderDefaultMachine("textures/blocks/fermenter_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 3), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), "gearBronze", Character.valueOf('Y'), ForestryItem.sturdyCasing})));
        definitionMoistener = factoryTESR.addDefinition(new MachineDefinition(4, "forestry.Moistener", MachineMoistener.class, Proxies.render.getRenderDefaultMachine("textures/blocks/moistener_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 4), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), "gearCopper", Character.valueOf('Y'), ForestryItem.sturdyCasing})));
        definitionSqueezer = factoryTESR.addDefinition(new MachineDefinition(5, "forestry.Squeezer", MachineSqueezer.class, Proxies.render.getRenderDefaultMachine("textures/blocks/squeezer_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 5), "X#X", "XYX", "X#X", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), "ingotTin", Character.valueOf('Y'), ForestryItem.sturdyCasing.getItemStack())));
        definitionStill = factoryTESR.addDefinition(new MachineDefinition(6, "forestry.Still", MachineStill.class, Proxies.render.getRenderDefaultMachine("textures/blocks/still_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 6), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), Items.field_151137_ax, Character.valueOf('Y'), ForestryItem.sturdyCasing})));
        definitionRainmaker = factoryTESR.addDefinition(new MachineDefinition(7, "forestry.Rainmaker", MillRainmaker.class, Proxies.render.getRenderMill("textures/blocks/rainmaker_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 7), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), "gearTin", Character.valueOf('Y'), ForestryItem.hardenedCasing})));
        ForestryBlock.factoryPlain.registerBlock((Block)new BlockBase(Material.field_151573_f), ItemNBTTile.class, "factory2");
        BlockBase factoryPlain = (BlockBase)ForestryBlock.factoryPlain.block();
        definitionFabricator = factoryPlain.addDefinition(new MachineNBTDefinition(0, "forestry.Fabricator", MachineFabricator.class, ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryPlain.getItemStack(1, 0), new Object[]{"X#X", "#Y#", "XZX", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('Z'), Blocks.field_150486_ae})).setFaces(0, 1, 2, 3, 4, 4));
        definitionRaintank = factoryPlain.addDefinition(new MachineDefinition(1, "forestry.Raintank", MachineRaintank.class, ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryPlain.getItemStack(1, 1), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), Items.field_151042_j, Character.valueOf('Y'), ForestryItem.sturdyCasing})).setFaces(0, 1, 0, 0, 0, 0));
        definitionWorktable = factoryPlain.addDefinition(new MachineNBTDefinition(2, "forestry.Worktable", TileWorktable.class, ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryPlain.getItemStack(1, 2), "B", "W", "C", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('W'), Blocks.field_150462_ai, Character.valueOf('C'), Blocks.field_150486_ae)).setFaces(0, 1, 2, 3, 4, 4));
    }

    @Override
    protected void registerTriggers() {
        FactoryTriggers.initialize();
    }

    @Override
    public void doInit() {
        super.doInit();
        definitionBottler.register();
        definitionCarpenter.register();
        definitionCentrifuge.register();
        definitionFabricator.register();
        definitionFermenter.register();
        definitionMoistener.register();
        definitionRaintank.register();
        definitionSqueezer.register();
        definitionStill.register();
        definitionRainmaker.register();
        definitionWorktable.register();
    }

    @Override
    public void postInit() {
        super.postInit();
        if (Proxies.common.isModLoaded("craftguide")) {
            CraftGuideIntegration.register();
        } else {
            Proxies.log.info("Skipping CraftGuide integration.");
        }
    }

    @Override
    protected void registerRecipes() {
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 0), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), "ingotCopper"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 1), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), "ingotTin"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 2), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), "ingotBronze"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 3), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), Items.field_151042_j});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), Items.field_151043_k});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 5), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), Items.field_151045_i});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 6), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), Blocks.field_150343_Z});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 7), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), Items.field_151065_br});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 9), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), Items.field_151166_bC});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 10), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), "gemApatite"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 11), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 4)});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 12), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), new ItemStack(Items.field_151061_bv, 1, 0), Character.valueOf('X'), new ItemStack(Blocks.field_150377_bs, 1, 0)});
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            FluidStack liquidGlass = Fluids.GLASS.getFluid(1000);
            for (int i = 0; i < 16; ++i) {
                RecipeManagers.fabricatorManager.addRecipe(ForestryItem.waxCast.getItemStack(1, Short.MAX_VALUE), liquidGlass, ForestryBlock.glass.getItemStack(1, 15 - i), new Object[]{"#", "X", Character.valueOf('#'), dyes[i], Character.valueOf('X'), ForestryItem.propolis.getItemStack(1, Short.MAX_VALUE)});
            }
        }
        int appleMulchAmount = GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple");
        int appleJuiceAmount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple");
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151034_e)}, Fluids.JUICE.getFluid(appleJuiceAmount), ForestryItem.mulch.getItemStack(), appleMulchAmount);
        int seedOilAmount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed");
        FluidStack seedOil = Fluids.SEEDOIL.getFluid(seedOilAmount);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151014_N)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151080_bb)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151081_bc)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.phosphor.getItemStack(2), new ItemStack(Blocks.field_150347_e)}, Fluids.LAVA.getFluid(1600));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Blocks.field_150434_aF)}, Fluids.WATER.getFluid(500));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151126_ay), ForestryItem.craftingMaterial.getItemStack(4, 5)}, Fluids.ICE.getFluid(4000));
        RecipeManagers.stillManager.addRecipe(100, Fluids.BIOMASS.getFluid(10), Fluids.ETHANOL.getFluid(3));
        RecipeManagers.stillManager.addRecipe(1, Fluids.LEGACY_HONEY.getFluid(1000), Fluids.HONEY.getFluid(1000));
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Items.field_151014_N), new ItemStack((Block)Blocks.field_150391_bh), 5000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150341_Y), 20000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150417_aV, 1, 1), 20000);
        for (int i = 0; i < 6; ++i) {
            RecipeUtil.injectLeveledRecipe(new ItemStack(Blocks.field_150345_g, 1, i), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        }
        RecipeUtil.injectLeveledRecipe(new ItemStack(Blocks.field_150434_aF), GameMode.getGameMode().getIntegerSetting("fermenter.yield.cactus"), Fluids.BIOMASS);
        RecipeUtil.injectLeveledRecipe(new ItemStack(Items.field_151015_O), GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        RecipeUtil.injectLeveledRecipe(new ItemStack(Items.field_151120_aE), GameMode.getGameMode().getIntegerSetting("fermenter.yield.cane"), Fluids.BIOMASS);
        RecipeUtil.injectLeveledRecipe(new ItemStack((Block)Blocks.field_150338_P), GameMode.getGameMode().getIntegerSetting("fermenter.yield.mushroom"), Fluids.BIOMASS);
        RecipeUtil.injectLeveledRecipe(new ItemStack((Block)Blocks.field_150337_Q), GameMode.getGameMode().getIntegerSetting("fermenter.yield.mushroom"), Fluids.BIOMASS);
        RecipeManagers.fabricatorManager.addSmelting(new ItemStack(Blocks.field_150359_w), Fluids.GLASS.getFluid(1000), 1000);
        RecipeManagers.fabricatorManager.addSmelting(new ItemStack(Blocks.field_150410_aZ), Fluids.GLASS.getFluid(375), 1000);
        RecipeManagers.fabricatorManager.addSmelting(new ItemStack((Block)Blocks.field_150354_m), Fluids.GLASS.getFluid(1000), 3000);
        RecipeManagers.carpenterManager.addRecipe(50, Fluids.SEEDOIL.getFluid(250), null, ForestryItem.impregnatedCasing.getItemStack(), "###", "# #", "###", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(50, Fluids.SEEDOIL.getFluid(500), null, ForestryBlock.core.getItemStack(1, 1), "#  ", "###", "# #", Character.valueOf('#'), "plankWood");
        RecipeManagers.carpenterManager.addRecipe(10, Fluids.SEEDOIL.getFluid(100), null, ForestryItem.stickImpregnated.getItemStack(2), "#", "#", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(250), null, ForestryItem.woodPulp.getItemStack(4), "#", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(250), null, new ItemStack(Items.field_151121_aF, 1), "#", "#", Character.valueOf('#'), "pulpWood");
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, ForestryBlock.soil.getItemStack(9), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, ForestryBlock.soil.getItemStack(8, 1), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), Blocks.field_150354_m, Character.valueOf('Y'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(75, Fluids.WATER.getFluid(5000), null, ForestryItem.hardenedCasing.getItemStack(), new Object[]{"# #", " Y ", "# #", Character.valueOf('#'), Items.field_151045_i, Character.valueOf('Y'), ForestryItem.sturdyCasing});
        RecipeManagers.carpenterManager.addRecipe(20, Fluids.WATER.getFluid(1000), null, ForestryItem.circuitboards.getItemStack(1, 0), "R R", "R#R", "R R", Character.valueOf('#'), "ingotTin", Character.valueOf('R'), Items.field_151137_ax);
        RecipeManagers.carpenterManager.addRecipe(40, Fluids.WATER.getFluid(1000), null, ForestryItem.circuitboards.getItemStack(1, 1), "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotBronze", Character.valueOf('R'), Items.field_151137_ax);
        RecipeManagers.carpenterManager.addRecipe(80, Fluids.WATER.getFluid(1000), null, ForestryItem.circuitboards.getItemStack(1, 2), "R#R", "R#R", "R#R", Character.valueOf('#'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax);
        RecipeManagers.carpenterManager.addRecipe(80, Fluids.WATER.getFluid(1000), null, ForestryItem.circuitboards.getItemStack(1, 3), "R#R", "R#R", "R#R", Character.valueOf('#'), Items.field_151043_k, Character.valueOf('R'), Items.field_151137_ax);
        RecipeManagers.carpenterManager.addRecipe(40, Fluids.WATER.getFluid(1000), null, ForestryItem.solderingIron.getItemStack(), " # ", "# #", "  B", Character.valueOf('#'), Items.field_151042_j, Character.valueOf('B'), "ingotBronze");
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, ForestryItem.iodineCharge.getItemStack(), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.pollenCluster, Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeyDrop});
            RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, ForestryItem.craftingMaterial.getItemStack(1, 4), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.royalJelly, Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeydew});
        }
        RecipeManagers.carpenterManager.addRecipe(100, null, new ItemStack(Items.field_151079_bi, 1), " # ", "###", " # ", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 1));
        RecipeManagers.carpenterManager.addRecipe(10, Fluids.WATER.getFluid(500), null, ForestryItem.craftingMaterial.getItemStack(1, 3), "###", "###", "###", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 2));
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, ForestryItem.carton.getItemStack(2), " # ", "# #", " # ", Character.valueOf('#'), "pulpWood");
        RecipeManagers.carpenterManager.addRecipe(20, (FluidStack)null, ForestryItem.carton.getItemStack(), ForestryItem.kitPickaxe.getItemStack(), "###", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeManagers.carpenterManager.addRecipe(20, (FluidStack)null, ForestryItem.carton.getItemStack(), ForestryItem.kitShovel.getItemStack(), " # ", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeManagers.carpenterManager.addRecipe(null, ForestryItem.ingotBronze.getItemStack(2, ForestryItem.ingotBronze.item().func_77612_l()), new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzePickaxe});
        RecipeManagers.carpenterManager.addRecipe(null, ForestryItem.ingotBronze.getItemStack(), new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzeShovel});
        if (PluginManager.Module.STORAGE.isEnabled()) {
            PluginStorage.createCrateRecipes();
        }
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFactory();
    }
}

