/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityOxygenStorageModule
extends TileEntityOxygen
implements ISidedInventory,
IFluidHandler {
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int scaledOxygenLevel;
    private int lastScaledOxygenLevel;
    public static final int OUTPUT_PER_TICK = 500;
    public static final int OXYGEN_CAPACITY = 60000;
    private ItemStack[] containingItems = new ItemStack[1];

    public TileEntityOxygenStorageModule() {
        super(60000.0f, 40.0f);
        this.storage.setCapacity(0.0f);
        this.storage.setMaxExtract(0.0f);
    }

    @Override
    public void func_145845_h() {
        ItemStack oxygenItemStack;
        if (!this.field_145850_b.field_72995_K && (oxygenItemStack = this.func_70301_a(0)) != null && oxygenItemStack.func_77973_b() instanceof IItemOxygenSupply) {
            IItemOxygenSupply oxygenItem = (IItemOxygenSupply)oxygenItemStack.func_77973_b();
            float oxygenDraw = Math.min(this.oxygenPerTick * 2.5f, this.maxOxygen - this.storedOxygen);
            this.storedOxygen += oxygenItem.discharge(oxygenItemStack, oxygenDraw);
            if (this.storedOxygen > this.maxOxygen) {
                this.storedOxygen = this.maxOxygen;
            }
        }
        super.func_145845_h();
        this.scaledOxygenLevel = this.getScaledOxygenLevel(16);
        if (this.scaledOxygenLevel != this.lastScaledOxygenLevel) {
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.lastScaledOxygenLevel = this.scaledOxygenLevel;
        this.produceOxygen(ForgeDirection.getOrientation((int)(this.func_145832_p() - 8 + 2 ^ 1)));
        this.lastScaledOxygenLevel = this.scaledOxygenLevel;
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)list);
    }

    @Override
    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public boolean shouldPullEnergy() {
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return false;
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return null;
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return null;
    }

    @Override
    public boolean shouldUseOxygen() {
        return false;
    }

    @Override
    public float getOxygenProvide(ForgeDirection direction) {
        return this.getOxygenOutputDirection() == direction ? Math.min(500.0f, this.getOxygenStored()) : 0.0f;
    }

    @Override
    public EnumSet<ForgeDirection> getOxygenInputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)(this.func_145832_p() - 8 + 2)));
    }

    @Override
    public EnumSet<ForgeDirection> getOxygenOutputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)(this.func_145832_p() - 8 + 2 ^ 1)));
    }

    public ForgeDirection getOxygenOutputDirection() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() - 8 + 2 ^ 1));
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("tile.machine2.6.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && itemstack != null && itemstack.func_77973_b() instanceof IItemOxygenSupply;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (slotID == 0 && this.func_94041_b(slotID, itemstack)) {
            return itemstack.func_77960_j() < itemstack.func_77973_b().func_77612_l();
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 0 && itemstack != null) {
            return FluidUtil.isEmptyContainer(itemstack);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from.ordinal() == this.func_145832_p() - 8 + 2 && GalacticraftCore.isPlanetsLoaded) {
            return fluid != null && fluid.getName().equals(AsteroidsModule.fluidLiquidOxygen.getName());
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (resource != null && this.canFill(from, resource.getFluid())) {
            used = (int)(this.receiveOxygen((float)resource.amount / 0.09259259f, doFill) * 0.09259259f);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        int side;
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        int metaside = this.func_145832_p() - 8 + 2;
        if (metaside == (side = from.ordinal()) && GalacticraftCore.isPlanetsLoaded) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo(new FluidStack(AsteroidsModule.fluidLiquidOxygen, (int)(this.getOxygenStored() * 0.09259259f)), 5555)};
        }
        return tankInfo;
    }
}

