/*
 * Decompiled with CFR 0.152.
 */
package openmods.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.api.IActivateAwareTile;
import openmods.api.IAddAwareTile;
import openmods.api.IBreakAwareTile;
import openmods.api.ICustomBreakDrops;
import openmods.api.ICustomHarvestDrops;
import openmods.api.ICustomPickItem;
import openmods.api.IHasGui;
import openmods.api.IIconProvider;
import openmods.api.INeighbourAwareTile;
import openmods.api.INeighbourTeAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.api.IPlacerAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.block.BlockDropsStore;
import openmods.block.BlockRotationMode;
import openmods.block.RotationAxis;
import openmods.block.RotationHelper;
import openmods.config.game.IRegisterableBlock;
import openmods.geometry.BlockSpaceTransform;
import openmods.geometry.Orientation;
import openmods.inventory.IInventoryProvider;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.BlockUtils;

public abstract class OpenBlock
extends Block
implements IRegisterableBlock {
    public static final int OPEN_MODS_TE_GUI = -1;
    private static final int EVENT_ADDED = -1;
    private final Set<TileEntityCapability> teCapabilities = EnumSet.noneOf(TileEntityCapability.class);
    private Class<? extends TileEntity> teClass = null;
    protected BlockRotationMode blockRotationMode = BlockRotationMode.NONE;
    protected BlockPlacementMode blockPlacementMode = BlockPlacementMode.ENTITY_ANGLE;
    protected Orientation inventoryRenderOrientation;
    protected RenderMode renderMode = RenderMode.BLOCK_ONLY;
    public IIcon[] textures = new IIcon[6];

    public boolean hasCapability(TileEntityCapability capability) {
        return this.teCapabilities.contains((Object)capability);
    }

    public boolean hasCapabilities(TileEntityCapability capability1, TileEntityCapability capability2) {
        return this.hasCapability(capability1) || this.hasCapability(capability2);
    }

    public boolean hasCapabilities(TileEntityCapability ... capabilities) {
        for (TileEntityCapability capability : capabilities) {
            if (!this.teCapabilities.contains((Object)capability)) continue;
            return true;
        }
        return false;
    }

    protected OpenBlock(Material material) {
        super(material);
        this.func_149711_c(1.0f);
        this.field_149758_A = false;
    }

    protected void setPlacementMode(BlockPlacementMode mode) {
        this.blockPlacementMode = mode;
    }

    protected void setRotationMode(BlockRotationMode mode) {
        this.blockRotationMode = mode;
    }

    public BlockRotationMode getRotationMode() {
        return this.blockRotationMode;
    }

    protected BlockPlacementMode getPlacementMode() {
        return this.blockPlacementMode;
    }

    protected void setInventoryRenderOrientation(Orientation orientation) {
        this.inventoryRenderOrientation = orientation;
    }

    protected void setRenderMode(RenderMode renderMode) {
        this.renderMode = renderMode;
    }

    public Orientation getOrientation(int metadata) {
        BlockRotationMode rotationMode = this.getRotationMode();
        return rotationMode.fromValue(metadata & rotationMode.mask);
    }

    @SideOnly(value=Side.CLIENT)
    public Orientation getInventoryRenderOrientation() {
        return this.inventoryRenderOrientation != null ? this.inventoryRenderOrientation : this.getRotationMode().getInventoryRenderOrientation();
    }

    @SideOnly(value=Side.CLIENT)
    public int getInventoryRenderMetadata(int itemMetadata) {
        BlockRotationMode rotationMode = this.getRotationMode();
        Orientation renderOrientation = this.inventoryRenderOrientation != null ? this.inventoryRenderOrientation : rotationMode.getInventoryRenderOrientation();
        return rotationMode.toValue(renderOrientation);
    }

    public void setBlockBounds(AxisAlignedBB aabb) {
        this.field_149755_E = aabb.field_72336_d;
        this.field_149756_F = aabb.field_72337_e;
        this.field_149757_G = aabb.field_72334_f;
        this.field_149759_B = aabb.field_72340_a;
        this.field_149760_C = aabb.field_72338_b;
        this.field_149754_D = aabb.field_72339_c;
    }

    public boolean shouldDropFromTeAfterBreak() {
        return true;
    }

    public boolean shouldOverrideHarvestWithTeLogic() {
        return this.hasCapability(TileEntityCapability.CUSTOM_HARVEST_DROPS);
    }

    public void setBoundsBasedOnOrientation(Orientation orientation) {
    }

    public static OpenBlock getOpenBlock(IBlockAccess world, int x, int y, int z) {
        if (world == null) {
            return null;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof OpenBlock) {
            return (OpenBlock)block;
        }
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        TileEntity te = this.createTileEntity();
        if (te != null) {
            te.field_145854_h = this;
            if (te instanceof OpenTileEntity) {
                ((OpenTileEntity)te).setup();
            }
        }
        return te;
    }

    public TileEntity createTileEntityForRender() {
        TileEntity te = this.createTileEntity();
        Preconditions.checkNotNull((Object)te, (String)"Trying to get rendering TE for '%s', but it's not configured", (Object[])new Object[]{this});
        te.field_145854_h = this;
        te.field_145847_g = 0;
        return te;
    }

    protected TileEntity createTileEntity() {
        if (this.teClass == null) {
            return null;
        }
        try {
            return this.teClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create TE with class " + this.teClass, ex);
        }
    }

    public Class<? extends TileEntity> getTileClass() {
        return this.teClass;
    }

    protected boolean suppressPickBlock() {
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity te;
        if (this.hasCapability(TileEntityCapability.CUSTOM_PICK_ITEM) && (te = world.func_147438_o(x, y, z)) instanceof ICustomPickItem) {
            return ((ICustomPickItem)te).getPickBlock();
        }
        return this.suppressPickBlock() ? null : super.getPickBlock(target, world, x, y, z);
    }

    private static List<ItemStack> getTileBreakDrops(TileEntity te) {
        ArrayList breakDrops = Lists.newArrayList();
        BlockUtils.getTileInventoryDrops(te, breakDrops);
        if (te instanceof ICustomBreakDrops) {
            ((ICustomBreakDrops)te).addDrops(breakDrops);
        }
        return breakDrops;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te;
        if (this.shouldDropFromTeAfterBreak() && (te = world.func_147438_o(x, y, z)) != null) {
            if (te instanceof IBreakAwareTile) {
                ((IBreakAwareTile)te).onBlockBroken();
            }
            for (ItemStack stack : OpenBlock.getTileBreakDrops(te)) {
                BlockUtils.dropItemStackInWorld(world, x, y, z, stack);
            }
            world.func_147475_p(x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    protected ArrayList<ItemStack> getDropsWithTileEntity(World world, EntityPlayer player, int x, int y, int z) {
        TileEntity te;
        if (this.hasCapability(TileEntityCapability.CUSTOM_HARVEST_DROPS) && (te = world.func_147438_o(x, y, z)) instanceof ICustomHarvestDrops) {
            ArrayList drops;
            ICustomHarvestDrops dropper = (ICustomHarvestDrops)te;
            if (!dropper.suppressNormalHarvestDrops()) {
                int metadata = world.func_72805_g(x, y, z);
                int fortune = player != null ? EnchantmentHelper.func_77517_e((EntityLivingBase)player) : 0;
                drops = super.getDrops(world, x, y, z, metadata, fortune);
            } else {
                drops = Lists.newArrayList();
            }
            dropper.addHarvestDrops(player, drops);
            return drops;
        }
        return null;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        ArrayList<ItemStack> drops;
        if (willHarvest && this.shouldOverrideHarvestWithTeLogic() && (drops = this.getDropsWithTileEntity(world, player, x, y, z)) != null) {
            BlockDropsStore.instance.storeDrops(world, x, y, z, drops);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> result = BlockDropsStore.instance.harvestDrops(world, x, y, z);
        if (result != null) {
            return result;
        }
        result = this.getDropsWithTileEntity(world, null, x, y, z);
        if (result != null) {
            return result;
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    @Override
    public void setupBlock(String modId, String blockName, Class<? extends TileEntity> tileEntity, Class<? extends ItemBlock> itemClass) {
        if (tileEntity != null) {
            this.teClass = tileEntity;
            this.field_149758_A = true;
            for (TileEntityCapability capability : TileEntityCapability.values()) {
                if (!capability.intf.isAssignableFrom(this.teClass)) continue;
                this.teCapabilities.add(capability);
            }
        }
    }

    public boolean hasTileEntity(int metadata) {
        return this.teClass != null;
    }

    public static final boolean isNeighborBlockSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return world.isSideSolid(x += side.offsetX, y += side.offsetY, z += side.offsetZ, side.getOpposite(), false);
    }

    public static final boolean areNeighborBlocksSolid(World world, int x, int y, int z, ForgeDirection ... sides) {
        for (ForgeDirection side : sides) {
            if (!OpenBlock.isNeighborBlockSolid((IBlockAccess)world, x, y, z, side)) continue;
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        if (this.hasCapabilities(TileEntityCapability.NEIGBOUR_LISTENER, TileEntityCapability.SURFACE_ATTACHEMENT)) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof INeighbourAwareTile) {
                ((INeighbourAwareTile)te).onNeighbourChanged(neighbour);
            }
            if (te instanceof ISurfaceAttachment) {
                ForgeDirection direction = ((ISurfaceAttachment)te).getSurfaceDirection();
                this.breakBlockIfSideNotSolid(world, x, y, z, direction);
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity te;
        if (this.hasCapability(TileEntityCapability.NEIGBOUR_TE_LISTENER) && (te = world.func_147438_o(x, y, z)) instanceof INeighbourTeAwareTile) {
            ((INeighbourTeAwareTile)te).onNeighbourTeChanged(tileX, tileY, tileZ);
        }
    }

    protected void breakBlockIfSideNotSolid(World world, int x, int y, int z, ForgeDirection direction) {
        if (!OpenBlock.isNeighborBlockSolid((IBlockAccess)world, x, y, z, direction)) {
            world.func_147480_a(x, y, z, true);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (this.hasCapability(TileEntityCapability.ADD_LISTENER)) {
            world.func_147452_c(x, y, z, (Block)this, -1, 0);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.hasCapabilities(TileEntityCapability.GUI_PROVIDER, TileEntityCapability.ACTIVATE_LISTENER)) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof IHasGui && ((IHasGui)te).canOpenGui(player) && !player.func_70093_af()) {
                if (!world.field_72995_K) {
                    this.openGui(player, world, x, y, z);
                }
                return true;
            }
            if (te instanceof IActivateAwareTile) {
                return ((IActivateAwareTile)te).onBlockActivated(player, side, hitX, hitY, hitZ);
            }
        }
        return false;
    }

    public boolean func_149686_d() {
        return this.func_149662_c();
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventId, int eventParam) {
        if (eventId < 0 && !world.field_72995_K) {
            switch (eventId) {
                case -1: {
                    IAddAwareTile te;
                    if (!this.hasCapability(TileEntityCapability.ADD_LISTENER) || (te = OpenBlock.getTileEntity((IBlockAccess)world, x, y, z, IAddAwareTile.class)) == null) break;
                    te.onAdded();
                }
            }
            return false;
        }
        if (this.field_149758_A) {
            super.func_149696_a(world, x, y, z, eventId, eventParam);
            TileEntity te = world.func_147438_o(x, y, z);
            return te != null ? te.func_145842_c(eventId, eventParam) : false;
        }
        return super.func_149696_a(world, x, y, z, eventId, eventParam);
    }

    protected void setupDimensionsFromCenter(float x, float y, float z, float width, float height, float depth) {
        this.setupDimensions(x - width, y, z - depth, x + width, y + height, z + depth);
    }

    protected void setupDimensions(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.field_149759_B = minX;
        this.field_149760_C = minY;
        this.field_149754_D = minZ;
        this.field_149755_E = maxX;
        this.field_149756_F = maxY;
        this.field_149757_G = maxZ;
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public static <U> U getTileEntity(IBlockAccess world, int x, int y, int z, Class<? extends U> cls) {
        TileEntity te = world.func_147438_o(x, y, z);
        return (U)(cls.isInstance(te) ? te : null);
    }

    public <U extends TileEntity> U getTileEntity(IBlockAccess world, int x, int y, int z) {
        Preconditions.checkNotNull(this.teClass, (Object)"This block has no tile entity");
        TileEntity te = world.func_147438_o(x, y, z);
        return (U)(this.teClass.isInstance(te) ? te : null);
    }

    public boolean canPlaceBlock(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection sideDir, Orientation blockOrientation, float hitX, float hitY, float hitZ, int newMeta) {
        return this.getRotationMode().isPlacementValid(blockOrientation);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        super.func_149689_a(world, x, y, z, placer, stack);
        if (this.hasCapability(TileEntityCapability.PLACER_LISTENER) && (te = world.func_147438_o(x, y, z)) instanceof IPlacerAwareTile) {
            ((IPlacerAwareTile)te).onBlockPlacedBy(placer, stack);
        }
    }

    public void afterBlockPlaced(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection side, Orientation blockOrientation, float hitX, float hitY, float hitZ, int itemMeta) {
        int blockMeta = this.getRotationMode().toValue(blockOrientation);
        world.func_72921_c(x, y, z, blockMeta, 0);
        this.notifyTileEntity(world, player, stack, x, y, z, side, blockOrientation, hitX, hitY, hitZ);
        world.func_147471_g(x, y, z);
        if (!world.field_72995_K) {
            world.func_147444_c(x, y, z, (Block)this);
        }
    }

    protected void notifyTileEntity(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection side, Orientation blockOrientation, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (this.hasCapability(TileEntityCapability.PLACE_LISTENER) && (te = world.func_147438_o(x, y, z)) instanceof IPlaceAwareTile) {
            ((IPlaceAwareTile)te).onBlockPlacedBy(player, side, stack, hitX, hitY, hitZ);
        }
    }

    protected void setRotationMeta(World world, int x, int y, int z, Orientation blockOrientation) {
        int blockMeta = this.getRotationMode().toValue(blockOrientation);
        world.func_72921_c(x, y, z, blockMeta, 3);
    }

    public Orientation calculatePlacementSide(EntityPlayer player, ForgeDirection side) {
        if (this.blockPlacementMode == BlockPlacementMode.SURFACE) {
            return this.getRotationMode().getPlacementOrientationFromSurface(side);
        }
        return this.getRotationMode().getPlacementOrientationFromEntity(player);
    }

    public final boolean func_149707_d(World world, int x, int y, int z, int side) {
        return this.canPlaceBlockOnSide(world, x, y, z, ForgeDirection.getOrientation((int)side).getOpposite());
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return this.func_149742_c(world, x, y, z);
    }

    protected boolean isOnTopOfSolidBlock(World world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.DOWN && OpenBlock.isNeighborBlockSolid((IBlockAccess)world, x, y, z, ForgeDirection.DOWN);
    }

    public void setTexture(ForgeDirection direction, IIcon icon) {
        this.textures[direction.ordinal()] = icon;
    }

    public void setTextures(IIcon icon, ForgeDirection ... directions) {
        for (ForgeDirection direction : directions) {
            this.textures[direction.ordinal()] = icon;
        }
    }

    protected IIcon getUnrotatedTexture(ForgeDirection direction) {
        int directionId;
        if (direction != ForgeDirection.UNKNOWN && this.textures[directionId = direction.ordinal()] != null) {
            return this.textures[directionId];
        }
        return this.field_149761_L;
    }

    public IIcon getUnrotatedTexture(ForgeDirection direction, IBlockAccess world, int x, int y, int z) {
        return this.getUnrotatedTexture(direction);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        IIconProvider provider;
        ForgeDirection direction = this.rotateSideByMetadata(side, world.func_72805_g(x, y, z));
        IIcon iconOverride = null;
        if (this.hasCapability(TileEntityCapability.ICON_PROVIDER) && (provider = OpenBlock.getTileEntity(world, x, y, z, IIconProvider.class)) != null) {
            iconOverride = provider.getIcon(direction);
        }
        return iconOverride != null ? iconOverride : this.getUnrotatedTexture(direction, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149691_a(int side, int metadata) {
        ForgeDirection newRotation = this.rotateSideByMetadata(side, metadata);
        return this.getUnrotatedTexture(newRotation);
    }

    public ForgeDirection rotateSideByMetadata(int side, int metadata) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        return this.rotateSideByMetadata(dir, metadata);
    }

    public ForgeDirection rotateSideByMetadata(ForgeDirection side, int metadata) {
        Orientation rotation = this.getOrientation(metadata);
        return rotation.globalToLocalDirection(side);
    }

    public Vec3 rotateVectorByMetadata(Vec3 vec, int metadata) {
        return this.rotateVectorByMetadata(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, metadata);
    }

    public Vec3 rotateVectorByMetadata(double x, double y, double z, int metadata) {
        Orientation rotation = this.getOrientation(metadata);
        return this.rotateVectorByDirection(rotation, x, y, z);
    }

    public Vec3 rotateVectorByDirection(Orientation orientation, double x, double y, double z) {
        return BlockSpaceTransform.instance.mapWorldToBlock(orientation, x, y, z);
    }

    public void setDefaultTexture(IIcon icon) {
        this.field_149761_L = icon;
    }

    protected abstract Object getModInstance();

    public void openGui(EntityPlayer player, World world, int x, int y, int z) {
        player.openGui(this.getModInstance(), -1, world, x, y, z);
    }

    public final boolean shouldRenderBlock() {
        return this.renderMode != RenderMode.TESR_ONLY;
    }

    public final boolean shouldRenderTesrInInventory() {
        return this.renderMode != RenderMode.BLOCK_ONLY;
    }

    public boolean canRotateWithTool() {
        return this.getRotationMode() != BlockRotationMode.NONE;
    }

    public RotationHelper createRotationHelper(World world, int x, int y, int z) {
        return new RotationHelper(this.getRotationMode(), world, x, y, z);
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        if (!this.canRotateWithTool()) {
            return false;
        }
        if (!this.createRotationHelper(worldObj, x, y, z).rotateWithTool(axis)) {
            return false;
        }
        if (this.teCapabilities.contains((Object)TileEntityCapability.SURFACE_ATTACHEMENT)) {
            ISurfaceAttachment te = OpenBlock.getTileEntity((IBlockAccess)worldObj, x, y, z, ISurfaceAttachment.class);
            if (te == null) {
                return false;
            }
            this.breakBlockIfSideNotSolid(worldObj, x, y, z, te.getSurfaceDirection());
        }
        return true;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        if (!this.canRotateWithTool()) {
            return RotationAxis.NO_AXIS;
        }
        return this.getRotationMode().rotationAxes;
    }

    public static enum RenderMode {
        TESR_ONLY,
        BLOCK_ONLY,
        BOTH;

    }

    public static enum BlockPlacementMode {
        ENTITY_ANGLE,
        SURFACE;

    }

    private static enum TileEntityCapability {
        ICON_PROVIDER(IIconProvider.class),
        GUI_PROVIDER(IHasGui.class),
        ACTIVATE_LISTENER(IActivateAwareTile.class),
        SURFACE_ATTACHEMENT(ISurfaceAttachment.class),
        BREAK_LISTENER(IBreakAwareTile.class),
        PLACER_LISTENER(IPlacerAwareTile.class),
        PLACE_LISTENER(IPlaceAwareTile.class),
        ADD_LISTENER(IAddAwareTile.class),
        CUSTOM_PICK_ITEM(ICustomPickItem.class),
        CUSTOM_BREAK_DROPS(ICustomBreakDrops.class),
        CUSTOM_HARVEST_DROPS(ICustomHarvestDrops.class),
        INVENTORY(IInventory.class),
        INVENTORY_PROVIDER(IInventoryProvider.class),
        NEIGBOUR_LISTENER(INeighbourAwareTile.class),
        NEIGBOUR_TE_LISTENER(INeighbourTeAwareTile.class);

        public final Class<?> intf;

        private TileEntityCapability(Class<?> intf) {
            this.intf = intf;
        }
    }
}

