/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.primitives.UnsignedBytes;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;

public class SyncableUnsignedByte
extends SyncableObjectBase
implements ISyncableValueProvider<Integer> {
    private int value;

    public SyncableUnsignedByte(int value) {
        this.value = value;
    }

    public SyncableUnsignedByte() {
    }

    public void set(int newValue) {
        if ((newValue &= 0xFF) != this.value) {
            this.value = newValue;
            this.markDirty();
        }
    }

    public int get() {
        return this.value & 0xFF;
    }

    @Override
    public Integer getValue() {
        return this.get();
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        this.value = stream.readUnsignedByte();
    }

    @Override
    public void writeToStream(DataOutputStream stream) throws IOException {
        stream.writeByte(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74774_a(name, (byte)(this.value & 0xFF));
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.value = tag.func_74771_c(name) & 0xFF;
    }

    public void modify(int by) {
        this.set(UnsignedBytes.saturatedCast((long)(this.value + by)));
    }
}

