/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.effects;

import com.builtbroken.mc.imp.transform.vector.Pos;
import java.awt.Color;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class VisualEffectProvider {
    public final String name;

    public VisualEffectProvider(String name) {
        this.name = name;
    }

    public void displayEffect(World world, double x, double y, double z, double mx, double my, double mz, boolean movementIsEndpoint, NBTTagCompound otherData) {
        if (this.shouldDisplay(world, x, y, z, mx, my, mz, movementIsEndpoint, otherData)) {
            if (movementIsEndpoint) {
                Pos pos = (Pos)((Pos)new Pos(mx, my, mz).sub(x, y, z)).normalize();
                if (otherData.func_74764_b("vel")) {
                    pos = (Pos)pos.multiply(otherData.func_74760_g("vel"));
                }
                mx = pos.x();
                my = pos.y();
                mz = pos.z();
            }
            this.displayEffect(world, x, y, z, mx, my, mz, otherData);
        }
    }

    protected boolean shouldDisplay(World world, double x, double y, double z, double mx, double my, double mz, boolean movementIsEndpoint, NBTTagCompound otherData) {
        return this.shouldDisplay(world, x, y, z);
    }

    protected boolean shouldDisplay(World world, double x, double y, double z) {
        return true;
    }

    public void displayEffect(World world, double x, double y, double z, double mx, double my, double mz, NBTTagCompound otherData) {
    }

    protected Color getColor(NBTTagCompound tag) {
        if (tag.func_74764_b("color")) {
            return new Color(tag.func_74762_e("color"));
        }
        return new Color(tag.func_74762_e("red"), tag.func_74762_e("green"), tag.func_74762_e("blue"));
    }
}

