/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.audio;

import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.util.ResourceLocation;

public class AudioData
extends JsonGenData {
    public final String key;
    public final ResourceLocation soundLocation;

    public AudioData(IJsonProcessor processor, String key, String soundLocation) {
        super(processor);
        this.key = key;
        this.soundLocation = new ResourceLocation(soundLocation);
    }

    public void play(double x, double y, double z, float pitch, float volume) {
        try {
            if (this.soundLocation != null) {
                if (Minecraft.func_71410_x() != null) {
                    if (Minecraft.func_71410_x().field_71441_e != null) {
                        SoundEventAccessorComposite sound = Minecraft.func_71410_x().func_147118_V().func_147680_a(this.soundLocation);
                        if (sound != null) {
                            Minecraft.func_71410_x().field_71441_e.func_72980_b(x, y, z, this.soundLocation.toString(), pitch, volume, false);
                        } else {
                            Engine.logger().debug("AudioData#play() Failed to locate sound instance for " + this, (Throwable)new RuntimeException());
                        }
                    } else if (Engine.runningAsDev) {
                        Engine.logger().debug("AudioData#play() Minecraft client world is not loaded" + this, (Throwable)new RuntimeException());
                    }
                } else if (Engine.runningAsDev) {
                    Engine.logger().debug("AudioData#play() Minecraft is not loaded" + this, (Throwable)new RuntimeException());
                }
            } else if (Engine.runningAsDev) {
                Engine.logger().debug("AudioData#play() " + this + " does not have a sound location", (Throwable)new RuntimeException());
            }
        }
        catch (Exception e) {
            Engine.logger().error("AudioData#play() : Failed to play sound " + this, (Throwable)e);
        }
    }

    @Override
    public void onCreated() {
        ClientDataHandler.INSTANCE.addAudio(this.key, this);
    }

    @Override
    public String getContentID() {
        return this.key;
    }

    @Override
    public String getUniqueID() {
        return this.key;
    }

    public String toString() {
        return "AudioData[ " + this.key + ", " + this.soundLocation + "]@" + this.hashCode();
    }
}

