/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.render.state;

import com.builtbroken.jlib.helpers.MathHelper;
import com.builtbroken.mc.client.SharedAssets;
import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.imp.IModelState;
import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.models.ModelData;
import com.builtbroken.mc.client.json.render.state.RenderStateTexture;
import com.builtbroken.mc.client.json.texture.TextureData;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Pos;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class ModelState
extends RenderStateTexture
implements IModelState {
    public String modelID;
    public String[] parts;
    public Pos offset;
    public Pos scale;
    public EulerAngle rotation;
    public String[] rotationOrder = new String[]{"roll", "pitch", "yaw"};
    public boolean renderParent = false;
    public boolean combineRotations = false;
    public boolean renderOnlyParts = true;
    protected EulerAngle _cachedRotation;

    public ModelState(String ID) {
        super(ID);
    }

    public ModelState(String ID, String modelID, Pos offset, Pos scale, EulerAngle rotation) {
        this(ID);
        this.modelID = modelID;
        this.offset = offset;
        this.scale = scale;
        this.rotation = rotation;
    }

    @Override
    public boolean render(boolean subRender, float yaw, float pitch, float roll) {
        TextureData textureData = this.getTexture();
        ModelData modelData = this.getModel();
        if (modelData != null && modelData.getModel() != null) {
            GL11.glPushMatrix();
            if (!subRender) {
                if (this.scale != null) {
                    GL11.glScaled((double)this.scale.x(), (double)this.scale.y(), (double)this.scale.z());
                } else if (this.parentState instanceof IModelState && ((IModelState)this.parentState).getScale() != null) {
                    GL11.glScaled((double)((IModelState)this.parentState).getScale().x(), (double)((IModelState)this.parentState).getScale().y(), (double)((IModelState)this.parentState).getScale().z());
                }
                if (this.combineRotations && this._cachedRotation == null && this.parentState != null) {
                    double r = this.rotation != null ? this.rotation.roll() : 0.0;
                    double p = this.rotation != null ? this.rotation.pitch() : 0.0;
                    double y = this.rotation != null ? this.rotation.yaw() : 0.0;
                    IRenderState state = this.getParent();
                    while (state instanceof IModelState) {
                        EulerAngle rot = ((IModelState)state).getRotation();
                        if (rot != null) {
                            r += rot.roll();
                            p += rot.pitch();
                            y += rot.yaw();
                        }
                        state = state.getParent();
                    }
                    this._cachedRotation = new EulerAngle(y, p, r);
                }
                if (this.rotationOrder != null) {
                    for (String r : this.rotationOrder) {
                        if (r == null) continue;
                        if (r.equalsIgnoreCase("-roll")) {
                            this.doRoll(-roll);
                            continue;
                        }
                        if (r.equalsIgnoreCase("-pitch")) {
                            this.doPitch(-pitch);
                            continue;
                        }
                        if (r.equalsIgnoreCase("-yaw")) {
                            this.doYaw(-yaw);
                            continue;
                        }
                        if (r.equalsIgnoreCase("roll")) {
                            this.doRoll(roll);
                            continue;
                        }
                        if (r.equalsIgnoreCase("pitch")) {
                            this.doPitch(pitch);
                            continue;
                        }
                        if (!r.equalsIgnoreCase("yaw")) continue;
                        this.doYaw(yaw);
                    }
                }
                if (this.offset != null) {
                    GL11.glTranslated((double)this.offset.x(), (double)this.offset.y(), (double)this.offset.z());
                } else if (this.parentState instanceof IModelState && ((IModelState)this.parentState).getOffset() != null) {
                    GL11.glTranslated((double)((IModelState)this.parentState).getOffset().x(), (double)((IModelState)this.parentState).getOffset().y(), (double)((IModelState)this.parentState).getOffset().z());
                }
            }
            GL11.glPushMatrix();
            if (this.parentState instanceof IModelState) {
                if (this.renderParent) {
                    ((IModelState)this.parentState).render(true);
                } else if (this.parts == null && this.parentState instanceof ModelState && ((ModelState)this.parentState).renderParent && ((ModelState)this.parentState).parentState instanceof IModelState) {
                    ((IModelState)((ModelState)this.parentState).parentState).render(true);
                }
            }
            GL11.glPopMatrix();
            if (textureData != null) {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(textureData.getLocation());
            } else {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(SharedAssets.GREY_TEXTURE);
            }
            modelData.render(this.renderOnlyParts(), this.getPartsToRender());
            GL11.glPopMatrix();
            return true;
        }
        return false;
    }

    private void doRoll(float extra) {
        float roll = extra;
        if (this._cachedRotation != null) {
            roll = (float)((double)roll + this._cachedRotation.roll());
        } else if (this.rotation != null) {
            roll = (float)((double)roll + this.rotation.roll());
        } else if (this.parentState instanceof IModelState && ((IModelState)this.parentState).getRotation() != null) {
            roll = (float)((double)roll + ((IModelState)this.parentState).getRotation().roll());
        }
        GL11.glRotated((double)MathHelper.clampAngleTo360((float)roll), (double)0.0, (double)0.0, (double)1.0);
    }

    private void doPitch(float extra) {
        float pitch = extra;
        if (this._cachedRotation != null) {
            pitch = (float)((double)pitch + this._cachedRotation.pitch());
        } else if (this.rotation != null) {
            pitch = (float)((double)pitch + this.rotation.pitch());
        } else if (this.parentState instanceof IModelState && ((IModelState)this.parentState).getRotation() != null) {
            pitch = (float)((double)pitch + ((IModelState)this.parentState).getRotation().pitch());
        }
        GL11.glRotated((double)MathHelper.clampAngleTo360((float)pitch), (double)1.0, (double)0.0, (double)0.0);
    }

    private void doYaw(float extra) {
        float yaw = extra;
        if (this._cachedRotation != null) {
            yaw = (float)((double)yaw + this._cachedRotation.yaw());
        } else if (this.rotation != null) {
            yaw = (float)((double)yaw + this.rotation.yaw());
        } else if (this.parentState instanceof IModelState && ((IModelState)this.parentState).getRotation() != null) {
            yaw = (float)((double)yaw + ((IModelState)this.parentState).getRotation().yaw());
        }
        GL11.glRotated((double)MathHelper.clampAngleTo360((float)yaw), (double)0.0, (double)1.0, (double)0.0);
    }

    @Override
    public Pos getScale() {
        if (this.scale == null) {
            return this.parentState instanceof IModelState ? ((IModelState)this.parentState).getScale() : null;
        }
        if (this.parentState instanceof IModelState) {
            // empty if block
        }
        return this.scale;
    }

    @Override
    public Pos getOffset() {
        if (this.offset == null) {
            return this.parentState instanceof IModelState ? ((IModelState)this.parentState).getOffset() : null;
        }
        if (this.parentState instanceof IModelState) {
            // empty if block
        }
        return this.offset;
    }

    @Override
    public EulerAngle getRotation() {
        if (this.rotation == null) {
            return this.parentState instanceof IModelState ? ((IModelState)this.parentState).getRotation() : null;
        }
        if (this.parentState instanceof IModelState) {
            // empty if block
        }
        return this.rotation;
    }

    @Override
    public ModelData getModel() {
        ModelData data = ClientDataHandler.INSTANCE.getModel(this.modelID);
        if (data != null && data.getModel() != null) {
            return data;
        }
        if (this.parentState instanceof IModelState) {
            return ((IModelState)this.parentState).getModel();
        }
        return null;
    }

    @Override
    public String[] getPartsToRender() {
        if (this.parentState instanceof IModelState && (this.parts == null || this.parts.length == 0)) {
            return ((IModelState)this.parentState).getPartsToRender();
        }
        return this.parts;
    }

    public boolean renderOnlyParts() {
        if (this.parts == null && this.parentState instanceof ModelState) {
            return ((ModelState)this.parentState).renderOnlyParts();
        }
        return this.renderOnlyParts;
    }

    @Override
    public TextureData getTexture() {
        TextureData textureData = ClientDataHandler.INSTANCE.getTexture(this.getTextureID());
        if (textureData == null && this.parentState instanceof IModelState) {
            return ((IModelState)this.parentState).getTexture();
        }
        return textureData;
    }

    @Override
    public void addDebugLines(List<String> lines) {
        super.addDebugLines(lines);
        lines.add("Model ID = " + this.modelID);
        lines.add("Model = " + this.getModel());
    }

    @Override
    public String toString() {
        return "RenderStateModel[" + this.id + "]@" + this.hashCode();
    }
}

