/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.commands.debug;

import com.builtbroken.mc.core.commands.prefab.SubCommand;
import com.builtbroken.mc.lib.world.map.radar.RadarMap;
import com.builtbroken.mc.lib.world.map.radar.data.RadarObject;
import com.builtbroken.mc.lib.world.map.tile.TileMapRegistry;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandDebugMap
extends SubCommand {
    public CommandDebugMap() {
        super("map");
    }

    @Override
    public boolean handleEntityPlayerCommand(EntityPlayer player, String[] args) {
        if (args != null && args.length > 0 && !"help".equalsIgnoreCase(args[0]) && !args[0].equalsIgnoreCase("radar")) {
            if (args[0].equalsIgnoreCase("tile") && args.length > 1) {
                if (args[1].equalsIgnoreCase("enableDebug")) {
                    if (args.length > 2) {
                        RadarMap map = TileMapRegistry.getRadarMapForWorld(player.field_70170_p);
                        if (args[2].equalsIgnoreCase("true") || args[2].equalsIgnoreCase("t")) {
                            map.setDebugEnabled(true);
                            player.func_146105_b((IChatComponent)new ChatComponentText("Debug enabled for tile map in your world."));
                        } else if (args[2].equalsIgnoreCase("false") || args[2].equalsIgnoreCase("f")) {
                            map.setDebugEnabled(false);
                            player.func_146105_b((IChatComponent)new ChatComponentText("Debug disabled for tile map in your world."));
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Could not parse [" + args[2] + "], enable status can only be true or false"));
                        }
                        return true;
                    }
                    RadarMap map = TileMapRegistry.getRadarMapForWorld(player.field_70170_p);
                    if (!map.debugRadarMap) {
                        map.setDebugEnabled(true);
                        player.func_146105_b((IChatComponent)new ChatComponentText("Debug enabled for tile map in your world."));
                    } else {
                        map.setDebugEnabled(false);
                        player.func_146105_b((IChatComponent)new ChatComponentText("Debug disabled for tile map in your world."));
                    }
                    return true;
                }
                if (args[1].equalsIgnoreCase("objects")) {
                    RadarMap map = TileMapRegistry.getRadarMapForWorld(player.field_70170_p);
                    if (map.allEntities.size() > 0) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("There are " + map.allEntities.size() + " tiles in the map."));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("No tiles detected in global tile list."));
                    }
                    return true;
                }
                if (args[1].equalsIgnoreCase("chunks")) {
                    RadarMap map = TileMapRegistry.getRadarMapForWorld(player.field_70170_p);
                    if (map.chunk_to_entities.size() > 0) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("There are " + map.chunk_to_entities.size() + " chunk locations in the map."));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("No chunks detected in map."));
                    }
                    return true;
                }
                if (args[1].equalsIgnoreCase("around")) {
                    RadarMap map;
                    List<RadarObject> list;
                    int range = 100;
                    if (args.length > 2) {
                        try {
                            range = Integer.parseInt(args[2]);
                        }
                        catch (NumberFormatException e) {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Invalid range number"));
                            return true;
                        }
                    }
                    if ((list = (map = TileMapRegistry.getRadarMapForWorld(player.field_70170_p)).getRadarObjects(player.field_70165_t, player.field_70161_v, range)).size() > 0) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("There are " + list.size() + " tiles within " + range + " meters"));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("No tiles detected in within " + range + " meters"));
                    }
                    return true;
                }
                return this.handleHelp((ICommandSender)player, args);
            }
            if (args[0].equalsIgnoreCase("heat")) {
                // empty if block
            }
        }
        return this.handleHelp((ICommandSender)player, args);
    }

    @Override
    public boolean handleConsoleCommand(ICommandSender sender, String[] args) {
        return false;
    }

    @Override
    public void getHelpOutput(ICommandSender sender, List<String> items) {
        items.add("tile enableDebug <true/false> - toggles console debug");
        items.add("tile around [range] - number of tiles nearby");
        items.add("tile chunks - outputs number of chunks mapped");
        items.add("tile objects - outputs number of tiles mapped");
    }
}

