/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.commands.sub;

import com.builtbroken.jlib.lang.StringHelpers;
import com.builtbroken.mc.core.commands.prefab.SubCommand;
import com.builtbroken.mc.prefab.entity.selector.EntitySelector;
import com.builtbroken.mc.prefab.entity.selector.EntitySelectors;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class CommandVERemove
extends SubCommand {
    public CommandVERemove() {
        super("remove");
    }

    private EntitySelector getSelector(String name) {
        if (name.equalsIgnoreCase("projectiles")) {
            return EntitySelectors.PROJECTILE_SELECTOR.selector();
        }
        if (name.equalsIgnoreCase("mobs")) {
            return EntitySelectors.MOB_SELECTOR.selector();
        }
        if (name.equalsIgnoreCase("living")) {
            return EntitySelectors.LIVING_SELECTOR.selector();
        }
        if (name.equalsIgnoreCase("items")) {
            return EntitySelectors.ITEM_SELECTOR.selector();
        }
        if (name.equalsIgnoreCase("xp")) {
            return EntitySelectors.XP_SELECTOR.selector();
        }
        return null;
    }

    @Override
    public boolean handleEntityPlayerCommand(EntityPlayer entityPlayer, String[] args) {
        if (args.length > 0) {
            int radius = 100;
            EntitySelector selector = this.getSelector(args[0]);
            if (selector == null) {
                return false;
            }
            if (args.length > 1 && args[1] != null) {
                try {
                    radius = Integer.parseInt(args[1]);
                    if (radius > 1000) {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("To prevent lag/crashes radius is limited to 1000"));
                        return true;
                    }
                    if (radius < 1) {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Radius needs to be positive"));
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Radius needs to be an integer"));
                    return true;
                }
            }
            if (selector != null) {
                List<Entity> list = selector.getEntities((Entity)entityPlayer, (double)radius);
                for (Entity entity : list) {
                    entity.func_70106_y();
                }
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Removed " + list.size() + " " + args[0] + " entities within " + radius + " block radius"));
            } else {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Error unknown selector"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleConsoleCommand(ICommandSender sender, String[] args) {
        WorldServer world;
        long time = System.nanoTime();
        int dim = 0;
        EntitySelector selector = this.getSelector(args[0]);
        if (selector == null) {
            return false;
        }
        if (args != null && args.length > 1) {
            if (args[1].startsWith("dim")) {
                try {
                    dim = Integer.parseInt(args[1].replace("dim", ""));
                }
                catch (NumberFormatException e) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Dim id needs to be an int"));
                    return true;
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Right now only /ve butcher dim[#] is supported, ex /ve butcher dim0"));
                return true;
            }
        }
        if ((world = DimensionManager.getWorld((int)dim)) != null) {
            int entitiesKilled = 0;
            int chunksSearched = 0;
            ChunkProviderServer provider = world.field_73059_b;
            for (Object object : provider.field_73245_g) {
                if (!(object instanceof Chunk)) continue;
                ++chunksSearched;
                for (List l : ((Chunk)object).field_76645_j) {
                    if (!(l instanceof Collection)) continue;
                    for (Object e : (Collection)l) {
                        if (!(e instanceof Entity) || !((Entity)e).func_70089_S() || !selector.func_82704_a((Entity)e)) continue;
                        ((Entity)e).func_70106_y();
                        ++entitiesKilled;
                    }
                }
            }
            time = System.nanoTime() - time;
            sender.func_145747_a((IChatComponent)new ChatComponentText("Removed " + entitiesKilled + " entities over " + chunksSearched + " chunks in " + StringHelpers.formatNanoTime((long)time)));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText("World doesn't exist, this means it unloaded or the wrong id was provided."));
        }
        return true;
    }

    @Override
    public boolean isHelpCommand(String[] args) {
        return args.length > 0 && (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?"));
    }

    @Override
    public void getHelpOutput(ICommandSender sender, List<String> items) {
        items.add("projectiles <radius>");
        items.add("mobs <radius>");
        items.add("living <radius>");
        items.add("items <radius>");
        items.add("xp <radius>");
    }
}

