/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.IPacketReceiver;
import com.builtbroken.mc.core.network.ex.PacketIDException;
import com.builtbroken.mc.core.network.ex.PacketTileReadException;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.imp.transform.vector.Location;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class PacketGui
extends PacketType {
    public PacketGui() {
    }

    public PacketGui(Object ... args) {
        super(args);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeBytes(this.data());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.data_$eq(buffer.slice());
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        Location location = new Location((Entity)player);
        if (screen instanceof IPacketIDReceiver) {
            if (((IPacketIDReceiver)screen).shouldReadPacket(player, location, this)) {
                try {
                    int id;
                    IPacketIDReceiver receiver = (IPacketIDReceiver)screen;
                    ByteBuf buf = this.data().slice();
                    try {
                        id = buf.readInt();
                    }
                    catch (IndexOutOfBoundsException ex) {
                        Engine.logger().error((Object)new PacketIDException(location));
                        return;
                    }
                    receiver.read(buf, id, player, this);
                }
                catch (IndexOutOfBoundsException e) {
                    Engine.logger().error((Object)new PacketTileReadException(location, "Packet was read past it's size."));
                    Engine.logger().error("Error: ", (Throwable)e);
                }
                catch (NullPointerException e) {
                    Engine.logger().error((Object)new PacketTileReadException(location, "Null pointer while reading data", e));
                    Engine.logger().error("Error: ", (Throwable)e);
                }
                catch (Exception e) {
                    Engine.logger().error((Object)new PacketTileReadException(location, "Failed to read packet", e));
                    Engine.logger().error("Error: ", (Throwable)e);
                }
            } else {
                Engine.logger().error("Error: " + screen + " rejected packet " + this + " due to invalid conditions.");
            }
        } else if (screen instanceof IPacketReceiver) {
            if (((IPacketReceiver)screen).shouldReadPacket(player, location, this)) {
                try {
                    IPacketReceiver receiver = (IPacketReceiver)screen;
                    receiver.read(this.data().slice(), player, this);
                }
                catch (IndexOutOfBoundsException e) {
                    Engine.logger().error((Object)new PacketTileReadException(location, "Packet was read past it's size."));
                }
                catch (Exception e) {
                    Engine.logger().error((Object)new PacketTileReadException(location, "Failed to read packet", e));
                    e.printStackTrace();
                }
            } else {
                Engine.logger().error("Error: " + screen + " rejected packet " + this + " due to invalid conditions.");
            }
        } else {
            Engine.logger().error((Object)new PacketTileReadException(location, "Unsupported action for " + screen));
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        Container container = player.field_71070_bA;
        Location location = new Location((Entity)player);
        if (container instanceof IPacketIDReceiver) {
            if (((IPacketIDReceiver)container).shouldReadPacket(player, location, this)) {
                try {
                    int id;
                    IPacketIDReceiver receiver = (IPacketIDReceiver)container;
                    ByteBuf buf = this.data().slice();
                    try {
                        id = buf.readInt();
                    }
                    catch (IndexOutOfBoundsException ex) {
                        Engine.logger().error((Object)new PacketIDException(location));
                        return;
                    }
                    receiver.read(buf, id, player, this);
                }
                catch (IndexOutOfBoundsException e) {
                    Engine.logger().error((Object)new PacketTileReadException(location, "Packet was read past it's size."));
                    Engine.logger().error("Error: ", (Throwable)e);
                }
                catch (NullPointerException e) {
                    Engine.logger().error((Object)new PacketTileReadException(location, "Null pointer while reading data", e));
                    Engine.logger().error("Error: ", (Throwable)e);
                }
                catch (Exception e) {
                    Engine.logger().error((Object)new PacketTileReadException(location, "Failed to read packet", e));
                    Engine.logger().error("Error: ", (Throwable)e);
                }
            } else {
                Engine.logger().error("Error: " + container + " rejected packet " + this + " due to invalid conditions.");
            }
        } else if (container instanceof IPacketReceiver) {
            if (((IPacketReceiver)container).shouldReadPacket(player, location, this)) {
                try {
                    IPacketReceiver receiver = (IPacketReceiver)container;
                    receiver.read(this.data().slice(), player, this);
                }
                catch (IndexOutOfBoundsException e) {
                    Engine.logger().error((Object)new PacketTileReadException(location, "Packet was read past it's size."));
                }
                catch (Exception e) {
                    Engine.logger().error((Object)new PacketTileReadException(location, "Failed to read packet", e));
                    e.printStackTrace();
                }
            } else {
                Engine.logger().error("Error: " + container + " rejected packet " + this + " due to invalid conditions.");
            }
        } else {
            Engine.logger().error((Object)new PacketTileReadException(location, "Unsupported action for " + container));
        }
    }
}

