/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet;

import com.builtbroken.mc.client.effects.VisualEffectProvider;
import com.builtbroken.mc.client.effects.VisualEffectRegistry;
import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.imp.IEffectData;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketType;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PacketSpawnParticle
extends PacketType {
    String name;
    public int dim;
    public double x;
    public double y;
    public double z;
    public double vx;
    public double vy;
    public double vz;
    public NBTTagCompound otherData;
    public boolean endPoint = false;

    public PacketSpawnParticle() {
    }

    public PacketSpawnParticle(String name, World world, double x, double y, double z, double vx, double vy, double vz) {
        this(name, world.field_73011_w.field_76574_g, x, y, z, vx, vy, vz);
    }

    public PacketSpawnParticle(String name, int dim, double x, double y, double z, double vx, double vy, double vz) {
        if (name == null && Engine.runningAsDev) {
            Engine.logger().error("PacketSpawnParticle >> Something created a packet with a null packet name", (Throwable)new RuntimeException());
        }
        this.name = name;
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)(this.name == null ? "null" : this.name));
        buffer.writeInt(this.dim);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeDouble(this.vx);
        buffer.writeDouble(this.vy);
        buffer.writeDouble(this.vz);
        buffer.writeBoolean(this.endPoint);
        buffer.writeBoolean(this.otherData != null);
        if (this.otherData != null) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.otherData);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.dim = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.vx = buffer.readDouble();
        this.vy = buffer.readDouble();
        this.vz = buffer.readDouble();
        this.endPoint = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.otherData = ByteBufUtils.readTag((ByteBuf)buffer);
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (player.field_70170_p.field_73011_w.field_76574_g == this.dim) {
            try {
                if (this.name.startsWith("JSON_")) {
                    String key = this.name.substring(5, this.name.length()).toLowerCase();
                    IEffectData data = ClientDataHandler.INSTANCE.getEffect(key);
                    if (data != null) {
                        data.trigger(player.func_130014_f_(), this.x, this.y, this.z, this.vx, this.vy, this.vz, this.endPoint, this.otherData != null ? this.otherData : new NBTTagCompound());
                    } else if (Engine.runningAsDev) {
                        Engine.logger().error("Failed to find a effect data for key '" + this.name + "'");
                    }
                } else if (this.name.startsWith("VEP_")) {
                    String key = this.name.substring(4, this.name.length());
                    VisualEffectProvider provider = VisualEffectRegistry.main.get(key);
                    if (provider != null) {
                        provider.displayEffect(player.func_130014_f_(), this.x, this.y, this.z, this.vx, this.vy, this.vz, this.endPoint, this.otherData != null ? this.otherData : new NBTTagCompound());
                    } else if (Engine.runningAsDev) {
                        Engine.logger().error("Failed to find a visual effect provider for name '" + this.name + "'");
                    }
                } else {
                    player.field_70170_p.func_72869_a(this.name, this.x, this.y, this.z, this.vx, this.vy, this.vz);
                }
            }
            catch (Exception e) {
                Engine.logger().error("Failed handling particle spawn packet with [name=" + this.name + ", dim=" + this.dim + ",pos=" + this.x + ", " + this.y + ", " + this.z + ", Vel=" + this.vx + ", " + this.vy + ", " + this.vz + "]", (Throwable)e);
            }
        }
    }
}

