/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.debug.gui.panels.json;

import com.builtbroken.jlib.debug.IDebugPrintListener;
import com.builtbroken.mc.debug.component.DebugDataCellRenderer;
import com.builtbroken.mc.debug.data.DebugData;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PanelJsonConsole
extends JPanel {
    JList dataLogList;
    List<DebugData> debugData = new ArrayList<DebugData>();
    DefaultListModel<DebugData> debugDataListModel = new DefaultListModel();

    public PanelJsonConsole() {
        this.setLayout(new BorderLayout());
        this.addDebug("======================================", new String[0]);
        this.addDebug("=========JSON debug list==============", new String[0]);
        this.addDebug("======================================", new String[0]);
        this.dataLogList = new JList<DebugData>(this.debugDataListModel);
        this.dataLogList.setLayoutOrientation(0);
        this.dataLogList.setCellRenderer(new DebugDataCellRenderer());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.dataLogList);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setPreferredSize(new Dimension(this.getWidth() - 100, this.getHeight() - 100));
        scrollPane.setMinimumSize(new Dimension(this.getWidth() - 100, this.getHeight() - 100));
        this.add((Component)scrollPane, "Center");
        JPanel menuPanel = new JPanel();
        menuPanel.setMaximumSize(new Dimension(-1, 100));
        Button button = new Button("Reload");
        button.addActionListener(e -> this.reloadDebugData(null));
        menuPanel.add(button);
        JTextField searchBox = new JTextField();
        searchBox.setMinimumSize(new Dimension(200, -1));
        searchBox.setPreferredSize(new Dimension(200, 30));
        searchBox.setToolTipText("Search filter");
        menuPanel.add(searchBox);
        button = new Button("Search");
        button.addActionListener(e -> this.reloadDebugData(searchBox.getText().trim()));
        menuPanel.add(button);
        this.add((Component)menuPanel, "North");
    }

    public void reloadDebugData(String filter) {
        this.debugDataListModel.removeAllElements();
        for (DebugData data : this.debugData) {
            if (filter != null && !filter.isEmpty() && !data.msg.contains(filter)) continue;
            this.debugDataListModel.addElement(data);
        }
    }

    public void addDebug(String msg, String ... lines) {
        DebugData data = new DebugData();
        data.msg = msg;
        data.lines = lines;
        this.debugDataListModel.addElement(data);
        this.debugData.add(data);
    }

    public static class DebugListener
    implements IDebugPrintListener {
        PanelJsonConsole window;

        public DebugListener(PanelJsonConsole window) {
            this.window = window;
        }

        public void onMessage(String msg, String prefix, String spacer, boolean error) {
            StringBuilder builder = new StringBuilder();
            if (error) {
                builder.append("[Error]");
            } else {
                builder.append("[Info]");
            }
            builder.append(spacer);
            builder.append(prefix);
            builder.append(msg);
            this.window.addDebug(builder.toString(), new String[0]);
        }

        public void onMessageWithError(String msg, String prefix, String spacer, Throwable e) {
            this.onMessage(msg, prefix, spacer, true);
            String error = this.toString(e);
            String[] array = error.split("\n");
            this.window.addDebug(e.toString(), Arrays.copyOfRange(array, 1, array.length));
        }

        public String toString(Throwable t) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            return writer.toString();
        }
    }
}

