/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.explosive;

import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.event.TriggerCauseRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerNBTBuilder
implements TriggerCauseRegistry.TriggerNBTBuilder {
    public final String id;

    public TriggerNBTBuilder(String id) {
        this.id = id;
    }

    @Override
    public TriggerCause buildCause(NBTTagCompound tag, World world) {
        switch (this.id) {
            case "fire": {
                return new TriggerCause.TriggerCauseFire(ForgeDirection.getOrientation((int)tag.func_74771_c("side")));
            }
            case "redstone": {
                return new TriggerCause.TriggerCauseRedstone(ForgeDirection.getOrientation((int)tag.func_74771_c("side")), tag.func_74762_e("str"));
            }
            case "explosion": {
                Entity source = this.toEntity(tag.func_74775_l("source"), world);
                double xx = tag.func_74769_h("xx");
                double yy = tag.func_74769_h("yy");
                double zz = tag.func_74769_h("zz");
                float size = tag.func_74760_g("float");
                return new TriggerCause.TriggerCauseExplosion(new Explosion(world, source, xx, yy, zz, size));
            }
            case "entityImpactEntity": {
                Entity source2 = this.toEntity(tag.func_74775_l("source"), world);
                Entity entityHit = this.toEntity(tag.func_74775_l("hit"), world);
                float vel = tag.func_74760_g("vel");
                return new TriggerCause.TriggerEntityImpact(entityHit, source2, vel);
            }
            case "entityImpactBlock": {
                Entity source3 = this.toEntity(tag.func_74775_l("source"), world);
                float vel2 = tag.func_74760_g("vel");
                Block block = Block.func_149729_e((int)tag.func_74762_e("block"));
                return new TriggerCause.TriggerBlockImpact(block, source3, vel2);
            }
            case "entityImpact": {
                Entity source4 = this.toEntity(tag.func_74775_l("source"), world);
                float vel3 = tag.func_74760_g("vel");
                return new TriggerCause.TriggerCauseImpact(source4, vel3);
            }
            case "entity": {
                Entity source5 = this.toEntity(tag.func_74775_l("source"), world);
                return new TriggerCause.TriggerCauseEntity(source5);
            }
        }
        return null;
    }

    @Override
    public NBTTagCompound cache(NBTTagCompound tag, TriggerCause cause) {
        if (cause instanceof TriggerCause.TriggerCauseFire) {
            tag.func_74774_a("side", (byte)((TriggerCause.TriggerCauseFire)cause).triggeredSide.ordinal());
        } else if (cause instanceof TriggerCause.TriggerCauseRedstone) {
            tag.func_74774_a("side", (byte)((TriggerCause.TriggerCauseRedstone)cause).triggeredSide.ordinal());
            tag.func_74768_a("str", ((TriggerCause.TriggerCauseRedstone)cause).strength);
        } else if (cause instanceof TriggerCause.TriggerCauseExplosion) {
            tag.func_74782_a("source", (NBTBase)this.toNBT(((TriggerCause.TriggerCauseExplosion)cause).source.field_77283_e));
            tag.func_74780_a("xx", ((TriggerCause.TriggerCauseExplosion)cause).source.field_77284_b);
            tag.func_74780_a("yy", ((TriggerCause.TriggerCauseExplosion)cause).source.field_77284_b);
            tag.func_74780_a("zz", ((TriggerCause.TriggerCauseExplosion)cause).source.field_77284_b);
            tag.func_74776_a("size", ((TriggerCause.TriggerCauseExplosion)cause).source.field_77280_f);
        } else if (cause instanceof TriggerCause.TriggerEntityImpact) {
            tag.func_74782_a("source", (NBTBase)this.toNBT(((TriggerCause.TriggerEntityImpact)cause).source));
            tag.func_74782_a("hit", (NBTBase)this.toNBT(((TriggerCause.TriggerEntityImpact)cause).entityHit));
            tag.func_74776_a("vel", ((TriggerCause.TriggerEntityImpact)cause).velocity);
        } else if (cause instanceof TriggerCause.TriggerBlockImpact) {
            tag.func_74782_a("source", (NBTBase)this.toNBT(((TriggerCause.TriggerBlockImpact)cause).source));
            tag.func_74768_a("block", Block.func_149682_b((Block)((TriggerCause.TriggerBlockImpact)cause).impactBlock));
            tag.func_74776_a("vel", ((TriggerCause.TriggerBlockImpact)cause).velocity);
        } else if (cause instanceof TriggerCause.TriggerCauseImpact) {
            tag.func_74782_a("source", (NBTBase)this.toNBT(((TriggerCause.TriggerCauseImpact)cause).source));
            tag.func_74776_a("vel", ((TriggerCause.TriggerCauseImpact)cause).velocity);
        } else if (cause instanceof TriggerCause.TriggerCauseEntity) {
            tag.func_74782_a("source", (NBTBase)this.toNBT(((TriggerCause.TriggerCauseEntity)cause).source));
        }
        return tag;
    }

    private NBTTagCompound toNBT(Entity entity) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("id", entity.func_145782_y());
        return tag;
    }

    private Entity toEntity(NBTTagCompound tag, World world) {
        int id = tag.func_74762_e("id");
        return world.func_73045_a(id);
    }
}

