/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.conversion.data.mc;

import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class JsonConverterNBT
extends JsonConverter<NBTTagCompound> {
    public JsonConverterNBT() {
        super("nbt", new String[0]);
    }

    @Override
    public NBTTagCompound convert(JsonElement element, String ... args) {
        return JsonConverterNBT.handle(element);
    }

    public static NBTTagCompound handle(JsonElement element) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (element instanceof JsonObject) {
            JsonConverterNBT.handle((JsonObject)element, nbt, 0);
        }
        return nbt;
    }

    public static void handle(JsonObject object, NBTTagCompound nbt, int depth) {
        for (Map.Entry entry : object.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (entry.getValue() instanceof JsonObject) {
                NBTTagCompound tag = new NBTTagCompound();
                JsonConverterNBT.handle((JsonObject)entry.getValue(), tag, depth++);
                nbt.func_74782_a(entryKey, (NBTBase)tag);
                continue;
            }
            if (entry.getValue() instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)entry.getValue();
                if (primitive.isNumber()) {
                    String[] split = entryKey.split(":");
                    String key = split[0];
                    String type = split[1].toLowerCase();
                    if (type.equals("int") || type.equals("integer")) {
                        nbt.func_74768_a(key, primitive.getAsInt());
                        continue;
                    }
                    if (type.equals("byte")) {
                        nbt.func_74774_a(key, primitive.getAsByte());
                        continue;
                    }
                    if (type.equals("short")) {
                        nbt.func_74777_a(key, primitive.getAsShort());
                        continue;
                    }
                    if (type.equals("double")) {
                        nbt.func_74780_a(key, primitive.getAsDouble());
                        continue;
                    }
                    if (type.equals("float")) {
                        nbt.func_74776_a(key, primitive.getAsFloat());
                        continue;
                    }
                    if (type.equals("long")) {
                        nbt.func_74772_a(key, primitive.getAsLong());
                        continue;
                    }
                    throw new RuntimeException("Unknown number type for " + type + " while reading " + object);
                }
                if (primitive.isBoolean()) {
                    nbt.func_74757_a((String)entry.getKey(), primitive.getAsBoolean());
                    continue;
                }
                if (!primitive.isString()) continue;
                nbt.func_74778_a((String)entry.getKey(), primitive.getAsString());
                continue;
            }
            if (entry.getValue() instanceof JsonArray) {
                JsonArray array = (JsonArray)entry.getValue();
                if (array.size() <= 0) continue;
                JsonElement element = array.get(0);
                if (element instanceof JsonPrimitive) {
                    JsonPrimitive p;
                    int i;
                    Object[] ar;
                    String[] split = ((String)entry.getKey()).split(":");
                    String key = split[0];
                    String type = split[1].toLowerCase();
                    if (type.equals("int") || type.equals("integer")) {
                        ar = new int[array.size()];
                        for (i = 0; i < array.size(); ++i) {
                            p = array.get(i).getAsJsonPrimitive();
                            ar[i] = p.getAsInt();
                        }
                        nbt.func_74783_a(key, ar);
                        continue;
                    }
                    if (type.equals("byte")) {
                        ar = new byte[array.size()];
                        for (i = 0; i < array.size(); ++i) {
                            p = array.get(i).getAsJsonPrimitive();
                            ar[i] = p.getAsByte();
                        }
                        nbt.func_74773_a(key, (byte[])ar);
                        continue;
                    }
                    throw new RuntimeException("Unsupported type of " + type + " for array read");
                }
                if (!(element instanceof JsonObject)) continue;
                NBTTagList list = new NBTTagList();
                for (int i = 0; i < array.size(); ++i) {
                    NBTTagCompound tag = new NBTTagCompound();
                    JsonConverterNBT.handle((JsonObject)array.get(i), tag, depth++);
                    list.func_74742_a((NBTBase)tag);
                }
                nbt.func_74782_a((String)entry.getKey(), (NBTBase)list);
                continue;
            }
            throw new RuntimeException("Unknown type to convert to NBT -> " + entry.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static JsonElement toJson(NBTTagCompound nbt) {
        if (nbt != null && !nbt.func_82582_d()) {
            JsonObject object = new JsonObject();
            Set set = nbt.func_150296_c();
            for (Object s : set) {
                JsonArray array;
                if (!(s instanceof String)) continue;
                String key = (String)s;
                NBTBase tag = nbt.func_74781_a(key);
                if (tag instanceof NBTTagByte) {
                    object.add(key + ":byte", (JsonElement)new JsonPrimitive((Number)((NBTTagByte)tag).func_150290_f()));
                    continue;
                }
                if (tag instanceof NBTTagShort) {
                    object.add(key + ":short", (JsonElement)new JsonPrimitive((Number)((NBTTagShort)tag).func_150289_e()));
                    continue;
                }
                if (tag instanceof NBTTagInt) {
                    object.add(key + ":int", (JsonElement)new JsonPrimitive((Number)((NBTTagInt)tag).func_150287_d()));
                    continue;
                }
                if (tag instanceof NBTTagLong) {
                    object.add(key + ":long", (JsonElement)new JsonPrimitive((Number)((NBTTagLong)tag).func_150291_c()));
                    continue;
                }
                if (tag instanceof NBTTagFloat) {
                    object.add(key + ":float", (JsonElement)new JsonPrimitive((Number)Float.valueOf(((NBTTagFloat)tag).func_150288_h())));
                    continue;
                }
                if (tag instanceof NBTTagDouble) {
                    object.add(key + ":double", (JsonElement)new JsonPrimitive((Number)((NBTTagDouble)tag).func_150286_g()));
                    continue;
                }
                if (tag instanceof NBTTagByteArray) {
                    array = new JsonArray();
                    for (int b : ((NBTTagByteArray)tag).func_150292_c()) {
                        array.add((JsonElement)new JsonPrimitive((Number)((byte)b)));
                    }
                    object.add(key + ":byte", (JsonElement)array);
                    continue;
                }
                if (tag instanceof NBTTagString) {
                    object.add(key, (JsonElement)new JsonPrimitive(((NBTTagString)tag).func_150285_a_()));
                    continue;
                }
                if (tag instanceof NBTTagList) {
                    void var8_10;
                    array = new JsonArray();
                    boolean bl = false;
                    while (var8_10 < ((NBTTagList)tag).func_74745_c()) {
                        array.add(JsonConverterNBT.toJson(((NBTTagList)tag).func_150305_b((int)var8_10)));
                        ++var8_10;
                    }
                    object.add(key, (JsonElement)array);
                    continue;
                }
                if (tag instanceof NBTTagCompound) {
                    object.add(key, JsonConverterNBT.toJson((NBTTagCompound)tag));
                    continue;
                }
                if (!(tag instanceof NBTTagIntArray)) continue;
                array = new JsonArray();
                for (int b : ((NBTTagIntArray)tag).func_150302_c()) {
                    array.add((JsonElement)new JsonPrimitive((Number)b));
                }
                object.add(key + ":int", (JsonElement)array);
            }
            return object;
        }
        return new JsonPrimitive("");
    }
}

