/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.conversion.structures.arrays;

import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;

public class JsonConverterStringArray
extends JsonConverter<String[]> {
    public JsonConverterStringArray() {
        super("array.string", new String[0]);
    }

    @Override
    public String[] convert(JsonElement element, String ... args) {
        if (element instanceof JsonArray) {
            String[] array = new String[element.getAsJsonArray().size()];
            int index = 0;
            for (JsonElement e : element.getAsJsonArray()) {
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
                    array[index++] = e.getAsString().trim();
                    continue;
                }
                throw new IllegalArgumentException("Can not convert object to string array, as '" + e + "' is not a string");
            }
            return array;
        }
        return null;
    }
}

