/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.data;

import com.builtbroken.mc.framework.item.ItemBase;
import com.builtbroken.mc.framework.item.ItemNodeSubType;
import com.builtbroken.mc.framework.json.imp.IJSONMetaConvert;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class JsonItemEntry {
    public String item;
    public String damage;
    public int count = 1;
    public NBTTagCompound nbt;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack get() {
        if (this.item == null || this.item.isEmpty()) return null;
        int meta = -1;
        if (this.damage != null && !this.damage.isEmpty()) {
            try {
                meta = Integer.parseInt(this.damage);
                if (meta < 0) {
                    throw new IllegalArgumentException("RecipeItemEntry: damage value must be zero or more.");
                }
                if (meta >= 32000) {
                    throw new IllegalArgumentException("RecipeItemEntry: damage value must be less than 32,000.");
                }
            }
            catch (NumberFormatException e) {
                meta = -2;
            }
        }
        Object object = null;
        if (this.item.contains("@")) {
            String id;
            if (this.item.startsWith("ore")) {
                throw new IllegalArgumentException("RecipeItemEntry: does not support ore dictionary values");
            }
            if (this.item.startsWith("item@")) {
                id = this.item.substring(5, this.item.length());
                object = Item.field_150901_e.func_82594_a(id);
            } else if (this.item.startsWith("block@") && (object = Block.field_149771_c.func_82594_a(id = this.item.substring(6, this.item.length()))) == Blocks.field_150350_a) {
                return null;
            }
        } else {
            object = Item.field_150901_e.func_82594_a(this.item);
            if (object == null) {
                object = Block.field_149771_c.func_82594_a(this.item);
            }
        }
        if (object == null) return null;
        if (meta == -2) {
            if (object instanceof IJSONMetaConvert) {
                meta = ((IJSONMetaConvert)object).getMetaForValue(this.damage);
                if (meta == -1) {
                    return null;
                }
            } else {
                if (!(object instanceof ItemBase) || !((ItemBase)object).node.hasSubTypes()) throw new IllegalArgumentException("RecipeItemEntry: item is not an instanceof IJSONMetaConvert. Due to this damage value could not be converted. This could either mean the system is not supported or the value entered could not be parsed as a number. If the last is the case fix the JSON. If the first is the case then ask for support");
                ItemNodeSubType type = ((ItemBase)object).node.nameToSubType.get(this.damage.toLowerCase());
                if (type == null) return null;
                meta = type.index;
            }
        }
        ItemStack stack = object instanceof Item ? new ItemStack((Item)object, this.count, meta == -1 ? 0 : meta) : new ItemStack((Block)object, this.count, meta == -1 ? 0 : meta);
        if (this.nbt == null || this.nbt.func_82582_d()) return stack;
        stack.func_77982_d(this.nbt);
        return stack;
    }
}

